/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.emd.internal.action;

import com.ibm.j2c.emd.internal.ui.model.XSD_Qname;
import com.ibm.j2c.emd.internal.utils.J2CEmdUtils;
import com.ibm.j2c.emd.internal.xml.XSDResourceVisitor;
import commonj.connector.metadata.description.DataBindingGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDImportImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.w3c.dom.Element;

public class DependencyCalculationJob
extends Job {
    private IFile[] xsdFiles = null;
    private List trips;
    private Hashtable topSchemas;
    private String[] javaRecordNames;

    public DependencyCalculationJob(String name, IFile[] xsdFiles) {
        super(name);
        this.xsdFiles = xsdFiles;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.topSchemas = new Hashtable();
        if (this.xsdFiles != null && this.xsdFiles.length > 0) {
            try {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                ResourceSetImpl topResourceSet = new ResourceSetImpl();
                XSDResourceVisitor visitor = new XSDResourceVisitor();
                this.xsdFiles[0].getProject().accept((IResourceVisitor)visitor);
                List topXsds = visitor.getAllGlobalXSDFiles();
                int g = 0;
                while (g < topXsds.size()) {
                    IFile f = (IFile)topXsds.get(g);
                    IPath p3 = f.getRawLocation();
                    URI uri = URI.createFileURI((String)p3.toString());
                    topResourceSet.createResource(uri);
                    ++g;
                }
                this.javaRecordNames = null;
                int z = 0;
                while (z < this.xsdFiles.length) {
                    IFile xsdFile = this.xsdFiles[z];
                    URI selectedFileUri = URI.createFileURI((String)xsdFile.getRawLocation().toString());
                    resourceSet.createResource(selectedFileUri);
                    Resource targetR = resourceSet.getResource(selectedFileUri, false);
                    XSDSchema targetSchema = this.getXSDSchemaFromResource(targetR, resourceSet.getLoadOptions());
                    XSDTypeDefinition targetNativeType = J2CEmdUtils.getNativeTypeDefinition(targetSchema);
                    this.trips = this.getXSDandGenerators((ResourceSet)topResourceSet, targetNativeType);
                    if (this.trips != null && !this.trips.isEmpty()) {
                        int hh = 0;
                        while (hh < this.trips.size()) {
                            XSD_Qname trip = (XSD_Qname)this.trips.get(hh);
                            XSDSchema topSchema = (XSDSchema)this.topSchemas.get(trip.getPathToGlobalSchema());
                            DataBindingGenerator gen = J2CEmdUtils.getEMDHelper().getDataBindingGenerator(topSchema, xsdFile.getProject());
                            if (gen != null) {
                                File f = new File(trip.getPathToGlobalSchema());
                                String[] newEntries = gen.getDataBindingClassNames(trip.getQN(), f.toURL());
                                if (this.javaRecordNames == null) {
                                    this.javaRecordNames = newEntries;
                                } else if (newEntries != null) {
                                    int iSize = this.javaRecordNames.length + newEntries.length;
                                    String[] tempAr = new String[iSize];
                                    int iCounter = 0;
                                    int i = 0;
                                    while (i < this.javaRecordNames.length) {
                                        tempAr[iCounter] = this.javaRecordNames[i];
                                        ++iCounter;
                                        ++i;
                                    }
                                    i = 0;
                                    while (i < newEntries.length) {
                                        tempAr[iCounter] = newEntries[i];
                                        ++iCounter;
                                        ++i;
                                    }
                                    this.javaRecordNames = tempAr;
                                }
                            }
                            ++hh;
                        }
                    }
                    ++z;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Status.OK_STATUS;
    }

    private XSDSchema getXSDSchemaFromResource(Object resource, Map loadOptions) {
        if (resource == null) {
            return null;
        }
        if (resource instanceof XSDResourceImpl) {
            try {
                XSDResourceImpl xsdResource = (XSDResourceImpl)resource;
                xsdResource.load(loadOptions);
                XSDSchema schema = xsdResource.getSchema();
                return schema;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private List getXSDandGenerators(ResourceSet resourceSet, XSDTypeDefinition targetNativeType) {
        ArrayList<XSD_Qname> res = new ArrayList<XSD_Qname>();
        EList ll1 = resourceSet.getResources();
        int gh = 0;
        while (gh < ll1.size()) {
            Object resource = ll1.get(gh);
            XSDSchema schema2 = this.getXSDSchemaFromResource(resource, resourceSet.getLoadOptions());
            if (schema2 != null) {
                EList lst = schema2.getTypeDefinitions();
                int b = 0;
                while (b < lst.size()) {
                    Object typeO = lst.get(b);
                    if (typeO instanceof XSDComplexTypeDefinition) {
                        XSDComplexTypeDefinition typeD = (XSDComplexTypeDefinition)typeO;
                        EList anns = typeD.getAnnotations();
                        int n = 0;
                        while (n < anns.size()) {
                            XSDAnnotation xsdA = (XSDAnnotation)anns.get(n);
                            EList appInfos = xsdA.getApplicationInformation();
                            int v = 0;
                            while (v < appInfos.size()) {
                                Object o1 = appInfos.get(v);
                                if (o1 instanceof Element) {
                                    Element el = (Element)o1;
                                    String genName = el.getAttribute("source");
                                    boolean rightRoot = false;
                                    if (targetNativeType != null && genName.equals("com.ibm.j2c.core")) {
                                        rightRoot = this.containsTargetSchema(schema2, targetNativeType.getSchema());
                                    }
                                    if (rightRoot) {
                                        String localName = typeD.getName();
                                        String nS = typeD.getTargetNamespace();
                                        QName globalTypeName = new QName(nS, localName);
                                        String pathToGlobalSchema = ((XSDResourceImpl)resource).getURI().toFileString();
                                        this.topSchemas.put(pathToGlobalSchema, schema2);
                                        XSD_Qname w = new XSD_Qname(pathToGlobalSchema, globalTypeName);
                                        res.add(w);
                                    }
                                }
                                ++v;
                            }
                            ++n;
                        }
                    }
                    ++b;
                }
            }
            ++gh;
        }
        return res;
    }

    private boolean containsTargetSchema(XSDSchema sc, XSDSchema targetSchema) {
        if (this.compareSchemaNames(sc, targetSchema)) {
            return true;
        }
        for (XSDSchemaContent xsdSchemaContent : sc.getContents()) {
            boolean b;
            XSDImport xsdImport;
            XSDSchema importedSchema;
            if (!(xsdSchemaContent instanceof XSDSchemaDirective) || !(xsdSchemaContent instanceof XSDImport) || (importedSchema = ((XSDImportImpl)(xsdImport = (XSDImport)xsdSchemaContent)).importSchema()) == null || !(b = this.containsTargetSchema(importedSchema, targetSchema))) continue;
            return true;
        }
        return false;
    }

    private boolean compareSchemaNames(XSDSchema sc1, XSDSchema sc2) {
        String nS1 = sc1.getTargetNamespace();
        String nS2 = sc2.getTargetNamespace();
        String sLoc1 = sc1.getSchemaLocation();
        String sLoc2 = sc2.getSchemaLocation();
        return nS1.equals(nS2) && sLoc1.equals(sLoc2);
    }

    public List getResolvedStructures() {
        return this.trips;
    }

    public Hashtable getTopSchemas() {
        return this.topSchemas;
    }

    public String[] getJavaRecordNames() {
        return this.javaRecordNames;
    }
}

