/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.emd.internal.action;

import com.ibm.j2c.emd.internal.action.CleanUpPreparationJob;
import com.ibm.j2c.emd.internal.action.JobCompletionListener;
import com.ibm.j2c.emd.internal.ui.messages.J2CEMDUIMessages;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CleanUpPreparationRunnable
implements IRunnableWithProgress {
    private CleanUpPreparationJob job;

    public CleanUpPreparationRunnable(IJavaProject javaProject) {
        this.job = new CleanUpPreparationJob(J2CEMDUIMessages.PROJECT_CLEAN_UP_PREPARATION_JOB_NAME, javaProject);
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        boolean loop = true;
        int interval = 1000;
        int totalTime = 0;
        int units = 60;
        progressMonitor.beginTask(J2CEMDUIMessages.RETRIEVING_INFORMATION, units);
        JobCompletionListener listen = new JobCompletionListener();
        this.job.addJobChangeListener(listen);
        this.job.schedule();
        try {
            try {
                while (loop) {
                    if (listen.done) {
                        loop = false;
                    } else {
                        Thread.sleep(interval);
                        totalTime += interval;
                    }
                    progressMonitor.worked(1);
                    if (!progressMonitor.isCanceled()) continue;
                    this.job.cancel();
                    throw new InterruptedException();
                }
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (Exception exception) {
                progressMonitor.worked(units);
            }
        }
        finally {
            progressMonitor.worked(units);
        }
    }

    public List getObsoleteBusinessTypeInfos() {
        if (this.job != null) {
            return this.job.getObsoleteBusinessTypeInfos();
        }
        return null;
    }

    public Hashtable getObsoleteFilesSortedByPackageName() {
        if (this.job != null) {
            return this.job.getObsoleteFilesSortedByPackageName();
        }
        return null;
    }
}

