/*******************************************************************************
 * Licensed Material - Property of IBM
 * (C) Copyright IBM Corp. 2004, 2006 - All Rights Reserved.
 * US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *******************************************************************************/
package sample.ims;

import com.ibm.etools.marshall.util.MarshallIntegerUtils;
import sample.ims.data.*;

public class TestMultiSeg
{
	public static void main (String[] args)
	{
		byte[] segBytes = null;
		int srcPos = 0;
		int dstPos = 0;
		int totalLen = 0;
		int remainLen = 0;
		byte[] buff;
		short LL = 0;
		short ZZ = 0;

		try
		{
			// ---------------------------------------------------			
			// Populate the IMS transaction input message with
			// data.  Use the input message format handler method 
			// getSize() to set the LL field of the input message.
			// ---------------------------------------------------					
			InputMsg input = new InputMsg();
			input.setIn__ll((short) input.getSize());
			input.setIn__zz((short) 0);
			//-----------------------------------------------------------
			// find out the transaction code from your IMS administrator
			//----------------------------------------------------------
			input.setIn__trcd("SKS6 ");
			input.setIn__data1("M2 SI1");
			input.setIn__data2("M3 SI1");

			// ---------------------------------------------------			
			// Run the IMS transaction.  The multi-segment output 
			// message is returned.
			// ---------------------------------------------------				
			MSOImpl proxy = new MSOImpl();
			
			sample.ims.CCIBuffer output = proxy.runMultiSegOutput(input);

			// ---------------------------------------------------	
			// Retrieve the multi-segment output message as a 
			// byte array using the output message format
			// handler method getBytes().
			// ---------------------------------------------------			 			
			System.out.println(
				"\nSize of output message is: " + output.getSize());
			segBytes = output.getBytes();

			srcPos = 0;
			dstPos = 0;
			totalLen = segBytes.length;
			remainLen = totalLen;

			// ---------------------------------------------------	
			// Populate first segment object from buffer. 
			// ---------------------------------------------------			             
			buff = null;
			// Get length of segment.
			LL =
				MarshallIntegerUtils.unmarshallTwoByteIntegerFromBuffer(
					segBytes,
					srcPos,
					true,
					MarshallIntegerUtils.SIGN_CODING_TWOS_COMPLEMENT);

			// Put segment in byte array.
			buff = new byte[LL];
			System.arraycopy(segBytes, srcPos, buff, dstPos, LL);
			remainLen -= LL;

			// Create and populate segment object from byte array.
			OutputSeg1 S1 = new OutputSeg1();
			S1.setBytes(buff);
			System.out.println(
				"\nOutSeg1 LL is:    "
					+ S1.getOut__ll()
					+ "\nOutSeg1 ZZ is:    "
					+ S1.getOut__zz()
					+ "\nOutSeg1_DATA1 is: "
					+ S1.getOut__data1());

			// ---------------------------------------------------	
			// Populate second segment object from buffer. 
			// ---------------------------------------------------	
			srcPos += LL;
			buff = null;
			// Get length of segment.
			LL =
				MarshallIntegerUtils.unmarshallTwoByteIntegerFromBuffer(
					segBytes,
					srcPos,
					true,
					MarshallIntegerUtils.SIGN_CODING_TWOS_COMPLEMENT);

			// Put segment in byte array.
			buff = new byte[LL];
			System.arraycopy(segBytes, srcPos, buff, dstPos, LL);
			remainLen -= LL;

			// Create and populate segment object from byte array.
			
			OutputSeg2 S2 = new OutputSeg2();
			S2.setBytes(buff);
			System.out.println(
				"\nOutSeg2 LL is:    "
					+ S2.getOut__ll()
					+ "\nOutSeg2 ZZ is:    "
					+ S2.getOut__zz()
					+ "\nOutSeg2_DATA1 is: "
					+ S2.getOut__data1()
					+ "\nOutSeg2_DATA2 is: "
					+ S2.getOut__data2());
			// ---------------------------------------------------				
			// Populate third segment object from buffer. 
			// ---------------------------------------------------	
			srcPos += LL;
			buff = null;
			// Get length of segment.
			LL =
				MarshallIntegerUtils.unmarshallTwoByteIntegerFromBuffer(
					segBytes,
					srcPos,
					true,
					MarshallIntegerUtils.SIGN_CODING_TWOS_COMPLEMENT);

			// Put segment in byte array.
			buff = new byte[LL];
			System.arraycopy(segBytes, srcPos, buff, dstPos, LL);
			remainLen -= LL;

			// Create and populate segment object from byte array.
			OutputSeg3 S3 = new OutputSeg3();
			S3.setBytes(buff);
			System.out.println(
				"\nOutSeg3 LL is:    "
					+ S3.getOut__ll()
					+ "\nOutSeg3 ZZ is:    "
					+ S3.getOut__zz()
					+ "\nOutSeg3_DATA1 is: "
					+ S3.getOut__data1()
					+ "\nOutSeg3_DATA2 is: "
					+ S3.getOut__data2()
					+ "\nOutSeg3_DATA3 is: "
					+ S3.getOut__data3());
		}
		catch (Exception e)
		{
			System.out.println("\nCaught exception is: " + e);
		}
	}
}
