/*******************************************************************************
 * Licensed Material - Property of IBM
 * (C) Copyright IBM Corp. 2004, 2006 - All Rights Reserved.
 * US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *******************************************************************************/
/*
 * Created on 4-Oct-2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package sample.ims;
import sample.ims.data.*;
import com.ibm.connector2.ims.ico.IMSDFSMessageException;

/**
 * @author ivyho
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class TestInOutProxy
{
	public static void main (String[] args)
	{
		try
		{
			// ---------------------------------------------------	
			// Create the formatHandler, then create the input
			// message bean from the formatHandler. 
			// ---------------------------------------------------	
			INOUTMSG input = new INOUTMSG();

			int sz = input.getSize();
			System.out.println("\nInitial size of input message is: " + sz);

			// ---------------------------------------------------		
			// Don't set the length (LL) field yet... wait until 
			// input message has been adjusted to reflect only
			// the number of array elements actually sent. 
			// ---------------------------------------------------	
			input.setWs__zz((short) 0);
			input.setWs__trcd("SKS7 ");

			// ---------------------------------------------------
			// Construct an array and populate it with the elements
			// to be sent to the IMS application program.  In this
			// case three elements are sent.  
			// ---------------------------------------------------	
			Inoutmsg_ws__customer[] customers = new Inoutmsg_ws__customer[3];

			Inoutmsg_ws__customer aCustomer1 = new Inoutmsg_ws__customer();
			aCustomer1.setWs__cust__name("Cathy Tang");
			aCustomer1.setWs__cust__number("CN001");
			customers[0] = aCustomer1;

			Inoutmsg_ws__customer aCustomer2 = new Inoutmsg_ws__customer();
			aCustomer2.setWs__cust__name("Haley Fung");
			aCustomer2.setWs__cust__number("CN002");
			customers[1] = aCustomer2;

			Inoutmsg_ws__customer aCustomer3 = new Inoutmsg_ws__customer();
			aCustomer3.setWs__cust__name("Steve Kuo");
			aCustomer3.setWs__cust__number("CN003");
			customers[2] = aCustomer3;

			// ---------------------------------------------------
			// Set the array on the input message.
			// ---------------------------------------------------
			input.setWs__customer(customers);
			input.setIndx((short) 3);
			
			System.out.println("\nInitial value of INDX is: " + input.getIndx());			

			// ---------------------------------------------------			
			// Reallocate the buffer to the actual size 
			// ---------------------------------------------------			
			byte[] bytes = input.getBytes();
			int size = input.getSize();
			byte[] newBytes = new byte[size];
			System.arraycopy(bytes, 0, newBytes, 0, size);

			// ---------------------------------------------------			
			// Set the bytes back into the format handler and set
			// the length field of the input message, now that 
			// we know the actual size.
			// ---------------------------------------------------			
			input.setBytes(newBytes);
			input.setWs__ll((short) size);
			System.out.println("\nAdjusted size of input message is: " + size);
			System.out.println("\nAdjusted size of INDX is: " + input.getIndx());				

			// ---------------------------------------------------
			// Set fields that follow the array after the input 
			// message has been adjusted.  
			// ---------------------------------------------------			 			
			input.setWs__func__code("123456");

			InOutImpl proxy = new InOutImpl();

			INOUTMSG output = new sample.ims.data.INOUTMSG();
			output = proxy.runInOut(input);

			short outndx = output.getIndx();
			System.out.println("\nOutput value of INDX is: " + outndx);

			Inoutmsg_ws__customer outArray[] = output.getWs__customer();

			for (int i = 0; i < outndx; i++)
			{
				System.out.println(
					"\n"
						+ outArray[i].getWs__cust__name()
						+ outArray[i].getWs__cust__number());
			}
		}
		catch (Exception e)
		{
			if (e instanceof IMSDFSMessageException)
			{
				System.out.println(
					"\nIMS returned message: "
						+ ((IMSDFSMessageException) e).getDFSMessage());
			}
			else
			{
				System.out.println(
					"\nIMS Connector exception is: " + e);
			}
		}
	}
}