/*******************************************************************************
 * Licensed Material - Property of IBM
 * (C) Copyright IBM Corp. 2004, 2006 - All Rights Reserved.
 * US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *******************************************************************************/
package sample.cics;

import sample.cics.data.*;
public class TestECIMPO
{

	

	public static void process(InputComm input)
	{
		
	 System.out.println("processing....");
     try {
		//CustomerInfoMOImpl proxy = new CustomerInfoMOImpl();
		CustomerInfoMOImpl proxy = new CustomerInfoMOImpl();
     	OutputComm output = proxy.getCustomerInfo (input);

		BadCust badCust = output.getBadCust();
		PrefCust prefCust = output.getPrefCust();
		RegCust regCust = output.getRegCust();

		if (regCust != null)
		{
			System.out.println("Reg Customer");
			System.out.println("account name:  " + regCust.getAccountname());
			System.out.println("balance:  " + regCust.getBalance());
			System.out.println("cust code:  " + regCust.getRcustcode());
			System.out.println("cust no:  " + regCust.getRcustno());
		}
		else if (prefCust != null)
		{
			System.out.println("Pref Customer");
			System.out.println("assets:  " + prefCust.getAssets());
			System.out.println("cust code:  " + prefCust.getPcustcode());
			System.out.println("cust no:  " + prefCust.getPcustno());
		}
		else if (badCust != null)
		{
			System.out.println("Bad Customer");
			System.out.println("amount:  " + badCust.getAmount());
			System.out.println("cust code:  " + badCust.getBcustcode());
			System.out.println("cust no:  " + badCust.getBcustno());
			System.out.println("days overdue:  " + badCust.getDaysoverdue());
		}
		else
			System.out.println("No match");
	}
	catch (Exception exc)
	{
		System.out.println (exc);
		exc.printStackTrace();
	}
		
	}
	
	public static void testPrefCust()
	{
	   System.out.println("===========testPreCust==============");
	try {
		InputComm input = new InputComm();
		String prefC = "12345";
		input.setICustNo (prefC);
		process(input);
	}
	catch (Exception exc)
	{
		System.out.println (exc);
		exc.printStackTrace();
	}	
		
				
	}
	
	public static void testRegCust()
	{
	   System.out.println("===========testRegCust==============");
	try {
		InputComm input = new InputComm();
		String regC = "34567";
		input.setICustNo (regC);
		process(input);
	}
	catch (Exception exc)
	{
		System.out.println (exc);
		exc.printStackTrace();
	}
	
	}
	
	public static void testBadCust()
	{
	  
		System.out.println("===========testBadCust==============");
	try {
		
		InputComm input = new InputComm();
		String badC = "123";
		input.setICustNo (badC);
		process(input);
		
	}
	catch (Exception exc)
	{
		System.out.println (exc);
		exc.printStackTrace();
	}
	}
	
	
	public static void main (String[] args)
	{
		testPrefCust();
		testRegCust();
		testBadCust();
		
	}
}
