/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.cheatsheet.actions;

import com.ibm.j2c.cheatsheet.actions.CheatSheetActionsPlugin;
import com.ibm.j2c.cheatsheet.wizards.NonModalWizardDialog;
import com.ibm.j2c.ui.wizards.J2CWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.ICheatSheetAction;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;

public class J2CWizardWalkthrough
extends Action
implements ICheatSheetAction {
    private static NonModalWizardDialog j2cWizardDialog;
    private static IWizardPage currentPage;

    public void run(String[] params, ICheatSheetManager manager) {
        if (params == null || params[0] == null) {
            return;
        }
        if (params[0].equals("createWizard")) {
            this.createWizard();
        } else if (params[0].equals("performFinish") && currentPage != null) {
            this.performFinish();
        } else if (params[0].equals("showPage") && params[1] != null) {
            this.showPage(params[1]);
        }
    }

    private void createWizard() {
        if (j2cWizardDialog != null && j2cWizardDialog.getShell() != null && !j2cWizardDialog.getShell().isDisposed()) {
            j2cWizardDialog.close();
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        StructuredSelection selection = new StructuredSelection();
        J2CWizard j2cWizard = new J2CWizard();
        j2cWizard.init(workbench, (IStructuredSelection)selection);
        Shell shell = Display.getCurrent().getActiveShell();
        j2cWizardDialog = new NonModalWizardDialog(shell, (IWizard)j2cWizard);
        j2cWizardDialog.setBlockOnOpen(false);
        j2cWizardDialog.create();
        j2cWizardDialog.getShell().setFocus();
        j2cWizardDialog.open();
        currentPage = j2cWizard.getStartingPage();
    }

    private void showPage(String pageName) {
        if (j2cWizardDialog == null || j2cWizardDialog.getShell() == null || j2cWizardDialog.getShell().isDisposed()) {
            this.terminateWithError("%J2CWizardInvalidPage_ERROR");
            return;
        }
        IWizard wizard = j2cWizardDialog.getCurrentPage().getWizard();
        IWizardPage page = wizard.getPage(pageName);
        if (page == null) {
            return;
        }
        if (currentPage != null && !this.canMoveToPage(wizard, page)) {
            this.terminateWithError("%J2CWizardCannotProceed_ERROR");
            return;
        }
        if (currentPage != null) {
            currentPage.getNextPage();
        }
        j2cWizardDialog.showPage(page);
        currentPage = page;
    }

    private boolean canMoveToPage(IWizard wizard, IWizardPage page) {
        IWizardPage[] pages = wizard.getPages();
        int curPageIndex = -1;
        int i = 0;
        while (i < pages.length) {
            if (pages[i].equals(currentPage)) {
                curPageIndex = i;
            } else if (pages[i].equals(page)) {
                if (curPageIndex != -1 && curPageIndex <= i) break;
                return true;
            }
            ++i;
        }
        IWizardPage tempPage = currentPage;
        while (!tempPage.equals(page)) {
            if (!tempPage.canFlipToNextPage()) {
                return false;
            }
            tempPage = wizard.getNextPage(tempPage);
        }
        return true;
    }

    private void performFinish() {
        if (j2cWizardDialog != null && j2cWizardDialog.getShell() != null && !j2cWizardDialog.getShell().isDisposed()) {
            if (!j2cWizardDialog.getCurrentPage().getWizard().canFinish()) {
                this.terminateWithError("%J2CWizardFinish_ERROR");
                return;
            }
            j2cWizardDialog.getCurrentPage().getWizard().performFinish();
            j2cWizardDialog.close();
        }
    }

    private void terminateWithError(String error) {
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), null, (String)CheatSheetActionsPlugin.getResourceString(error));
        this.notifyResult(false);
    }
}

