/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.websphere.internal.util;

import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndFactory;
import com.ibm.ejs.models.base.bindings.commonbnd.Property;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBindingsHelper;
import com.ibm.etools.sdo.jdbc.ui.internal.deploy.WASExtensions;
import com.ibm.etools.sdo.jdbc.ui.internal.util.DatasourceConnectionWrapper;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.DatasourceConnection;
import com.ibm.etools.webtools.webproject.features.taglibs.internal.util.RuntimeUtil;
import com.ibm.jee.was.descriptors.web.WebBindingsDescriptor;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class WASExtensionsImpl
implements WASExtensions {
    public void createWASResourceRefExtension(IProject project, WebArtifactEdit webEditModel, DatasourceConnection dataSourceConnection, IRuntime runtime, ResourceRef thisResourceRef) {
        boolean isWebProject = JavaEEProjectUtilities.isDynamicWebProject((IProject)project);
        String projectVersion = JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)project);
        if (isWebProject && projectVersion.equals("2.5")) {
            WebBindingsDescriptor webBindDesc = new WebBindingsDescriptor(project);
            String resourceRefName = thisResourceRef.getName();
            String authAliasName = null;
            if (dataSourceConnection.getUserid() != null && dataSourceConnection.getUserid().length() > 0) {
                String id = dataSourceConnection.getId();
                if (id != null && id.endsWith("_runtime")) {
                    authAliasName = id.substring(0, id.length() - "_runtime".length());
                }
                if (authAliasName == null) {
                    authAliasName = dataSourceConnection.getConnectionString();
                }
            }
            try {
                webBindDesc.setResourceRefBinding(resourceRefName, dataSourceConnection.getJndiName(), authAliasName);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            CommonbndFactory bndFact = CommonbndFactory.eINSTANCE;
            ResourceRefBinding resourceRefBnd = bndFact.createResourceRefBinding();
            resourceRefBnd.setJndiName(dataSourceConnection.getJndiName());
            resourceRefBnd.setBindingResourceRef(thisResourceRef);
            if (RuntimeUtil.isTargetedAtWAS6AndAboveRuntime((IRuntime)runtime) && dataSourceConnection.isAutoDeploy() && dataSourceConnection.getUserid() != null && dataSourceConnection.getUserid().length() > 0) {
                resourceRefBnd.setLoginConfigurationName("DefaultPrincipalMapping");
                Property property = CommonbndFactory.eINSTANCE.createProperty();
                property.setName("com.ibm.mapping.authDataAlias");
                String alias = null;
                String id = dataSourceConnection.getId();
                if (id != null && id.endsWith("_runtime")) {
                    alias = "wdo_" + id.substring(0, id.length() - "_runtime".length());
                }
                if (alias == null) {
                    alias = "wdo_" + dataSourceConnection.getConnectionString();
                }
                property.setValue(alias);
                resourceRefBnd.getProperties().add((Object)property);
            }
            WebAppBindingsHelper.getWebAppBinding((WebApp)webEditModel.getWebApp()).getResRefBindings().add((Object)resourceRefBnd);
        }
    }

    private boolean setJDNIName(ResourceRefBinding resourceRefBinding, DatasourceConnection dataSourceConnection, boolean edited) {
        if (dataSourceConnection.getJndiName() != null && !dataSourceConnection.getJndiName().equals("") && resourceRefBinding != null && resourceRefBinding.getJndiName() != null && !resourceRefBinding.getJndiName().equals(dataSourceConnection.getJndiName())) {
            resourceRefBinding.setJndiName(dataSourceConnection.getJndiName());
            edited = true;
        }
        return edited;
    }

    public void removeWASResourceRefExtension(IProject project, WebArtifactEdit webEditModel, ResourceRef resourceRef) {
        boolean isWebProject = JavaEEProjectUtilities.isDynamicWebProject((IProject)project);
        String projectVersion = JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)project);
        if (isWebProject && projectVersion.equals("2.5")) {
            WebBindingsDescriptor webBindDesc = new WebBindingsDescriptor(project);
            try {
                webBindDesc.removeResourceRefBinding(resourceRef.getName());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            WebAppBinding webAppBinding = WebAppBindingsHelper.getWebAppBinding((WebApp)webEditModel.getWebApp());
            Iterator iter = webAppBinding.getResRefBindings().iterator();
            while (iter.hasNext()) {
                ResourceRefBinding resourceRefBnd = (ResourceRefBinding)iter.next();
                if (resourceRefBnd.getBindingResourceRef() != resourceRef) continue;
                iter.remove();
                break;
            }
        }
    }

    public boolean modifyWASResourceRefExtension(IProject project, WebApp app, ResourceRef resourceRef, IRuntime newRuntime, Map dataSourceConnections, boolean edited, boolean updateAuthAlias) {
        boolean isWebProject = JavaEEProjectUtilities.isDynamicWebProject((IProject)project);
        String projectVersion = JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)project);
        if (isWebProject && projectVersion.equals("2.5")) {
            WebBindingsDescriptor webBindDesc = new WebBindingsDescriptor(project);
            String resourceRefName = resourceRef.getName();
            String authAliasName = null;
            Object wrapper = dataSourceConnections.get(resourceRef.getName());
            if (wrapper == null) {
                String name = String.valueOf(resourceRef.getName()) + "_runtime";
                wrapper = dataSourceConnections.get(name);
            }
            String userID = null;
            if (wrapper instanceof DatasourceConnection) {
                userID = ((DatasourceConnection)wrapper).getUserid();
            } else if (wrapper instanceof DatasourceConnectionWrapper) {
                userID = ((DatasourceConnectionWrapper)wrapper).getUserid();
            }
            if (userID == null || userID.length() == 0) {
                try {
                    webBindDesc.removeResourceRefAuthAlias(resourceRefName);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    String authName = webBindDesc.getResourceRefAuthenticationAlias(resourceRefName);
                    if (authName == null) {
                        updateAuthAlias = true;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (updateAuthAlias) {
                String jndiName = null;
                if (resourceRef.getName() != null && wrapper != null) {
                    String id;
                    if (wrapper instanceof DatasourceConnection) {
                        id = ((DatasourceConnection)wrapper).getId();
                        jndiName = ((DatasourceConnection)wrapper).getJndiName();
                        authAliasName = id != null && id.endsWith("_runtime") ? id.substring(0, id.length() - "_runtime".length()) : ((DatasourceConnection)wrapper).getConnectionString();
                    } else if (wrapper instanceof DatasourceConnectionWrapper) {
                        id = ((DatasourceConnectionWrapper)wrapper).getId();
                        jndiName = ((DatasourceConnectionWrapper)wrapper).getJndiName();
                        authAliasName = id != null && id.endsWith("_runtime") ? id.substring(0, id.length() - "_runtime".length()) : ((DatasourceConnectionWrapper)wrapper).getConnectionString();
                    }
                }
                try {
                    webBindDesc.setResourceRefBinding(resourceRefName, jndiName, authAliasName);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        } else {
            WebAppBinding webAppBinding = WebAppBindingsHelper.getWebAppBinding((WebApp)app);
            for (ResourceRefBinding resourceRefBnd : webAppBinding.getResRefBindings()) {
                String name;
                Object wrapper;
                if (resourceRefBnd.getBindingResourceRef() != resourceRef) continue;
                if (RuntimeUtil.isTargetedAtWAS6AndAboveRuntime((IRuntime)newRuntime)) {
                    String id;
                    Property property;
                    wrapper = dataSourceConnections.get(resourceRef.getName());
                    if (wrapper == null) {
                        name = String.valueOf(resourceRef.getName()) + "_runtime";
                        wrapper = dataSourceConnections.get(name);
                    }
                    String userID = null;
                    if (wrapper instanceof DatasourceConnection) {
                        userID = ((DatasourceConnection)wrapper).getUserid();
                    } else if (wrapper instanceof DatasourceConnectionWrapper) {
                        userID = ((DatasourceConnectionWrapper)wrapper).getUserid();
                    }
                    if (userID == null || userID.length() == 0) {
                        if (resourceRefBnd.getLoginConfigurationName() != null) {
                            resourceRefBnd.unsetLoginConfigurationName();
                        }
                        EList props = resourceRefBnd.getProperties();
                        int i = 0;
                        while (i < props.size()) {
                            Property p = (Property)props.get(i);
                            if (p.getName().equals("com.ibm.mapping.authDataAlias")) {
                                props.remove(p);
                                edited = true;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (userID != null && userID.length() > 0 && !"DefaultPrincipalMapping".equals(resourceRefBnd.getLoginConfigurationName())) {
                        resourceRefBnd.setLoginConfigurationName("DefaultPrincipalMapping");
                        if (resourceRef.getName() != null && wrapper != null) {
                            property = CommonbndFactory.eINSTANCE.createProperty();
                            property.setName("com.ibm.mapping.authDataAlias");
                            String alias = "";
                            if (wrapper instanceof DatasourceConnection) {
                                id = ((DatasourceConnection)wrapper).getId();
                                alias = id != null && id.endsWith("_runtime") ? "wdo_" + id.substring(0, id.length() - "_runtime".length()) : "wdo_" + ((DatasourceConnection)wrapper).getConnectionString();
                            } else if (wrapper instanceof DatasourceConnectionWrapper) {
                                id = ((DatasourceConnectionWrapper)wrapper).getId();
                                alias = id != null && id.endsWith("_runtime") ? "wdo_" + id.substring(0, id.length() - "_runtime".length()) : "wdo_" + ((DatasourceConnectionWrapper)wrapper).getConnectionString();
                            }
                            property.setValue(alias);
                            resourceRefBnd.getProperties().add((Object)property);
                            edited = true;
                        }
                    }
                    if (updateAuthAlias) {
                        property = CommonbndFactory.eINSTANCE.createProperty();
                        property.setName("com.ibm.mapping.authDataAlias");
                        String alias = "";
                        if (wrapper instanceof DatasourceConnection) {
                            id = ((DatasourceConnection)wrapper).getId();
                            alias = id != null && id.endsWith("_runtime") ? "wdo_" + id.substring(0, id.length() - "_runtime".length()) : "wdo_" + ((DatasourceConnection)wrapper).getConnectionString();
                        } else if (wrapper instanceof DatasourceConnectionWrapper) {
                            id = ((DatasourceConnectionWrapper)wrapper).getId();
                            alias = id != null && id.endsWith("_runtime") ? "wdo_" + id.substring(0, id.length() - "_runtime".length()) : "wdo_" + ((DatasourceConnectionWrapper)wrapper).getConnectionString();
                        }
                        property.setValue(alias);
                        EList properties = resourceRefBnd.getProperties();
                        boolean found = false;
                        for (Object object : properties) {
                            Property prop = (Property)object;
                            if (!prop.getName().equals("com.ibm.mapping.authDataAlias")) continue;
                            if (prop.getValue() == null || !prop.getValue().equals(alias)) {
                                prop.setValue(alias);
                                edited = true;
                            }
                            found = true;
                            break;
                        }
                        if (!found) {
                            resourceRefBnd.getProperties().add((Object)property);
                            edited = true;
                        }
                    }
                } else if ("DefaultPrincipalMapping".equals(resourceRefBnd.getLoginConfigurationName())) {
                    resourceRefBnd.unsetLoginConfigurationName();
                    Iterator iterator = resourceRefBnd.getProperties().iterator();
                    while (iterator.hasNext()) {
                        Property property = (Property)iterator.next();
                        if (!"com.ibm.mapping.authDataAlias".equals(property.getName())) continue;
                        iterator.remove();
                        break;
                    }
                    if (resourceRefBnd.getProperties().isEmpty()) {
                        resourceRefBnd.unsetProperties();
                    }
                    edited = true;
                }
                if ((wrapper = dataSourceConnections.get(resourceRef.getName())) == null) {
                    name = String.valueOf(resourceRef.getName()) + "_runtime";
                    wrapper = dataSourceConnections.get(name);
                }
                if (!(wrapper instanceof DatasourceConnection)) continue;
                edited = this.setJDNIName(resourceRefBnd, (DatasourceConnection)wrapper, edited);
            }
        }
        return edited;
    }

    public String getJNDI(IProject project, WebArtifactEdit webEditModel, ResourceRef resourceRef) {
        String ret = "";
        boolean isWebProject = JavaEEProjectUtilities.isDynamicWebProject((IProject)project);
        String projectVersion = JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)project);
        if (isWebProject && projectVersion.equals("2.5")) {
            WebBindingsDescriptor webBindDesc = new WebBindingsDescriptor(project);
            try {
                ret = webBindDesc.getResourceRefBindingsName(resourceRef.getName());
                if (ret == null) {
                    ret = "";
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            WebAppBinding webAppBinding = WebAppBindingsHelper.getWebAppBinding((WebApp)webEditModel.getWebApp());
            int i = 0;
            while (i < webAppBinding.getResRefBindings().size()) {
                ResourceRefBinding resourceRefBnd = (ResourceRefBinding)webAppBinding.getResRefBindings().get(i);
                if (resourceRefBnd.getBindingResourceRef() == resourceRef) {
                    ret = resourceRefBnd.getJndiName();
                    break;
                }
                ++i;
            }
        }
        return ret;
    }
}

