/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.webpage.wizard.internal.advancedoptions.providers;

import com.ibm.etools.webpage.template.selection.core.ITemplateDescriptor;
import com.ibm.etools.webtools.webpage.core.internal.util.WebPageModelUtil;
import com.ibm.etools.webtools.webpage.ui.AdvancedOptionCompositeProvider;
import com.ibm.etools.webtools.webpage.wizard.internal.nls.Messages;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;

public class MarkupOptionCompositeProvider
extends AdvancedOptionCompositeProvider
implements IDataModelListener {
    private static final int INDENT = 15;
    protected Combo wtDocTypeCombo;
    protected Combo wtCharEncodingSettings;
    protected Combo wtContentTypeCombo;
    private Combo wtMarkupCombo;
    private Label ianaLabel;

    public Composite getContents(Composite parent) {
        Composite baseComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        baseComposite.setLayout((Layout)layout);
        baseComposite.setLayoutData((Object)new GridData(768));
        this.createCharacterEncodingControl(baseComposite);
        boolean isStaticPage = "STATIC".equals(this.model.getStringProperty("IWebPageDataModelProperties.PAGE_TYPE"));
        boolean isJSPFragment = this.model.isProperty("IJSPWebPageDataModelProperties.GENERATE_FRAGMENT") && this.model.getBooleanProperty("IJSPWebPageDataModelProperties.GENERATE_FRAGMENT");
        boolean hasDotJSPFileExtension = this.model.getStringProperty("IWebPageDataModelProperties.FILE_EXTENSION").equalsIgnoreCase("jsp");
        if (isStaticPage || !isJSPFragment || hasDotJSPFileExtension) {
            Label separator = new Label(baseComposite, 258);
            GridData data = new GridData(768);
            data.horizontalSpan = 3;
            separator.setLayoutData((Object)data);
            if (isStaticPage || !isJSPFragment) {
                this.createMarkupComposite(baseComposite);
            }
            if (isStaticPage || !isJSPFragment || hasDotJSPFileExtension) {
                this.createContentTypeControls(baseComposite);
            }
            if (isStaticPage || !isJSPFragment) {
                this.createDocTypeComposite(baseComposite);
            }
        }
        this.model.addListener((IDataModelListener)this);
        return baseComposite;
    }

    protected void createCharacterEncodingControl(Composite composite) {
        Composite encodingComposite = new Composite(composite, 0);
        encodingComposite.setLayout((Layout)new GridLayout(3, false));
        GridData gData = new GridData(768);
        gData.horizontalSpan = 3;
        encodingComposite.setLayoutData((Object)gData);
        Label descriptionLabel = new Label(encodingComposite, 0);
        descriptionLabel.setText(Messages.MarkupOptionCompositeProvider_The_following_encoding_will_apply);
        gData = new GridData();
        gData.horizontalSpan = 3;
        descriptionLabel.setLayoutData((Object)gData);
        MarkupOptionCompositeProvider.createSpacer(encodingComposite);
        if (this.model.isPropertyEnabled("IWebPageDataModelProperties.ENCODING")) {
            Label encodingLabel = new Label(encodingComposite, 0);
            encodingLabel.setText(Messages.MarkupOptionCompositeProvider_Encoding);
            gData = new GridData();
            gData.horizontalIndent = 15;
            encodingLabel.setLayoutData((Object)gData);
            this.wtCharEncodingSettings = new Combo(encodingComposite, 12);
            gData = new GridData(768);
            this.wtCharEncodingSettings.setLayoutData((Object)gData);
            this.synchHelper.synchCombo(this.wtCharEncodingSettings, "IWebPageDataModelProperties.ENCODING", null);
            MarkupOptionCompositeProvider.createSpacer(encodingComposite);
        }
        Label ianaDescLabel = new Label(encodingComposite, 0);
        ianaDescLabel.setText("IANA:");
        gData = new GridData();
        gData.horizontalIndent = 15;
        ianaDescLabel.setLayoutData((Object)gData);
        this.ianaLabel = new Label(encodingComposite, 0);
        gData = new GridData(768);
        this.ianaLabel.setLayoutData((Object)gData);
        if (this.model.isPropertyEnabled("IWebPageDataModelProperties.ENCODING")) {
            this.ianaLabel.setText(WebPageModelUtil.getEncoding((IDataModel)this.model));
        } else {
            this.ianaLabel.setText(String.valueOf(WebPageModelUtil.getEncoding((IDataModel)this.model)) + Messages.MarkupOptionCompositeProvider_0);
        }
    }

    protected void createMarkupComposite(Composite composite) {
        Label markupLabel = new Label(composite, 0);
        markupLabel.setText(Messages.MarkupOptionCompositeProvider_Markup_Language);
        this.wtMarkupCombo = new Combo(composite, 12);
        this.wtMarkupCombo.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchCombo(this.wtMarkupCombo, "IWebPageDataModelProperties.MARKUP_LANGUAGE", null);
        MarkupOptionCompositeProvider.createSpacer(composite);
    }

    protected void createDocTypeComposite(Composite composite) {
        Label docTypeLabel = new Label(composite, 0);
        docTypeLabel.setText(Messages.MarkupOptionCompositeProvider_Document_Type);
        this.wtDocTypeCombo = new Combo(composite, 12);
        this.wtDocTypeCombo.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchCombo(this.wtDocTypeCombo, "IWebPageDataModelProperties.DOCTYPE", null);
        MarkupOptionCompositeProvider.createSpacer(composite);
        MarkupOptionCompositeProvider.createSpacer(composite);
        if (this.model.isProperty("IJSPWebPageDataModelProperties.XML_SYNTAX")) {
            Button useXMLSyntaxButton = new Button(composite, 32);
            useXMLSyntaxButton.setText(Messages.MarkupOptionCompositeProvider_Use_XML_Syntax);
            GridData gData = new GridData();
            gData.horizontalSpan = 2;
            useXMLSyntaxButton.setLayoutData((Object)gData);
            this.synchHelper.synchCheckbox(useXMLSyntaxButton, "IJSPWebPageDataModelProperties.XML_SYNTAX", null);
        }
    }

    protected void createContentTypeControls(Composite composite) {
        Label contentTypeLabel = new Label(composite, 0);
        contentTypeLabel.setText(Messages.MarkupOptionCompositeProvider_Content_Type);
        this.wtContentTypeCombo = new Combo(composite, 12);
        this.wtContentTypeCombo.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchCombo(this.wtContentTypeCombo, "IWebPageDataModelProperties.CONTENT_TYPE", null);
        MarkupOptionCompositeProvider.createSpacer(composite);
    }

    protected static final void createSpacer(Composite composite) {
        new Label(composite, 0);
    }

    @Override
    public boolean shouldShow(IDataModel model) {
        boolean shouldShow = true;
        ITemplateDescriptor template = (ITemplateDescriptor)model.getProperty("IWebPageDataModelProperties.TEMPLATE");
        if (template.getCategory() != 2 && !model.getBooleanProperty("IWebPageDataModelProperties.LINK_PAGE_TO_TEMPLATE")) {
            boolean isTiles = template.isTiles();
            boolean isSampleTemplate = template.getCategory() == 1;
            shouldShow = !isTiles && !isSampleTemplate;
        }
        return shouldShow;
    }

    @Override
    public List getPropertyNames() {
        return null;
    }

    @Override
    public void doDispose() {
        this.model.removeListener((IDataModelListener)this);
    }

    public void propertyChanged(DataModelEvent event) {
        if ("IWebPageDataModelProperties.ENCODING".equals(event.getPropertyName())) {
            this.ianaLabel.setText(WebPageModelUtil.getEncoding((IDataModel)this.model));
        }
    }
}

