/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.webpage.wizard.internal;

import com.ibm.etools.webpage.template.selection.core.ITemplateDescriptor;
import com.ibm.etools.webpage.template.selection.ui.PageTemplateSelector;
import com.ibm.etools.webpage.template.selection.ui.PageThumbnailLabelProvider;
import com.ibm.etools.webpage.template.selection.ui.TemplateTreeContentProvider;
import com.ibm.etools.webtools.webpage.core.internal.util.ProjectFacetsUtil;
import com.ibm.etools.webtools.webpage.core.internal.util.WebPageModelUtil;
import com.ibm.etools.webtools.webpage.ui.internal.IContextHelpIDs;
import com.ibm.etools.webtools.webpage.ui.internal.WebPageGenUIPlugin;
import com.ibm.etools.webtools.webpage.wizard.internal.BasicTemplateContentProvider;
import com.ibm.etools.webtools.webpage.wizard.internal.BasicThumbnailLabelProvider;
import com.ibm.etools.webtools.webpage.wizard.internal.advancedoptions.AdvancedOptionsDialog;
import com.ibm.etools.webtools.webpage.wizard.internal.nls.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.FieldAssistColors;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class NewWebPageWizardPage
extends DataModelWizardPage
implements ISelectionChangedListener {
    protected Button fBrowseButton;
    private Button fOptionsButton;
    protected static final Rectangle DEFAULT_THUMB_SIZE = new Rectangle(0, 0, 80, 80);
    protected PageTemplateSelector fTemplateSelector;

    public NewWebPageWizardPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setTitle(Messages.NewWebPageWizardPage_page_title);
        this.setDescription(Messages.NewWebPageWizardPage_page_description);
    }

    public NewWebPageWizardPage(IDataModel model, String pageName, String title, ImageDescriptor titleImage) {
        super(model, pageName, title, titleImage);
    }

    protected void setContextHelp(Control control) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, IContextHelpIDs.WEBPAGE_WIZARD);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IWebPageCreationDataModelProperties.PROJECT", "IWebPageCreationDataModelProperties.FOLDER", "IWebPageDataModelProperties.FILE_NAME", "IWebPageDataModelProperties.TEMPLATE", "IWebPageDataModelProperties.FILE_EXTENSION"};
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite baseComposite = new Composite(parent, 0);
        GridLayout grid = new GridLayout();
        grid.numColumns = 4;
        baseComposite.setLayout((Layout)grid);
        this.createFileForm(baseComposite);
        this.createFileTypeForm(baseComposite);
        this.createTemplateForm(baseComposite);
        this.createOptionsForm(baseComposite);
        this.setContextHelp((Control)baseComposite);
        return baseComposite;
    }

    protected void createOptionsForm(Composite baseComposite) {
        this.fOptionsButton = new Button(baseComposite, 8);
        this.fOptionsButton.setText(Messages.NewWebPageWizardPage_Options);
        this.fOptionsButton.setEnabled(this.model.getBooleanProperty("IOptionsButtonProperties.OPTIONS_BUTTON_ENABLED"));
        this.fOptionsButton.addListener(13, (Listener)this);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.fOptionsButton.setLayoutData((Object)gridData);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.isFirstTimeToPage = true;
            this.fTemplateSelector.setProject((IProject)this.model.getProperty("IWebPageCreationDataModelProperties.PROJECT"), false);
            if (this.model.isPropertySet("IWebPageDataModelProperties.TEMPLATE")) {
                StructuredSelection selection = new StructuredSelection(this.model.getProperty("IWebPageDataModelProperties.TEMPLATE"));
                this.fTemplateSelector.setSelection((ISelection)selection);
            } else {
                Object template = this.model.getDefaultProperty("IWebPageDataModelProperties.TEMPLATE");
                if (template == null) {
                    template = PageTemplateSelector.NO_SELECTION;
                }
                this.fTemplateSelector.setSelection((ISelection)new StructuredSelection(template));
            }
            this.isFirstTimeToPage = false;
        }
    }

    private void createFileForm(Composite baseComposite) {
        Label nameLabel = new Label(baseComposite, 0);
        nameLabel.setText(Messages.NewWebPageWizardPage_File_Name);
        Text nameText = new Text(baseComposite, 2048);
        this.synchHelper.synchText(nameText, "IWebPageDataModelProperties.FILE_NAME", null);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        nameText.setLayoutData((Object)gridData);
        nameText.setBackground(FieldAssistColors.getRequiredFieldBackgroundColor((Control)nameText));
        nameText.setFocus();
        new Label(baseComposite, 0);
        Label folderLabel = new Label(baseComposite, 0);
        folderLabel.setText(Messages.NewWebPageWizardPage_Folder);
        Text folderText = new Text(baseComposite, 2048);
        this.synchHelper.synchText(folderText, "IWebPageCreationDataModelProperties.FOLDER", null);
        gridData = new GridData(768);
        gridData.widthHint = 250;
        gridData.horizontalSpan = 2;
        folderText.setBackground(FieldAssistColors.getRequiredFieldBackgroundColor((Control)folderText));
        folderText.setLayoutData((Object)gridData);
        this.fBrowseButton = new Button(baseComposite, 8);
        this.fBrowseButton.setText(Messages.NewWebPageWizardPage_Browse);
        gridData = new GridData(128);
        this.fBrowseButton.setLayoutData((Object)gridData);
        this.fBrowseButton.addListener(13, (Listener)this);
    }

    protected void createFileTypeForm(Composite baseComposite) {
    }

    protected void createTemplateForm(Composite baseComposite) {
        this.fTemplateSelector = this.createTemplateSelector();
        this.fTemplateSelector.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fTemplateSelector.createContents(baseComposite);
        GridData gridData = new GridData(1808);
        new Label(baseComposite, 0);
        Button applyStaticButton = new Button(baseComposite, 32);
        applyStaticButton.setText(Messages.NewWebPageWizardPage_Link_page);
        this.synchHelper.synchCheckbox(applyStaticButton, "IWebPageDataModelProperties.LINK_PAGE_TO_TEMPLATE", null);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        applyStaticButton.setLayoutData((Object)gridData);
    }

    protected PageTemplateSelector createTemplateSelector() {
        return new PageTemplateSelector((TemplateTreeContentProvider)new BasicTemplateContentProvider(), (PageThumbnailLabelProvider)new BasicThumbnailLabelProvider());
    }

    public void handleEvent(Event event) {
        if (event.widget.equals(this.fBrowseButton)) {
            this.handleBrowseButtonPressed();
        } else if (event.widget.equals(this.fOptionsButton)) {
            this.handleOptionsButtonPressed();
        }
        super.handleEvent(event);
    }

    private void handleOptionsButtonPressed() {
        AdvancedOptionsDialog dialog = new AdvancedOptionsDialog(this.getShell(), this.model);
        dialog.open();
    }

    private void handleBrowseButtonPressed() {
        ISelectionStatusValidator validator = this.getContainerDialogSelectionValidator();
        ViewerFilter filter = this.getContainerDialogViewerFilter();
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setValidator(validator);
        dialog.setTitle(Messages.NewWebPageWizardPage_Container_selection);
        dialog.setMessage(Messages.NewWebPageWizardPage_Choose_a_container);
        dialog.addFilter(filter);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        IProject project = (IProject)this.model.getProperty("IWebPageCreationDataModelProperties.PROJECT");
        if (project != null) {
            dialog.setInitialSelection((Object)project);
        }
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            try {
                if (element instanceof IContainer) {
                    IContainer container = (IContainer)element;
                    String newContainerPathString = container.getFullPath().toString();
                    this.model.setProperty("IWebPageCreationDataModelProperties.FOLDER", (Object)newContainerPathString);
                }
            }
            catch (Exception exception) {}
        }
    }

    private ISelectionStatusValidator getContainerDialogSelectionValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                Status ret = new Status(4, WebPageGenUIPlugin.getPluginId(), 4, Messages.NewWebPageWizardPage_Choose_web_content_folder, null);
                try {
                    if (selection[0] != null && !(selection[0] instanceof IProject)) {
                        ret = new Status(0, WebPageGenUIPlugin.getPluginId(), 0, "", null);
                    }
                }
                catch (Exception exception) {}
                return ret;
            }
        };
    }

    protected ViewerFilter getContainerDialogViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                boolean ret = false;
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    ret = ProjectFacetsUtil.isWebProject((IProject)project);
                } else if (element instanceof IContainer) {
                    IContainer container = (IContainer)element;
                    ret = ProjectFacetsUtil.isWithinWebRoot((IContainer)container);
                }
                return ret;
            }
        };
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
        ITemplateDescriptor newTemplate = null;
        if (selection instanceof ITemplateDescriptor) {
            newTemplate = (ITemplateDescriptor)selection;
        }
        this.model.setProperty("IWebPageDataModelProperties.TEMPLATE", (Object)newTemplate);
        this.handleTemplateTypeUpdate();
    }

    public void propertyChanged(DataModelEvent event) {
        if (event.getPropertyName().equals("IWebPageCreationDataModelProperties.PROJECT")) {
            IProject project = (IProject)this.model.getProperty("IWebPageCreationDataModelProperties.PROJECT");
            this.fTemplateSelector.setProject(project, true);
            WebPageModelUtil.getPropertyStore().restoreProperties(this.model);
            WebPageModelUtil.getPropertyStore().restoreProjectProperties(this.model, project);
            if (this.model.isPropertySet("IWebPageDataModelProperties.TEMPLATE")) {
                ITemplateDescriptor template = (ITemplateDescriptor)this.model.getProperty("IWebPageDataModelProperties.TEMPLATE");
                this.fTemplateSelector.setSelection((ISelection)new StructuredSelection((Object)template));
            } else {
                ITemplateDescriptor defaultTemplate = (ITemplateDescriptor)this.model.getDefaultProperty("IWebPageDataModelProperties.TEMPLATE");
                this.model.setProperty("IWebPageDataModelProperties.TEMPLATE", (Object)defaultTemplate);
            }
        }
        if ("IOptionsButtonProperties.OPTIONS_BUTTON_ENABLED".equals(event.getPropertyName())) {
            boolean enabled = this.model.getBooleanProperty("IOptionsButtonProperties.OPTIONS_BUTTON_ENABLED");
            if (this.fOptionsButton != null) {
                this.fOptionsButton.setEnabled(enabled);
            }
        }
        if ("IWebPageDataModelProperties.TEMPLATE".equals(event.getPropertyName())) {
            this.handleTemplateTypeUpdate();
        }
        super.propertyChanged(event);
    }

    protected void handleTemplateTypeUpdate() {
        if (this.fTemplateSelector != null) {
            ITemplateDescriptor newTemplate = this.model.isPropertySet("IWebPageDataModelProperties.TEMPLATE") ? (ITemplateDescriptor)this.model.getProperty("IWebPageDataModelProperties.TEMPLATE") : null;
            String templateType = Messages.NewWebPageWizardPage_select_a_template;
            if (newTemplate != null) {
                if (newTemplate.getCategory() == 0) {
                    templateType = NLS.bind((String)Messages.NewWebPageWizardPage_Basic_page_template, (Object)newTemplate.getName());
                } else {
                    boolean isTiles = newTemplate.isTiles() || this.model.isProperty("IWebPageDataModelProperties.CONVERT_TEMPLATE_TO_TILES") && this.model.getBooleanProperty("IWebPageDataModelProperties.CONVERT_TEMPLATE_TO_TILES");
                    templateType = isTiles ? NLS.bind((String)Messages.NewWebPageWizardPage_Dynamic_page_template, (Object)newTemplate.getName()) : NLS.bind((String)Messages.NewWebPageWizardPage_Design_time_page_template, (Object)newTemplate.getName());
                }
            }
            if (Display.findDisplay((Thread)Thread.currentThread()) != null) {
                this.fTemplateSelector.setTemplateTypeText(templateType);
            }
        }
    }
}

