/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal.webservice.jaxrpc;

import com.ibm.etools.webtools.pagedataview.javabean.util.WebServicesClientUtil;
import com.ibm.etools.webtools.services.api.objects.IServiceInvocationGenerator;
import com.ibm.etools.webtools.services.api.objects.ServiceData;
import com.ibm.etools.webtools.services.internal.AbstractServiceFinder;
import com.ibm.etools.webtools.services.internal.servicebean.IServiceListener;
import com.ibm.etools.webtools.services.internal.util.Util;
import com.ibm.etools.webtools.services.internal.webservice.JavaTypeUtil;
import com.ibm.etools.webtools.services.internal.webservice.WSProxyBeanData;
import com.ibm.etools.webtools.services.internal.webservice.WebServiceData;
import com.ibm.etools.webtools.services.internal.webservice.WebServiceFinder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class WebServiceJaxRPCFinder
extends AbstractServiceFinder {
    WebServiceFinder fParentFinder;

    WebServiceJaxRPCFinder(WebServiceFinder finder, IServiceInvocationGenerator generator) {
        super(generator);
        this.fParentFinder = finder;
    }

    private List<WSProxyBeanData> getProxies(IProject project) {
        ArrayList<WSProxyBeanData> proxies;
        block7: {
            proxies = new ArrayList<WSProxyBeanData>();
            try {
                List<String> classFiles = this.getProxyClassNames(project);
                if (classFiles.size() <= 0) break block7;
                ArrayList endPointInterfaces = new ArrayList();
                IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                WebServicesClientUtil.buildEndPointInterfaces((IVirtualComponent)component, endPointInterfaces);
                if (endPointInterfaces.size() <= 0) break block7;
                int j = 0;
                while (j < classFiles.size()) {
                    JavaClass endPointInterface;
                    String resPath = classFiles.get(j);
                    JavaHelpers beanHelper = null;
                    try {
                        beanHelper = JavaTypeUtil.introspect(resPath, project);
                    }
                    catch (CoreException coreException) {
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    if (beanHelper != null && (endPointInterface = WebServicesClientUtil.getImplementedEndPointInterface((JavaHelpers)beanHelper, endPointInterfaces, (IProject)project)) != null) {
                        String sName = resPath.substring(resPath.lastIndexOf(".") + 1, resPath.length());
                        proxies.add(new WSProxyBeanData(sName, beanHelper, endPointInterface));
                    }
                    ++j;
                }
            }
            catch (Exception exception) {}
        }
        return proxies;
    }

    private List<String> getProxyClassNames(IProject project) {
        ArrayList<String> classFiles = new ArrayList<String>();
        IContainer[] outputFolders = J2EEProjectUtilities.getOutputContainers((IProject)project);
        if (outputFolders != null || outputFolders.length > 0) {
            try {
                int i = 0;
                while (i < outputFolders.length) {
                    List<String> temp = this.getProxyClassNamesFromFolder(outputFolders[i]);
                    if (temp != null && temp.size() > 0) {
                        int containerIndex = outputFolders[i].getProjectRelativePath().toString().length();
                        for (String element : temp) {
                            element = element.substring(containerIndex, element.length());
                            classFiles.add(element);
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return classFiles;
    }

    private List<String> getProxyClassNamesFromFolder(IContainer container) throws Exception {
        ArrayList<String> proxyList = new ArrayList<String>();
        try {
            IResource[] resources = container.members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i].getType() == 1) {
                    String name = resources[i].getProjectRelativePath().toString();
                    if (name.endsWith("Proxy.class")) {
                        name = name.substring(1, name.lastIndexOf(".class"));
                        name = name.replaceAll("/", ".");
                        proxyList.add(name);
                    }
                } else if (resources[i].getType() == 2) {
                    proxyList.addAll(this.getProxyClassNamesFromFolder((IContainer)((IFolder)resources[i])));
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return proxyList;
    }

    @Override
    public List<ServiceData> getServices(IProject project, IProgressMonitor monitor) {
        return this.getServices(project, null, monitor);
    }

    @Override
    public List<ServiceData> getServices(IProject project, IServiceListener listener, IProgressMonitor monitor) {
        List<WSProxyBeanData> proxies = this.getProxies(project);
        ArrayList<ServiceData> services = new ArrayList<ServiceData>(proxies.size());
        IJavaProject jProject = JavaCore.create((IProject)project);
        for (WSProxyBeanData proxy : proxies) {
            JavaClass iface;
            IType proxyType = null;
            IType interfaceType = null;
            JavaHelpers proxyClass = proxy.getProxyBeanClass();
            if (proxyClass instanceof JavaClass) {
                proxyType = (IType)((JavaClass)proxyClass).getReflectionType();
            }
            if ((iface = proxy.getEndPointInterface()) != null) {
                interfaceType = Util.getTypeFromJavaClass(iface, jProject);
            }
            try {
                if (proxyType == null && interfaceType == null) continue;
                WSJaxRPCServiceData service = new WSJaxRPCServiceData(jProject, proxy, proxyType, interfaceType, this.getServiceGenerator());
                this.initServiceMethods(service);
                services.add(service);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return services;
    }

    protected void initServiceMethods(WebServiceData service) throws JavaModelException {
        IMethod[] interfaceMethods = service.getServiceInterface().getMethods();
        if (interfaceMethods != null) {
            int i = 0;
            while (i < interfaceMethods.length) {
                IMethod method = interfaceMethods[i];
                IMethod classMethod = service.getServiceClass().getMethod(method.getElementName(), method.getParameterTypes());
                if (classMethod != null) {
                    service.addMethod(classMethod, false);
                }
                ++i;
            }
        }
    }

    @Override
    public void removeListener(IServiceListener listener, IProject project) {
    }

    public static class WSJaxRPCServiceData
    extends WebServiceData {
        private WSProxyBeanData fProxyData;

        public WSJaxRPCServiceData(IJavaProject project, WSProxyBeanData proxyData, IType serviceClass, IType interfaceType, IServiceInvocationGenerator generator) {
            super(project, serviceClass, interfaceType, generator);
            this.fProxyData = proxyData;
        }

        public WSProxyBeanData getProxyData() {
            return this.fProxyData;
        }
    }
}

