/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal.webservice.axis2;

import com.ibm.etools.webtools.services.api.objects.IServiceInvocationGenerator;
import com.ibm.etools.webtools.services.api.objects.ServiceData;
import com.ibm.etools.webtools.services.internal.AbstractServiceFinder;
import com.ibm.etools.webtools.services.internal.servicebean.IServiceListener;
import com.ibm.etools.webtools.services.internal.webservice.WebServiceData;
import com.ibm.etools.webtools.services.internal.webservice.WebServiceFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class WebServiceAxis2Finder
extends AbstractServiceFinder {
    private static final String AXIS2_STUB = "org.apache.axis2.client.Stub";
    WebServiceFinder fParentFinder;

    WebServiceAxis2Finder(WebServiceFinder finder, IServiceInvocationGenerator generator) {
        super(generator);
        this.fParentFinder = finder;
    }

    @Override
    public List<ServiceData> getServices(IProject project, IProgressMonitor monitor) {
        return this.getServices(project, null, monitor);
    }

    @Override
    public List<ServiceData> getServices(IProject project, IServiceListener listener, IProgressMonitor monitor) {
        ArrayList<ServiceData> list = new ArrayList<ServiceData>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)root);
        try {
            try {
                IType axis2Stub;
                javaModel.open(monitor);
                IJavaProject javaProject = javaModel.getJavaProject(project.getName());
                if (javaProject != null && (axis2Stub = javaProject.findType(AXIS2_STUB)) != null) {
                    this.addAxis2Stubs(javaProject, axis2Stub, list, monitor);
                }
            }
            catch (Exception exception) {
                try {
                    javaModel.close();
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                javaModel.close();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    private void addAxis2Stubs(IJavaProject javaProject, IType axisStub, List<ServiceData> list, IProgressMonitor monitor) {
        try {
            ITypeHierarchy axisStubHierarchy = axisStub.newTypeHierarchy(javaProject, monitor);
            IType[] stubs = axisStubHierarchy.getSubtypes(axisStub);
            int s = 0;
            while (s < stubs.length) {
                WebServiceData service;
                int flags;
                IType stub = stubs[s];
                if (!stub.isBinary() && !Flags.isAbstract((int)(flags = stub.getFlags())) && Flags.isPublic((int)flags) && (service = this.createWebServiceData(javaProject, stub)) != null) {
                    list.add(service);
                }
                ++s;
            }
        }
        catch (Exception exception) {}
    }

    private WebServiceData createWebServiceData(IJavaProject project, IType stub) {
        WebServiceData service = null;
        try {
            IPath stubPath;
            IResource resource = stub.getUnderlyingResource();
            if (resource != null && (stubPath = resource.getLocation()) != null) {
                service = new WebServiceData(project, stub, null, this.getServiceGenerator());
                this.initServiceMethods(service);
            }
        }
        catch (Exception exception) {}
        return service;
    }

    protected void initServiceMethods(WebServiceData service) throws JavaModelException {
        IType stub = service.getServiceClass();
        IMethod[] methods = stub.getMethods();
        if (methods != null) {
            int j = 0;
            while (j < methods.length) {
                String[] exceptions;
                int flags;
                IMethod method = methods[j];
                if (!method.isConstructor() && !Flags.isAbstract((int)(flags = method.getFlags())) && Flags.isPublic((int)flags) && !Flags.isStatic((int)flags) && (exceptions = method.getExceptionTypes()) != null) {
                    int i = 0;
                    while (i < exceptions.length) {
                        if (exceptions[i] != null && exceptions[i].indexOf("RemoteException") >= 0) {
                            String returnType = method.getReturnType();
                            if ("V".equals(returnType)) break;
                            service.addMethod(method, false);
                            break;
                        }
                        ++i;
                    }
                }
                ++j;
            }
        }
    }

    @Override
    public void removeListener(IServiceListener listener, IProject project) {
    }

    @Override
    public List<ServiceData> getServices(IProject project, IServiceListener listener, Set<String> facetIds, IProgressMonitor monitor) {
        List<ServiceData> services = null;
        if (facetIds != null && facetIds.contains("axis2.core")) {
            services = super.getServices(project, listener, facetIds, monitor);
        }
        return services;
    }
}

