/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal.webservice;

import com.ibm.etools.webtools.services.api.ServicesAPI;
import com.ibm.etools.webtools.services.api.objects.ServiceData;
import com.ibm.etools.webtools.services.internal.AbstractCompositeServiceFinder;
import com.ibm.etools.webtools.services.internal.AbstractServiceFinder;
import com.ibm.etools.webtools.services.internal.AbstractServiceManager;
import com.ibm.etools.webtools.services.internal.servicebean.IServiceListener;
import com.ibm.etools.webtools.services.internal.webservice.Debug;
import com.ibm.etools.webtools.services.internal.webservice.WebServiceClientData;
import com.ibm.etools.webtools.services.internal.webservice.WebServiceData;
import com.ibm.etools.webtools.services.internal.webservice.WebServiceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public final class WebServiceFinder
extends AbstractCompositeServiceFinder {
    static long[] fDebugTimes;

    static final Object getWebServiceCategoryKey() {
        return ServicesAPI.SERVICE_CATEGORY_WEB_SERVICE;
    }

    WebServiceFinder(WebServiceManager manager) {
        super(manager);
    }

    public Object getServiceCategoryKey() {
        return WebServiceFinder.getWebServiceCategoryKey();
    }

    @Override
    public List<ServiceData> getServices(IProject project, IProgressMonitor monitor) {
        return this.getServices(project, null, monitor);
    }

    @Override
    public List<ServiceData> getServices(IProject project, IServiceListener listener, IProgressMonitor monitor) {
        ArrayList<ServiceData> allServices = new ArrayList<ServiceData>();
        List<ServiceData> serviceList = null;
        AbstractServiceManager[] childManagers = this.getManager().getChildManagers();
        String id = "Collecting web services";
        Debug.beginRecording(id);
        HashSet<String> facetIds = null;
        try {
            IFacetedProject fp = ProjectFacetsManager.create((IProject)project);
            Set facetVersions = fp.getProjectFacets();
            if (facetVersions != null && facetVersions.size() > 0) {
                facetIds = new HashSet<String>(facetVersions.size());
                for (IProjectFacetVersion facetVersion : facetVersions) {
                    String facetId = facetVersion.getProjectFacet().getId();
                    if (id == null) continue;
                    facetIds.add(facetId);
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < childManagers.length) {
            AbstractServiceFinder finder = (AbstractServiceFinder)childManagers[i].getServiceFinder();
            serviceList = finder.getServices(project, listener, facetIds, monitor);
            if (serviceList != null) {
                allServices.addAll(serviceList);
            }
            Debug.mark(finder.getClass());
            ++i;
        }
        Debug.endRecording(id, false);
        return allServices;
    }

    @Override
    public List<ServiceData> getServices(IProject project, Object serviceId, IProgressMonitor monitor) {
        List<ServiceData> serviceList = null;
        AbstractServiceManager[] childManagers = this.getManager().getChildManagers();
        int i = 0;
        while (i < childManagers.length) {
            AbstractServiceFinder finder = (AbstractServiceFinder)childManagers[i].getServiceFinder();
            if (finder.getServiceGenerator().getId() == serviceId) {
                serviceList = this.getServices(project, monitor);
                break;
            }
            ++i;
        }
        return serviceList;
    }

    public Set<WebServiceClientData> getServiceClients(IProject project, IProgressMonitor monitor) {
        HashSet<WebServiceClientData> clients = null;
        if (clients == null) {
            clients = new HashSet<WebServiceClientData>();
            List<ServiceData> serviceList = this.getServices(project, monitor);
            for (WebServiceData webServiceData : serviceList) {
                clients.add(webServiceData.getClientData());
            }
        }
        return clients;
    }

    public Collection<WebServiceClientData> getServiceClients(IProject project, Object serviceId, IProgressMonitor monitor) {
        Assert.isNotNull((Object)project);
        Assert.isNotNull((Object)serviceId);
        Set<WebServiceClientData> clientList = this.getServiceClients(project, monitor);
        ArrayList<WebServiceClientData> clientSublist = new ArrayList<WebServiceClientData>();
        for (WebServiceClientData client : clientList) {
            if (!serviceId.equals(client.getGenerator().getId())) continue;
            clientSublist.add(client);
        }
        return clientSublist;
    }

    @Override
    public void removeListener(IServiceListener listener, IProject project) {
    }
}

