/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal.webservice;

import com.ibm.etools.webtools.pagedatamodel.PageDataModelPlugin;
import com.ibm.etools.webtools.pagedatamodel.nls.ResourceHandler;
import java.beans.Introspector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoNature;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.osgi.util.NLS;

public class JavaTypeUtil {
    private static final String listTypeString = "java.util.List";

    public static boolean isPrimitive(String importName) {
        if (importName == null || importName.length() == 0) {
            return false;
        }
        boolean isPrimitive = false;
        if (importName.equals("float")) {
            isPrimitive = true;
        } else if (importName.equals("double")) {
            isPrimitive = true;
        } else if (importName.equals("long")) {
            isPrimitive = true;
        } else if (importName.equals("int")) {
            isPrimitive = true;
        } else if (importName.equals("boolean")) {
            isPrimitive = true;
        } else if (importName.equals("short")) {
            isPrimitive = true;
        } else if (importName.equals("byte")) {
            isPrimitive = true;
        } else if (importName.equals("char")) {
            isPrimitive = true;
        }
        return isPrimitive;
    }

    public static String getMethodNameSuffix(String propertyName) {
        String ret = null;
        IStatus status = JavaConventions.validateIdentifier((String)propertyName);
        if (status.isOK()) {
            ret = String.valueOf(Character.toUpperCase(propertyName.charAt(0)));
            if (propertyName.length() >= 2) {
                ret = Character.isUpperCase(propertyName.charAt(0)) && Character.isUpperCase(propertyName.charAt(1)) ? propertyName : String.valueOf(Character.toUpperCase(propertyName.charAt(0))) + propertyName.substring(1);
            }
        }
        return ret;
    }

    public static String getPropertyName(String getterMethodName) {
        String ret = null;
        ret = getterMethodName.startsWith("get") ? getterMethodName.substring("get".length()) : (getterMethodName.startsWith("is") ? getterMethodName.substring("is".length()) : getterMethodName);
        ret = Introspector.decapitalize(ret);
        return ret;
    }

    public static String decapitalizePropertyName(String propertyName) {
        return Introspector.decapitalize(propertyName);
    }

    public static IStatus validateMethodName(String methodName) {
        return JavaConventions.validateMethodName((String)methodName);
    }

    public static IStatus validatePropertyName(String propertyName) {
        IStatus status = JavaConventions.validateIdentifier((String)propertyName);
        if (status.isOK()) {
            if (propertyName.length() == 1) {
                if (Character.isUpperCase(propertyName.charAt(0))) {
                    status = new Status(4, PageDataModelPlugin.class.getName(), 0, NLS.bind((String)ResourceHandler.JavaTypeUtil_validatePropertyName, (Object[])new Object[]{new Character(Character.toLowerCase(propertyName.charAt(0))), ""}), null);
                }
            } else if (propertyName.length() > 1) {
                if (Character.isUpperCase(propertyName.charAt(0)) && !Character.isUpperCase(propertyName.charAt(1))) {
                    status = new Status(4, PageDataModelPlugin.class.getName(), 0, NLS.bind((String)ResourceHandler.JavaTypeUtil_validatePropertyName3, (Object[])new Object[]{new Character(Character.toLowerCase(propertyName.charAt(0))), propertyName.substring(1)}), null);
                }
                if (Character.isLowerCase(propertyName.charAt(0)) && Character.isUpperCase(propertyName.charAt(1))) {
                    status = new Status(4, PageDataModelPlugin.class.getName(), 0, NLS.bind((String)ResourceHandler.JavaTypeUtil_validatePropertyName2, (Object[])new Object[]{new Character(Character.toUpperCase(propertyName.charAt(0))), propertyName.substring(1)}), null);
                }
            }
        }
        return status;
    }

    public static JavaHelpers introspect(String rtType, IProject project) throws CoreException, ClassNotFoundException {
        JavaHelpers[] jclass = new JavaHelpers[1];
        JavaTypeUtil.internalLoadJavaClass(rtType, jclass, project, (IProgressMonitor)new NullProgressMonitor());
        JavaHelpers javaClass = jclass[0];
        if (javaClass != null && javaClass instanceof JavaClass && !((JavaClass)javaClass).isExistingType()) {
            throw new ClassNotFoundException(NLS.bind((String)ResourceHandler._EXC_classNotFound, (Object[])new String[]{rtType}));
        }
        return javaClass;
    }

    static void internalLoadJavaClass(String rtType, JavaHelpers[] javaClass, IProject project, IProgressMonitor monitor) throws CoreException {
        if (rtType == null || rtType.length() == 0) {
            return;
        }
        monitor.beginTask(NLS.bind((String)ResourceHandler.UI_Introspecting, (Object[])new String[]{rtType}), 10);
        monitor.worked(1);
        BeaninfoNature nature = BeaninfoNature.getRuntime((IProject)project);
        ResourceSet rset = nature.getResourceSet();
        monitor.worked(3);
        String partialURI = null;
        int i = rtType.lastIndexOf(46);
        if (i > -1) {
            char[] chars = rtType.toCharArray();
            chars[i] = 35;
            partialURI = new String(chars);
        } else {
            partialURI = "#" + rtType;
        }
        monitor.worked(1);
        URI uri = URI.createURI((String)("java:/" + partialURI));
        javaClass[0] = (JavaHelpers)rset.getEObject(uri, true);
        monitor.done();
    }

    public static boolean isListType(String type, IProject project) throws CoreException, ClassNotFoundException {
        JavaHelpers jclass = JavaTypeUtil.introspect(type, project);
        if (jclass != null) {
            JavaHelpers listType = JavaTypeUtil.introspect(listTypeString, project);
            return listType.isAssignableFrom((EClassifier)jclass);
        }
        return false;
    }
}

