/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal.util;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModelAdapter;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.editor.EditorModelUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;

public class Util {
    public static final String getFullyQualifiedType(IMethod method) {
        String typeSignature;
        String signatureAsString;
        String fullyQualifiedType;
        block15: {
            fullyQualifiedType = null;
            signatureAsString = null;
            typeSignature = null;
            if (Util.isPropertyGetter(method)) {
                typeSignature = method.getReturnType();
                break block15;
            }
            if (Util.isPropertySetter(method)) {
                typeSignature = method.getParameterTypes()[0];
                break block15;
            }
            return null;
        }
        try {
            int arrayCount = Signature.getArrayCount((String)typeSignature);
            signatureAsString = arrayCount > 0 ? Signature.toString((String)Signature.getElementType((String)typeSignature)) : Signature.toString((String)typeSignature);
            if (Util.isPrimitive(signatureAsString)) {
                fullyQualifiedType = signatureAsString;
            } else {
                fullyQualifiedType = signatureAsString.equals(Signature.getSimpleName((String)signatureAsString)) ? Util.constructFullyQualifiedType(method, signatureAsString) : signatureAsString;
                String[] genericTypes = Signature.getTypeArguments((String)typeSignature);
                if (genericTypes.length > 0) {
                    boolean allGenericsResolved = true;
                    StringBuffer genericBuffer = new StringBuffer();
                    genericBuffer.append('<');
                    int i = 0;
                    while (i < genericTypes.length) {
                        String genericType = genericTypes[i];
                        String simpleGenericType = Signature.toString((String)genericType);
                        String fullyQualifiedGenericType = Util.constructFullyQualifiedType(method, simpleGenericType);
                        if (fullyQualifiedGenericType == null) {
                            allGenericsResolved = false;
                            break;
                        }
                        genericBuffer.append(fullyQualifiedGenericType);
                        if (i < genericTypes.length - 1) {
                            genericBuffer.append(',');
                        }
                        ++i;
                    }
                    genericBuffer.append('>');
                    if (allGenericsResolved) {
                        fullyQualifiedType = String.valueOf(fullyQualifiedType) + genericBuffer.toString();
                    }
                }
            }
            if (arrayCount > 0) {
                int i = 0;
                while (i < arrayCount) {
                    fullyQualifiedType = String.valueOf(fullyQualifiedType) + "[]";
                    ++i;
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return fullyQualifiedType;
    }

    private static String constructFullyQualifiedType(IMethod method, String simpleType) {
        String[][] fullyQualifiedType = null;
        try {
            fullyQualifiedType = method.getDeclaringType().resolveType(simpleType);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        if (fullyQualifiedType != null) {
            String p = fullyQualifiedType[0][0];
            String pkgName = p.equals("") ? "" : String.valueOf(p) + '.';
            return String.valueOf(pkgName) + fullyQualifiedType[0][1];
        }
        return null;
    }

    public static final boolean isPropertyGetter(IMethod method) {
        try {
            boolean isInterfaceMethod = method.getDeclaringType().isInterface();
            int flags = method.getFlags();
            if (Flags.isPublic((int)flags) && !Flags.isStatic((int)flags) || isInterfaceMethod) {
                String methodName = method.getElementName();
                String returnType = Signature.toString((String)Signature.getReturnType((String)method.getSignature()));
                if (!Signature.toString((String)method.getReturnType()).equals("void") && Signature.getParameterCount((String)method.getSignature()) == 0 && (methodName.startsWith("get") || methodName.startsWith("is") && returnType.equals("boolean"))) {
                    return true;
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static final boolean isPropertySetter(IMethod method) {
        try {
            String methodName = method.getElementName();
            boolean isInterfaceMethod = method.getDeclaringType().isInterface();
            int flags = method.getFlags();
            if ((Flags.isPublic((int)flags) && !Flags.isStatic((int)flags) || isInterfaceMethod) && methodName.startsWith("set") && Signature.toString((String)method.getReturnType()).equals("void") && Signature.getParameterCount((String)method.getSignature()) == 1 && !methodName.equals("set")) {
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static final boolean isPrimitive(String typeName) {
        if (typeName == null || typeName.length() == 0) {
            return false;
        }
        boolean isPrimitive = false;
        if (typeName.equals("float")) {
            isPrimitive = true;
        } else if (typeName.equals("double")) {
            isPrimitive = true;
        } else if (typeName.equals("long")) {
            isPrimitive = true;
        } else if (typeName.equals("int")) {
            isPrimitive = true;
        } else if (typeName.equals("boolean")) {
            isPrimitive = true;
        } else if (typeName.equals("short")) {
            isPrimitive = true;
        } else if (typeName.equals("byte")) {
            isPrimitive = true;
        } else if (typeName.equals("char")) {
            isPrimitive = true;
        }
        return isPrimitive;
    }

    public static IPageDataModel getPDModel(IDOMDocument doc) {
        PageDataModelAdapter.setSyncInitialization((boolean)true);
        PageDataModelAdapter adapter = (PageDataModelAdapter)doc.getAdapterFor((Object)PageDataModelAdapter.ADAPTER_KEY);
        if (adapter == null) {
            EditorModelUtil.addFactoriesTo((IStructuredModel)doc.getModel());
            adapter = (PageDataModelAdapter)doc.getAdapterFor((Object)PageDataModelAdapter.ADAPTER_KEY);
        }
        return adapter.getPageDataModel();
    }

    public static IType getTypeFromJavaClass(JavaClass javaClass, IJavaProject project) {
        IType foundType = null;
        String qualifiedName = javaClass.getQualifiedName();
        try {
            foundType = project.findType(qualifiedName);
        }
        catch (JavaModelException javaModelException) {}
        return foundType;
    }
}

