/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal.util;

import com.ibm.etools.webtools.services.internal.sessionbean.SessionBeanServiceData;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;

public class RuntimeUtilities {
    public static boolean isEjb3Capable(SessionBeanServiceData service) {
        return RuntimeUtilities.isEjb3Capable(service.getProject().getProject());
    }

    public static boolean isEjb3Capable(IProject project) {
        return RuntimeUtilities.isWAS61Ejb3(project) || RuntimeUtilities.isTargetRuntimeWAS7(project);
    }

    public static boolean isWAS61Ejb3(SessionBeanServiceData service) {
        return RuntimeUtilities.isWAS61Ejb3(service.getProject().getProject());
    }

    public static boolean isWAS61Ejb3(IProject project) {
        String v61id = "com.ibm.ws.ast.st.runtime.v61";
        String ejb30id = "com.ibm.ws.ast.st.runtime.ejb30";
        return RuntimeUtilities.checkForRuntimeAndComponent(project, v61id, ejb30id);
    }

    public static boolean isTargetRuntimeWAS7(SessionBeanServiceData service) {
        return RuntimeUtilities.isTargetRuntimeWAS7(service.getProject().getProject());
    }

    public static boolean isTargetRuntimeWAS7(IProject project) {
        String v7id = "com.ibm.ws.ast.st.runtime.v70";
        return RuntimeUtilities.checkForRuntime(true, v7id, project);
    }

    private static boolean checkForRuntime(boolean all, String runtimeId, IProject project) {
        boolean runtimeIdFound = false;
        boolean allAreRuntimeId = true;
        Set<IRuntime> runtimes = RuntimeUtilities.getRuntimes(project);
        if (runtimes != null) {
            for (IRuntime runtime : runtimes) {
                List components = runtime.getRuntimeComponents();
                if (components == null) continue;
                for (IRuntimeComponent component : components) {
                    String rTypeId = component.getProperty("type-id");
                    if (rTypeId == null) continue;
                    if (runtimeId.equals(rTypeId)) {
                        runtimeIdFound = true;
                        break;
                    }
                    allAreRuntimeId = false;
                    break;
                }
                if (!allAreRuntimeId && all) break;
            }
        }
        return runtimeIdFound && (!all || allAreRuntimeId);
    }

    private static boolean checkForRuntimeAndComponent(IProject project, String runtimeId, String runtimeComponentId) {
        boolean wereFound = false;
        boolean all = true;
        Set<IRuntime> runtimes = RuntimeUtilities.getRuntimes(project);
        if (runtimes != null) {
            Iterator<IRuntime> iterator = runtimes.iterator();
            while (iterator.hasNext()) {
                boolean runtimeFound = false;
                boolean runtimeComponentFound = false;
                IRuntime runtime = iterator.next();
                List components = runtime.getRuntimeComponents();
                if (components == null) continue;
                for (IRuntimeComponent component : components) {
                    String rTypeId;
                    String id = component.getRuntimeComponentType().getId();
                    if (id != null && id.equals(runtimeComponentId)) {
                        runtimeComponentFound = true;
                    }
                    if ((rTypeId = component.getProperty("type-id")) != null) {
                        if (runtimeId.equals(rTypeId)) {
                            runtimeFound = true;
                        } else {
                            all = false;
                            break;
                        }
                    }
                    if (!runtimeFound || !runtimeComponentFound) continue;
                    wereFound = true;
                    break;
                }
                if (all && runtimeFound && runtimeComponentFound) continue;
                all = false;
                break;
            }
        }
        return wereFound && all;
    }

    private static Set<IRuntime> getRuntimes(IProject project) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        Set facetRuntimes = facetedProject.getTargetedRuntimes();
        return facetRuntimes;
    }

    public static boolean containsFacet(IProject project, String[] facetIDs, boolean containsAll) {
        boolean hasFacet;
        block7: {
            IFacetedProject facetedProject = null;
            hasFacet = false;
            try {
                facetedProject = ProjectFacetsManager.create((IProject)project);
                Set facetVersions = facetedProject.getProjectFacets();
                if (facetVersions == null || facetVersions.size() <= 0) break block7;
                if (containsAll) {
                    int i = 0;
                    while (i < facetIDs.length) {
                        hasFacet = true;
                        if (!facetVersions.contains(facetIDs[i])) {
                            hasFacet = false;
                            break block7;
                        }
                        ++i;
                    }
                    break block7;
                }
                int i = 0;
                while (i < facetIDs.length) {
                    if (facetVersions.contains(facetIDs[i])) {
                        hasFacet = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return hasFacet;
    }

    public static boolean isPortalProject(IProject project) {
        String[] portalFacetIDs = new String[]{"jsr.base", "jsr.was"};
        return RuntimeUtilities.containsFacet(project, portalFacetIDs, false);
    }

    public static boolean isAnnotationCapable(IProject project) {
        boolean isCapable;
        block5: {
            String facetName = "jst.java";
            String minimumFacetVersion = "[5.0";
            isCapable = false;
            if (ProjectFacetsManager.isProjectFacetDefined((String)facetName)) {
                try {
                    IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                    IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)facetName);
                    if (facetedProject == null || facet == null) break block5;
                    Set versions = facet.getVersions(minimumFacetVersion);
                    for (IProjectFacetVersion projectFacetVersion : versions) {
                        isCapable = facetedProject.hasProjectFacet(projectFacetVersion);
                        if (!isCapable) {
                            continue;
                        }
                        break;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    isCapable = false;
                }
            }
        }
        return isCapable;
    }
}

