/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal.sessionbean;

import com.ibm.etools.webtools.services.api.objects.IServiceInvocationGenerator;
import com.ibm.etools.webtools.services.api.objects.ServiceData;
import com.ibm.etools.webtools.services.api.objects.ServiceMethodData;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.common.EJBLocalRef;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.javaee.core.EjbLocalRef;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class SessionBeanServiceData
extends ServiceData {
    EjbRefWrapper fRef;

    public SessionBeanServiceData(EjbRefWrapper ref, IServiceInvocationGenerator generator) {
        super(ref.getProject(), null, ref.getType(), generator);
        this.fRef = ref;
        this.setName(ref.getName());
    }

    @Override
    public List<ServiceMethodData> getServiceMethods() {
        IType serviceInterface;
        if (!this.fMethodsInitialized && (serviceInterface = this.getServiceInterface()) != null) {
            try {
                IType[] interfaces;
                this.addMethods(serviceInterface);
                ITypeHierarchy hierarchy = serviceInterface.newSupertypeHierarchy(null);
                if (hierarchy != null && (interfaces = hierarchy.getAllSuperInterfaces(serviceInterface)) != null) {
                    int i = 0;
                    while (i < interfaces.length) {
                        this.addMethods(interfaces[i]);
                        ++i;
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return super.getServiceMethods();
    }

    private void addMethods(IType type) {
        try {
            IMethod[] methods = type.getMethods();
            boolean needsCheck = type.isClass();
            if ("EJBObject".equals(type.getElementName())) {
                if (methods != null && methods.length > 0) {
                    int i = 0;
                    while (i < methods.length) {
                        String methodName = methods[i].getElementName();
                        if (!"getEJBHome".equals(methodName) && !"getHandle".equals(methodName)) {
                            this.addMethod(methods[i], needsCheck);
                        }
                        ++i;
                    }
                }
            } else {
                this.addMethods(methods, needsCheck);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public EjbRefWrapper getEjbRefWrapper() {
        return this.fRef;
    }

    @Override
    public String getAnnotation() {
        return this.fRef.getAnnotation();
    }

    public static class EjbRefWrapper {
        private boolean fIsLocal = false;
        private boolean fIsEjbProjectReferenced = true;
        private boolean fIsJEERef = false;
        private boolean fIsEjb3 = false;
        private Object fRef;
        private IType fType;
        private IJavaProject fWebProject;
        private String fQualifiedInterfaceName;
        private IVirtualComponent fEjbComponent;

        EjbRefWrapper(EjbRef ref, IJavaProject webProject) {
            this.fRef = ref;
            this.fWebProject = webProject;
        }

        EjbRefWrapper(org.eclipse.jst.javaee.core.EjbRef ref, IJavaProject webProject) {
            this.fIsJEERef = true;
            this.fRef = ref;
            this.fWebProject = webProject;
        }

        EjbRefWrapper(EJBLocalRef ref, IJavaProject webProject) {
            this.fIsLocal = true;
            this.fRef = ref;
            this.fWebProject = webProject;
        }

        EjbRefWrapper(EjbLocalRef ref, IJavaProject webProject) {
            this.fIsLocal = true;
            this.fIsJEERef = true;
            this.fRef = ref;
            this.fWebProject = webProject;
        }

        EjbRefWrapper(SessionBean sessionBean, IJavaProject webProject, IVirtualComponent ejbComponent, String iface, boolean local, boolean isEjbProjectReferenced) {
            this.fRef = sessionBean;
            this.fWebProject = webProject;
            this.fIsJEERef = true;
            this.fIsEjb3 = true;
            this.fQualifiedInterfaceName = iface;
            this.fIsLocal = local;
            this.fIsEjbProjectReferenced = isEjbProjectReferenced;
            this.fEjbComponent = ejbComponent;
        }

        public IType getType() {
            if (this.fType == null) {
                IJavaProject project = this.fEjbComponent != null && !this.fIsEjbProjectReferenced ? JavaCore.create((IProject)this.fEjbComponent.getProject()) : this.fWebProject;
                try {
                    this.fType = project.findType(this.getTypeName());
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
            return this.fType;
        }

        public String getName() {
            if (this.fIsEjb3) {
                return ((SessionBean)this.fRef).getEjbName();
            }
            if (this.fIsLocal) {
                return this.fIsJEERef ? ((EjbLocalRef)this.fRef).getEjbRefName() : ((EJBLocalRef)this.fRef).getName();
            }
            return this.fIsJEERef ? ((org.eclipse.jst.javaee.core.EjbRef)this.fRef).getEjbRefName() : ((EjbRef)this.fRef).getName();
        }

        public String getHome() {
            if (this.fIsEjb3) {
                return this.fIsLocal ? ((SessionBean)this.fRef).getLocalHome() : ((SessionBean)this.fRef).getHome();
            }
            if (this.fIsLocal) {
                return this.fIsJEERef ? ((EjbLocalRef)this.fRef).getLocalHome() : ((EJBLocalRef)this.fRef).getHome();
            }
            return this.fIsJEERef ? ((org.eclipse.jst.javaee.core.EjbRef)this.fRef).getHome() : ((EjbRef)this.fRef).getHome();
        }

        public String getTypeName() {
            if (this.fQualifiedInterfaceName != null) {
                return this.fQualifiedInterfaceName;
            }
            if (this.fIsEjb3) {
                return ((SessionBean)this.fRef).getEjbClass();
            }
            if (this.fIsLocal) {
                return this.fIsJEERef ? ((EjbLocalRef)this.fRef).getLocal() : ((EJBLocalRef)this.fRef).getLocal();
            }
            return this.fIsJEERef ? ((org.eclipse.jst.javaee.core.EjbRef)this.fRef).getRemote() : ((EjbRef)this.fRef).getRemote();
        }

        public Object getRef() {
            return this.fRef;
        }

        public IVirtualComponent getEjbComponent() {
            return this.fEjbComponent;
        }

        public boolean isJEE() {
            return this.fIsJEERef;
        }

        public boolean isLocal() {
            return this.fIsLocal;
        }

        public boolean isEjb3() {
            return this.fIsEjb3;
        }

        public IJavaProject getProject() {
            return this.fWebProject;
        }

        public String getAnnotation() {
            return this.fIsEjb3 ? "@EJB" : null;
        }

        public boolean isEjbProjectReferenced() {
            return this.fIsEjbProjectReferenced;
        }
    }
}

