/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal.generation;

import com.ibm.etools.jsf.facesconfig.scheme.FacesConfigSchemeUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webedit.bean.BeanInformationImpl;
import com.ibm.etools.webedit.bean.BeanProperty;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.beaninfo.BeanDecorator;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoNature;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class FacesConfigCommand {
    private FacesManagedBeanModel fDataModel;
    private String[] fInstanceProperties;
    private String[] fInstancePropertyTypes;

    public FacesConfigCommand(FacesManagedBeanModel model) {
        Assert.isNotNull((Object)model);
        this.fDataModel = model;
    }

    public void createNewManagedBean() {
        IProject project = this.fDataModel.getProject();
        if (JsfProjectUtil.isJsfProject((IProject)project)) {
            FacesConfigArtifactEdit edit = null;
            try {
                IFile file;
                edit = FacesConfigSchemeUtil.getFacesConfigArtifactEditManagedBeanForWrite((IResource)project);
                if (edit != null && (file = edit.getFile()) != null) {
                    FacesConfigType facesConfig;
                    IStatus status = null;
                    Display display = Display.getCurrent();
                    if (display == null && PlatformUI.isWorkbenchRunning()) {
                        final IStatus[] statArray = new IStatus[1];
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                statArray[0] = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)Display.getCurrent().getActiveShell());
                            }
                        });
                        status = statArray[0];
                    }
                    if (status == null) {
                        Shell shell = display == null ? null : (PlatformUI.isWorkbenchRunning() ? display.getActiveShell() : null);
                        status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)shell);
                    }
                    if (status.isOK() && (facesConfig = edit.getFacesConfig()) != null) {
                        FacesConfigPackage facesConfigPackage;
                        FacesConfigFactory facesConfigFactory;
                        ManagedBeanType newManagedBean;
                        EList managedBeans = facesConfig.getManagedBean();
                        String newBeanName = this.fDataModel.getName();
                        boolean shouldCreateBean = true;
                        if (managedBeans != null && managedBeans.size() > 0 && newBeanName != null) {
                            for (ManagedBeanType mBean : managedBeans) {
                                ManagedBeanNameType nameType;
                                String mBeanName;
                                if (mBean == null || !newBeanName.equals(mBeanName = (nameType = mBean.getManagedBeanName()).getTextContent())) continue;
                                shouldCreateBean = false;
                            }
                        }
                        if (shouldCreateBean && this.addDetails(newManagedBean = (facesConfigFactory = (facesConfigPackage = FacesConfigPackage.eINSTANCE).getFacesConfigFactory()).createManagedBeanType(), null)) {
                            managedBeans.add((Object)newManagedBean);
                            edit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
    }

    private boolean addDetails(ManagedBeanType newManagedBean, ManagedBeanType oldManagedBean) {
        FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
        FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
        String value = this.fDataModel.getName();
        if (value == null || value.length() <= 0) {
            return false;
        }
        ManagedBeanNameType managedBeanName = facesConfigFactory.createManagedBeanNameType();
        managedBeanName.setTextContent(value);
        newManagedBean.setManagedBeanName(managedBeanName);
        value = this.fDataModel.getBeanClass();
        if (value == null || value.length() <= 0) {
            return false;
        }
        value = value.replace('$', '.');
        ManagedBeanClassType managedBeanClass = facesConfigFactory.createManagedBeanClassType();
        managedBeanClass.setTextContent(value);
        newManagedBean.setManagedBeanClass(managedBeanClass);
        value = this.fDataModel.getScope();
        if (value == null || value.length() <= 0) {
            return false;
        }
        ManagedBeanScopeType managedBeanScope = facesConfigFactory.createManagedBeanScopeType();
        managedBeanScope.setTextContent(value);
        newManagedBean.setManagedBeanScope(managedBeanScope);
        value = this.fDataModel.getDescription();
        if (value != null && value.length() > 0) {
            DescriptionType description = facesConfigFactory.createDescriptionType();
            description.setTextContent(value);
            newManagedBean.getDescription().add((Object)description);
        }
        return true;
    }

    boolean isType(String sType, String superclassName) {
        if (sType == null || sType.equals("")) {
            return false;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> possibleSuper = null;
        Class<?> typeClass = null;
        try {
            possibleSuper = loader.loadClass(superclassName);
            typeClass = loader.loadClass(sType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        if (possibleSuper == null || typeClass == null) {
            return false;
        }
        return possibleSuper.isAssignableFrom(typeClass);
    }

    public void retrieveInstanceProperties(String className) {
        this.fInstanceProperties = new String[0];
        this.fInstancePropertyTypes = new String[0];
        if (className == null) {
            return;
        }
        JavaClass javaClass = this.getJavaClass(className);
        if (javaClass == null) {
            return;
        }
        if (javaClass instanceof ArrayType && (javaClass = (JavaClass)((ArrayType)javaClass).getComponentTypeAsHelper()) == null) {
            return;
        }
        BeanInformationImpl beanInfo = null;
        try {
            BeanDecorator beanDecorator = Utilities.getBeanDecorator((EModelElement)javaClass);
            if (beanDecorator == null) {
                return;
            }
            beanInfo = new BeanInformationImpl(javaClass, beanDecorator);
        }
        catch (Throwable throwable) {
            beanInfo = null;
        }
        Vector<BeanProperty> v = new Vector<BeanProperty>();
        if (beanInfo != null) {
            int propSize = beanInfo.getPropertySize();
            int i = 0;
            while (i < propSize) {
                v.add(beanInfo.getProperty(i));
                ++i;
            }
        }
        if (v.size() == 0) {
            return;
        }
        this.fInstanceProperties = new String[v.size()];
        this.fInstancePropertyTypes = new String[v.size()];
        int i = 0;
        while (i < v.size()) {
            this.fInstanceProperties[i] = ((BeanProperty)v.get(i)).getName();
            this.fInstancePropertyTypes[i] = ((BeanProperty)v.get(i)).getPropertyType();
            ++i;
        }
    }

    boolean isArray(String sType) {
        boolean isArray = false;
        if (sType.endsWith("[]")) {
            isArray = true;
        }
        return isArray;
    }

    String getType(String sName) {
        int i = 0;
        while (this.fInstanceProperties != null && i < this.fInstanceProperties.length) {
            if (this.fInstanceProperties[i].equals(sName)) {
                return this.fInstancePropertyTypes[i];
            }
            ++i;
        }
        return "";
    }

    private JavaClass getJavaClass(String className) {
        IProject project = this.fDataModel.getProject();
        if (project == null) {
            return null;
        }
        BeaninfoNature nature = null;
        try {
            nature = BeaninfoNature.getRuntime((IProject)project);
        }
        catch (CoreException coreException) {
            return null;
        }
        if (nature == null) {
            return null;
        }
        ResourceSet rset = nature.getResourceSet();
        if (rset == null) {
            return null;
        }
        return Utilities.getJavaClass((String)className, (ResourceSet)rset);
    }

    public static class FacesManagedBeanModel {
        String fBeanName;
        String fBeanClass;
        String fBeanDescription;
        String fScope;
        IProject fProject;

        public String getName() {
            return this.fBeanName;
        }

        public String getBeanClass() {
            return this.fBeanClass;
        }

        public String getDescription() {
            return this.fBeanDescription;
        }

        public String getScope() {
            return this.fScope;
        }

        public String getClassName() {
            return this.fBeanClass;
        }

        public IProject getProject() {
            return this.fProject;
        }

        public void setBeanName(String beanName) {
            this.fBeanName = beanName;
        }

        public void setBeanClass(String beanClass) {
            this.fBeanClass = beanClass;
        }

        public void setBeanDescription(String beanDescription) {
            this.fBeanDescription = beanDescription;
        }

        public void setScope(String scope) {
            this.fScope = scope;
        }

        public void setProject(IProject p) {
            this.fProject = p;
        }
    }
}

