/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal.generation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public class CommandUtil {
    public static final String getSourceFolderPath(IJavaProject jp) {
        String sourceDir = "";
        try {
            IPackageFragmentRoot[] roots = jp.getPackageFragmentRoots();
            if (roots != null) {
                int i = 0;
                while (i < roots.length) {
                    String p;
                    IPackageFragmentRoot root = roots[i];
                    if (root.getKind() == 1 && !(p = root.getPath().removeFirstSegments(1).toString()).startsWith(".")) {
                        sourceDir = p;
                        if (!"test".equals(p)) break;
                    }
                    ++i;
                }
                if (sourceDir != null) {
                    sourceDir = "/" + sourceDir;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sourceDir;
    }

    public static String getServiceBeanPackagePath(IJavaProject jp) {
        String path = CommandUtil.getSourceFolderPath(jp);
        path = String.valueOf(path) + "/services";
        return path;
    }

    public static boolean handleValidateEdit(ICompilationUnit cu, Object shell) {
        IStatus status;
        IFile[] resource;
        boolean validateSuccess = true;
        if (cu != null && (resource = CommandUtil.getResources((IJavaElement)cu)).length > 0 && !(status = ResourcesPlugin.getWorkspace().validateEdit(resource, shell)).isOK() && !status.isMultiStatus()) {
            validateSuccess = false;
        }
        return validateSuccess;
    }

    private static IFile[] getResources(IJavaElement cu) {
        IFile[] result = null;
        IResource resource = cu.getPrimaryElement().getResource();
        if (resource != null && resource.getType() == 1 && ((IFile)resource).isReadOnly()) {
            result = new IFile[]{(IFile)resource};
        }
        if (result == null) {
            result = new IFile[]{};
        }
        return result;
    }
}

