/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal;

import com.ibm.etools.webtools.services.api.objects.IServiceFinder;
import com.ibm.etools.webtools.services.api.objects.IServiceInvocationGenerator;
import com.ibm.etools.webtools.services.api.objects.ServiceData;
import com.ibm.etools.webtools.services.internal.servicebean.IServiceListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractServiceFinder
implements IServiceFinder {
    private Map<IProject, List<ServiceData>> fServiceMap;
    private IServiceFinder fParentFinder;
    private IServiceInvocationGenerator fServiceInvocationGenerator;

    protected AbstractServiceFinder(IServiceInvocationGenerator generator) {
        this.fServiceInvocationGenerator = generator;
    }

    protected Map<IProject, List<ServiceData>> getServiceMap() {
        if (this.fServiceMap == null) {
            this.fServiceMap = new HashMap<IProject, List<ServiceData>>();
        }
        return this.fServiceMap;
    }

    public void flushClientCache(IProject project) {
        if (project != null) {
            this.fServiceMap.remove(project);
        } else {
            this.fServiceMap.clear();
        }
    }

    public final IServiceInvocationGenerator getServiceGenerator() {
        return this.fServiceInvocationGenerator;
    }

    @Override
    public List<ServiceData> getServices(IProject project, Object id, IProgressMonitor monitor) {
        return this.getServiceGenerator().getId() == id ? this.getServices(project, monitor) : null;
    }

    @Override
    public IServiceFinder getParentFinder() {
        return this.fParentFinder;
    }

    public void setParentFinder(IServiceFinder parentFinder) {
        this.fParentFinder = parentFinder;
    }

    public List<ServiceData> getServices(IProject project, IServiceListener listener, Set<String> projectFacetIds, IProgressMonitor monitor) {
        return this.getServices(project, listener, monitor);
    }
}

