/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.api.objects;

import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.services.api.objects.IServiceInvocationGenerator;
import com.ibm.etools.webtools.services.api.objects.ServiceData;
import com.ibm.etools.webtools.services.internal.ServiceBuilder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class ServiceMethodData
implements Comparable {
    protected JavaType fReturnType;
    protected ParameterType[] fParameterTypes;
    private IMethod fMethod;
    private ServiceData fService;
    private List<IType> fServiceInvocationBeans;
    private ServiceBuilder fBuilder;

    public ServiceMethodData(ServiceData service, IMethod method) {
        Assert.isNotNull((Object)service);
        this.fService = service;
        this.fMethod = method;
    }

    public IMethod getMethod() {
        return this.fMethod;
    }

    public String getMethodName() {
        return this.fMethod.getElementName();
    }

    public String getLabel() {
        StringBuilder label = new StringBuilder();
        if (this.fMethod != null) {
            label.append(this.fMethod.getElementName());
            label.append("(");
            if (this.fParameterTypes != null) {
                int i = 0;
                while (i < this.fParameterTypes.length) {
                    ParameterType param = this.fParameterTypes[i];
                    label.append(param.getLabel());
                    if (this.fParameterTypes.length > i + 1) {
                        label.append(",");
                    }
                    ++i;
                }
            }
            label.append(")");
        }
        return label.toString();
    }

    public void addServiceInvocationBean(IType bean) {
        this.getServiceInvocationBeans().add(bean);
    }

    public List<IType> getServiceInvocationBeans() {
        if (this.fServiceInvocationBeans == null) {
            this.fServiceInvocationBeans = new ArrayList<IType>();
        }
        return this.fServiceInvocationBeans;
    }

    public void setServiceInvocationBeans(List<IType> serviceInvocationBeans) {
        this.fServiceInvocationBeans = serviceInvocationBeans;
    }

    public ServiceData getService() {
        return this.fService;
    }

    public JavaType getReturnType() {
        return this.fReturnType;
    }

    public ParameterType[] getParameterTypes() {
        return this.fParameterTypes;
    }

    void setBinding(IMethodBinding binding) {
        if (binding != null) {
            ITypeBinding returnType = binding.getReturnType();
            this.fReturnType = new JavaType(returnType);
            ITypeBinding[] parameters = binding.getParameterTypes();
            String[] paramNames = null;
            try {
                paramNames = this.fMethod.getParameterNames();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            if (parameters != null && paramNames != null) {
                this.fParameterTypes = new ParameterType[parameters.length];
                int i = 0;
                while (i < parameters.length) {
                    ITypeBinding paramBinding = parameters[i];
                    this.fParameterTypes[i] = new ParameterType(paramBinding, paramNames[i]);
                    ++i;
                }
            }
        }
    }

    public void setServiceBuilder(ServiceBuilder builder) {
        this.fBuilder = builder;
    }

    public ServiceBuilder getBuilder(IServiceInvocationGenerator.GenerationData genData) {
        if (this.fBuilder == null) {
            try {
                this.fBuilder = this.createBuilder(genData);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return this.fBuilder;
    }

    protected ServiceBuilder createBuilder(IServiceInvocationGenerator.GenerationData genData) throws JavaModelException {
        return this.getService().getGenerator().createBuilder(genData);
    }

    public boolean equals(Object o) {
        ParameterType[] thatParams;
        ParameterType[] thisParams;
        ServiceMethodData that;
        boolean equal = super.equals(o);
        if (!equal && this.getMethod() != null && o != null && o instanceof ServiceMethodData && (that = (ServiceMethodData)o).getMethod() != null && ServiceMethodData.compare(this.getMethodName(), that.getMethodName()) && ServiceMethodData.compare(this.getReturnType(), that.getReturnType()) && !(equal = ServiceMethodData.compare(thisParams = this.getParameterTypes(), thatParams = that.getParameterTypes())) && thisParams != null && thatParams != null && thisParams.length == thatParams.length) {
            equal = true;
            int i = 0;
            while (i < thisParams.length) {
                if (!ServiceMethodData.compare(thisParams[i], thatParams[i])) {
                    equal = false;
                    break;
                }
                ++i;
            }
        }
        return equal;
    }

    static boolean compare(Object o1, Object o2) {
        return o1 == o2 || o1 == null && o2 == null || o1 != null && o1.equals(o2);
    }

    public int compareTo(Object o) {
        return o == null ? 1 : this.getLabel().compareToIgnoreCase(((ServiceMethodData)o).getLabel());
    }

    public static class JavaType {
        protected boolean fIsArray;
        protected boolean fIsVoid;
        protected boolean fIsPrimitive;
        protected boolean fIsGeneric;
        protected IType fType;
        protected String fSimpleName;
        protected String fQualifiedName;
        protected String fUntrimmedQualifiedName;
        protected int fArrayDimension;
        protected boolean fHasNonPrimitiveProperties;

        protected JavaType() {
        }

        JavaType(ITypeBinding binding) {
            Assert.isNotNull((Object)binding);
            this.init(binding);
        }

        public IType getType() {
            return this.fType;
        }

        public boolean isArray() {
            return this.fIsArray;
        }

        public int getArrayDimensions() {
            return this.fArrayDimension;
        }

        public String getSimpleName() {
            return this.fSimpleName;
        }

        public String getQualifiedName() {
            return this.fQualifiedName;
        }

        public boolean isVoid() {
            return this.fIsVoid;
        }

        public boolean isPrimitive() {
            return this.fIsPrimitive;
        }

        public boolean hasNonPrimitiveProperties() {
            return this.fHasNonPrimitiveProperties;
        }

        public String getLabel() {
            StringBuilder label = new StringBuilder();
            if (this.fSimpleName != null) {
                label.append(this.fSimpleName);
                if (this.fIsArray) {
                    int i = 0;
                    while (i < this.fArrayDimension) {
                        label = label.append("[]");
                        ++i;
                    }
                }
            }
            return label.toString();
        }

        public String getUntrimmedQName() {
            return this.fUntrimmedQualifiedName;
        }

        private void init(ITypeBinding binding) {
            this.fIsGeneric = binding.isGenericType();
            this.fIsArray = binding.isArray();
            this.fType = (IType)binding.getJavaElement();
            this.fSimpleName = this.initArray(binding.getName());
            this.fUntrimmedQualifiedName = binding.getQualifiedName();
            this.fQualifiedName = this.initArray(this.fUntrimmedQualifiedName);
            this.fIsPrimitive = binding.isPrimitive();
            boolean bl = this.fIsVoid = this.fIsPrimitive && "void".equals(this.fSimpleName);
            if (this.fType != null) {
                List properties = JavaCodeUtil.getJavaBeanProperties((IType)this.fType);
                for (IMethod method : properties) {
                    if (method.getNumberOfParameters() != 0 || JavaCodeUtil.isPrimitive((IMethod)method)) continue;
                    this.fHasNonPrimitiveProperties = true;
                    break;
                }
            }
        }

        protected String initArray(String name) {
            int arrayCount = 0;
            int start = Math.max(0, name.lastIndexOf("."));
            char match = '[';
            String trimmedName = name;
            int j = start;
            while (j < name.length()) {
                if (name.charAt(j) == match && arrayCount++ == 0) {
                    trimmedName = name.substring(0, j);
                }
                ++j;
            }
            this.fArrayDimension = arrayCount;
            return trimmedName;
        }

        public static String getPrimitiveWrapper(JavaType type) {
            String name;
            Assert.isNotNull((Object)type);
            String wrapper = null;
            if (type.isPrimitive() && !type.isVoid() && (name = type.getSimpleName()) != null && name.length() > 1) {
                wrapper = "int".equals(name) ? "Integer" : String.valueOf(String.valueOf(name.charAt(0)).toUpperCase()) + name.substring(1);
            }
            return wrapper;
        }

        public void setArray(boolean isArray) {
            this.fIsArray = isArray;
        }

        public void setVoid(boolean isVoid) {
            this.fIsVoid = isVoid;
        }

        public void setPrimitive(boolean isPrimitive) {
            this.fIsPrimitive = isPrimitive;
        }

        public void setType(IType type) {
            this.fType = type;
        }

        public void setSimpleName(String simpleName) {
            this.fSimpleName = simpleName;
        }

        public void setQualifiedName(String qualifiedName) {
            this.fQualifiedName = qualifiedName;
        }

        public void setUntrimmedQualifiedName(String untrimmedQualifiedName) {
            this.fUntrimmedQualifiedName = untrimmedQualifiedName;
        }

        public boolean equals(Object o) {
            boolean equal = super.equals(o);
            if (!equal && o != null && o instanceof JavaType) {
                JavaType jType = (JavaType)o;
                if (this.getType() != null && jType.getType() != null) {
                    equal = this.getType().equals(jType.getType());
                }
                if (!equal && this.getQualifiedName() != null && !this.getQualifiedName().equals("")) {
                    equal = this.getQualifiedName().equals(jType.getQualifiedName()) && this.getArrayDimensions() == jType.getArrayDimensions();
                }
            }
            return equal;
        }
    }

    public static class ParameterType
    extends JavaType {
        private String fInstanceName;

        protected ParameterType(String instanceName) {
            this.fInstanceName = instanceName;
        }

        ParameterType(ITypeBinding binding, String instanceName) {
            super(binding);
            this.fInstanceName = instanceName;
        }

        public String getInstanceName() {
            return this.fInstanceName;
        }
    }
}

