/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.api.objects;

import com.ibm.etools.webtools.services.api.ServicesAPI;
import com.ibm.etools.webtools.services.api.objects.IServiceInvocationGenerator;
import com.ibm.etools.webtools.services.api.objects.ServiceMethodData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class ServiceData {
    protected boolean fMethodsInitialized = false;
    private IServiceInvocationGenerator fServiceInvocationGenerator;
    private IType fServiceClass;
    private IType fServiceInterface;
    private ServiceMethodData.JavaType fClassJavaType;
    private IJavaProject fJavaProject;
    private List<ServiceMethodData> fServiceMethods;
    private String fName;
    private String fQualifiedName;

    public String getName() {
        return this.fName;
    }

    public String getAnnotation() {
        return null;
    }

    public String getQualifiedName() {
        if (this.fQualifiedName == null && this.fClassJavaType != null) {
            this.fQualifiedName = this.fClassJavaType.getQualifiedName();
        }
        return this.fQualifiedName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public ServiceData(IJavaProject project, IType serviceClass, IType serviceInterface, IServiceInvocationGenerator generator) {
        this.fJavaProject = project;
        this.fServiceInvocationGenerator = generator;
        this.fServiceClass = serviceClass;
        this.fServiceInterface = serviceInterface;
    }

    public static boolean isServiceMethod(IMethod method, boolean needsAccessCheck) {
        boolean isServiceMethod;
        boolean bl = isServiceMethod = method != null;
        if (isServiceMethod && needsAccessCheck) {
            try {
                int flags = method.getFlags();
                isServiceMethod = Flags.isPublic((int)flags) && !Flags.isAbstract((int)flags) && !Flags.isStatic((int)flags);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return isServiceMethod;
    }

    protected void addMethods(IMethod[] methods, boolean needsAccessCheck) {
        if (methods != null && methods.length > 0) {
            if (this.fServiceMethods == null) {
                this.fServiceMethods = new ArrayList<ServiceMethodData>(methods.length + 5);
            }
            int i = 0;
            while (i < methods.length) {
                this.addMethod(methods[i], needsAccessCheck);
                ++i;
            }
        }
    }

    protected void addMethods(IMethod[] methods) {
        this.addMethods(methods, false);
    }

    public ServiceMethodData addMethod(IMethod method, boolean needsAccessCheck) {
        ServiceMethodData methodData = null;
        if (ServiceData.isServiceMethod(method, needsAccessCheck)) {
            methodData = new ServiceMethodData(this, method);
            this.addMethod(methodData);
        }
        return methodData;
    }

    public ServiceMethodData addMethod(IMethod method) {
        return this.addMethod(method, false);
    }

    protected void addMethod(ServiceMethodData method) {
        this.fMethodsInitialized = false;
        if (this.fServiceMethods == null) {
            this.fServiceMethods = new ArrayList<ServiceMethodData>(5);
        }
        this.fServiceMethods.add(method);
    }

    public IJavaProject getProject() {
        return this.fJavaProject;
    }

    public IType getServiceClass() {
        return this.fServiceClass;
    }

    public IType getServiceInterface() {
        return this.fServiceInterface;
    }

    public List<ServiceMethodData> getServiceMethods() {
        if (!this.fMethodsInitialized && this.fServiceMethods != null && this.fServiceMethods.size() > 0) {
            this.fMethodsInitialized = true;
            IMember[] elements = new IMember[this.fServiceMethods.size() + 1];
            int i = 0;
            while (i < elements.length - 1) {
                elements[i] = this.fServiceMethods.get(i).getMethod();
                ++i;
            }
            IType primary = this.getPrimaryServiceType();
            elements[elements.length - 1] = primary;
            ICompilationUnit icu = primary.getCompilationUnit();
            if (icu != null) {
                ASTParser parser = ASTParser.newParser((int)3);
                parser.setSource(icu);
                parser.setResolveBindings(true);
                IBinding[] bindings = parser.createBindings((IJavaElement[])elements, null);
                if (bindings != null) {
                    ArrayList<ServiceMethodData> filteredMethods = new ArrayList<ServiceMethodData>(this.fServiceMethods.size());
                    int i2 = 0;
                    while (i2 < bindings.length - 1) {
                        ServiceMethodData serviceMethod = this.fServiceMethods.get(i2);
                        IMethodBinding binding = (IMethodBinding)bindings[i2];
                        serviceMethod.setBinding(binding);
                        if (!filteredMethods.contains(serviceMethod)) {
                            filteredMethods.add(serviceMethod);
                        }
                        ++i2;
                    }
                    this.setBinding((ITypeBinding)bindings[bindings.length - 1]);
                    this.fServiceMethods = filteredMethods;
                }
            } else if (ServicesAPI.DEBUG) {
                System.out.println("... no compilation unit");
            }
            Collections.sort(this.fServiceMethods);
        }
        return this.fServiceMethods;
    }

    protected List<ServiceMethodData> getServiceMethodList() {
        return this.fServiceMethods;
    }

    private void setBinding(ITypeBinding binding) {
        this.fClassJavaType = new ServiceMethodData.JavaType(binding);
    }

    public ServiceMethodData.JavaType getClassJavaType() {
        return this.fClassJavaType;
    }

    public void setMethods(List<ServiceMethodData> serviceMethods) {
        this.fServiceMethods = serviceMethods;
    }

    public IServiceInvocationGenerator getGenerator() {
        return this.fServiceInvocationGenerator;
    }

    public IType getPrimaryServiceType() {
        return this.fServiceClass != null ? this.fServiceClass : this.fServiceInterface;
    }
}

