/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.ui.internal.wizard;

import com.ibm.etools.webtools.model.ModelManager;
import com.ibm.etools.webtools.model.ModelPackage;
import com.ibm.etools.webtools.model.WebModelCreationException;
import com.ibm.etools.webtools.model.api.JSP;
import com.ibm.etools.webtools.model.api.WebModel;
import com.ibm.etools.webtools.model.util.ModelUtil;
import com.ibm.etools.webtools.model.util.ProjectUtil;
import com.ibm.etools.webtools.pagedatamodel.wizards.Util;
import com.ibm.etools.webtools.pagedataview.javabean.codebehind.nls.ResourceHandler;
import com.ibm.etools.webtools.services.api.objects.ServiceData;
import com.ibm.etools.webtools.services.api.objects.ServiceMethodData;
import com.ibm.etools.webtools.services.internal.webservice.Debug;
import com.ibm.etools.webtools.services.ui.Activator;
import com.ibm.etools.webtools.services.ui.internal.wizard.AbstractServiceWizard;
import com.ibm.etools.webtools.services.ui.internal.wizard.WizardData;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelper;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public abstract class AbstractServiceWizardPage
extends WizardPage
implements Listener,
SelectionListener {
    protected static final String ADD = ResourceHandler.WSBaseSelectionPage_Add_new_Web_Service____1;
    protected WizardData fWizardData;
    protected Table fTable;
    protected Combo fMethodCombo;
    protected Combo fProjectCombo;
    protected Combo fPageCombo;
    protected Label fPageLabel;
    protected Label fServiceTableLabel;
    protected Label fMethodLabel;
    protected Button fGenerateUIButton;
    protected Button fProjectNewButton;
    protected Button fPageBrowseButton;
    protected Button fPageNewButton;
    protected Button fAddServiceButton;
    protected Link fPreferencesButton;
    protected IProject[] fFacesWebProjects;
    protected int fRootIndex;
    protected IContainer fWebFolder;

    public AbstractServiceWizardPage(WizardData data) {
        super("1");
        this.fWizardData = data;
        Debug.beginRecording((String)"wswizard");
    }

    protected void createPageControl(Composite parent) {
        if (this.fWizardData != null && this.fWizardData.allowProjectSelection()) {
            this.createPageControlWithProjectSelection(parent);
        } else {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(1808));
            this.createLabel(composite, ResourceHandler.SelectWS, null);
            this.createServiceTable(composite, 5);
            GridData gd = new GridData();
            gd.horizontalIndent = 5;
            Composite buttonComposite = new Composite(composite, 0);
            GridLayout gl = new GridLayout();
            gl.numColumns = 2;
            buttonComposite.setLayout((Layout)gl);
            buttonComposite.setLayoutData((Object)new GridData(1808));
            this.createAddServiceButton(buttonComposite, gd);
            this.createPreferencesButton(buttonComposite);
            this.createLabel(composite, null, null);
            this.createLabel(composite, ResourceHandler.selectMethod, null);
            this.createMethodCombo(composite, 5);
            this.createGenUIButton(composite, 2);
            this.fillServices();
            this.fillMethods();
            Util.UniqueMnemonicLabelProvider.renameButtonControls((Composite)parent, (boolean)true);
            this.setControl((Control)parent);
        }
    }

    protected void createPageControlWithProjectSelection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectControls(composite);
        this.createSpacer(composite, 3);
        GridData gd = new GridData(34);
        gd.verticalIndent = 3;
        this.fServiceTableLabel = this.createLabel(composite, ResourceHandler.Service, gd);
        this.createServiceTable(composite, 0);
        Composite buttonComposite = new Composite(composite, 0);
        gd = new GridData(260);
        buttonComposite.setLayoutData((Object)gd);
        gl = new GridLayout();
        gl.marginWidth = 0;
        buttonComposite.setLayout((Layout)gl);
        this.createAddServiceButton(buttonComposite, new GridData(772));
        this.createPreferencesButton(buttonComposite);
        this.createLabel(buttonComposite, null, new GridData(1808));
        this.createSpacer(composite, 3);
        this.fMethodLabel = this.createLabel(composite, ResourceHandler.Method, null);
        this.createMethodCombo(composite, 0);
        this.createLabel(composite, null, null);
        Composite child = new Composite(composite, 0);
        gl = new GridLayout();
        gl.marginWidth = 0;
        child.setLayout((Layout)gl);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        child.setLayoutData((Object)gd);
        this.createGenUIButton(child, 3);
        this.createTargetControls(composite);
        this.initialize();
        Util.UniqueMnemonicLabelProvider.renameButtonControls((Composite)parent, (boolean)true);
        this.setControl((Control)parent);
    }

    protected void initialize() {
        this.initProjects();
        this.updateControlsForProjectSelection();
        this.fillServices();
        this.fillMethods();
    }

    private void createProjectControls(Composite composite) {
        this.createLabel(composite, ResourceHandler.Project, null);
        this.fProjectCombo = new Combo(composite, 12);
        GridData gd = new GridData(1808);
        this.fProjectCombo.setLayoutData((Object)gd);
        this.fProjectCombo.addSelectionListener((SelectionListener)this);
        this.fProjectNewButton = new Button(composite, 8);
        this.fProjectNewButton.setText(ResourceHandler.New);
        gd = new GridData(256);
        this.fProjectNewButton.setLayoutData((Object)gd);
        this.fProjectNewButton.addSelectionListener((SelectionListener)this);
    }

    private void createServiceTable(Composite composite, int horizontalIndent) {
        this.fTable = new Table(composite, 67588);
        GridData gd = new GridData(1808);
        gd.heightHint = 90;
        gd.widthHint = this.convertHorizontalDLUsToPixels(320);
        gd.horizontalIndent = horizontalIndent;
        this.fTable.setLayoutData((Object)gd);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(false);
        TableColumn[] tableColumns = new TableColumn[2];
        tableColumns[0] = new TableColumn(this.fTable, 0);
        tableColumns[0].setText(ResourceHandler.WSBaseSelectionPage_Name_3);
        tableColumns[1] = new TableColumn(this.fTable, 0);
        tableColumns[1].setText(ResourceHandler.WSBaseSelectionPage_Class_4);
        this.fTable.addControlListener((ControlListener)new TableResizeListener());
        this.fTable.addSelectionListener((SelectionListener)this);
    }

    private void createAddServiceButton(Composite parent, GridData gd) {
        this.fAddServiceButton = new Button(parent, 0);
        this.fAddServiceButton.setText(ResourceHandler.add);
        this.fAddServiceButton.setLayoutData((Object)gd);
        this.fAddServiceButton.addSelectionListener((SelectionListener)this);
    }

    protected void createPreferencesButton(Composite parent) {
        this.fPreferencesButton = new Link(parent, 0);
        this.fPreferencesButton.setText("<a>" + ResourceHandler.Preferences + "</a>");
        this.fPreferencesButton.setLayoutData((Object)new GridData());
        this.fPreferencesButton.addSelectionListener((SelectionListener)this);
    }

    private void createMethodCombo(Composite composite, int horizontalIndent) {
        this.fMethodCombo = new Combo(composite, 8);
        GridData gd = new GridData(256);
        gd.horizontalIndent = horizontalIndent;
        this.fMethodCombo.setLayoutData((Object)gd);
        this.fMethodCombo.addSelectionListener((SelectionListener)this);
    }

    private void createGenUIButton(Composite composite, int spacers) {
        if (this.fWizardData.isGenerateUI()) {
            this.createSpacer(composite, spacers);
            this.fGenerateUIButton = new Button(composite, 16416);
            this.fGenerateUIButton.setText(ResourceHandler.createUIbutton);
            this.fGenerateUIButton.setLayoutData((Object)new GridData(8));
            this.fGenerateUIButton.setSelection(this.fWizardData.isGenerateUI());
            this.fGenerateUIButton.addSelectionListener((SelectionListener)this);
        }
    }

    private void createSpacer(Composite composite, int count) {
        int i = 0;
        while (i < count) {
            new Label(composite, 0);
            ++i;
        }
    }

    private Label createLabel(Composite composite, String text, GridData gd) {
        Label label = new Label(composite, 0);
        if (text != null) {
            label.setText(text);
        }
        if (gd == null) {
            gd = new GridData(36);
        }
        label.setLayoutData((Object)gd);
        return label;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        this.createPageControl(composite);
        this.setPageComplete(this.isPageComplete());
        this.setControl((Control)composite);
    }

    protected void handleTableSelected(SelectionEvent e) {
        if (this.isOK((Control)this.fTable)) {
            ServiceData selectedService;
            int index = this.fTable.getSelectionIndex();
            ServiceData serviceData = selectedService = this.fTable.getItemCount() > 0 && index >= 0 ? this.fWizardData.getServices().get(index) : null;
            if (selectedService != this.getSelectedService()) {
                this.setSelectedService(selectedService);
                this.fillMethods();
            }
        }
    }

    protected void handleMethodSelected(SelectionEvent e) {
        if (this.isOK((Control)this.fMethodCombo)) {
            int index = this.fMethodCombo.getSelectionIndex();
            List serviceMethods = this.getSelectedService().getServiceMethods();
            if (serviceMethods != null && index >= 0 && index < serviceMethods.size() && index != serviceMethods.indexOf(this.fWizardData.getSelectedMethod())) {
                this.setMethod((ServiceMethodData)this.getSelectedService().getServiceMethods().get(index));
            }
        }
    }

    public void setMethod(ServiceMethodData method) {
        this.fWizardData.getController().setSelectedMethod(method);
        this.updatePages();
        this.updateTargetControlEnablement();
    }

    protected void fillServices() {
        if (this.isOK((Control)this.fTable)) {
            this.fTable.removeAll();
            if (this.fWizardData.getProject() != null) {
                this.fWizardData.getController().populateServices();
                List<ServiceData> services = this.getWizardData().getServices();
                if (services != null && services.size() > 0) {
                    for (ServiceData service : services) {
                        String name = service.getName();
                        if (name == null) {
                            name = service.getServiceInterface() != null ? service.getServiceInterface().getElementName() : service.getServiceClass().getElementName();
                        }
                        if (name == null || name.equals("")) continue;
                        TableItem tableItem = new TableItem(this.fTable, 0);
                        tableItem.setText(0, name);
                        String qualifiedName = service.getPrimaryServiceType().getFullyQualifiedName();
                        if (qualifiedName == null) continue;
                        tableItem.setText(1, qualifiedName);
                    }
                }
            }
        }
    }

    protected abstract Object getServiceKey();

    protected void fillMethods() {
        if (this.isOK((Control)this.fMethodCombo)) {
            List serviceMethods;
            this.fMethodCombo.removeAll();
            ServiceMethodData selectedMethod = null;
            ServiceData selectedService = this.getSelectedService();
            if (selectedService != null && (serviceMethods = selectedService.getServiceMethods()) != null) {
                int i = 0;
                while (i < serviceMethods.size()) {
                    ServiceMethodData method = (ServiceMethodData)serviceMethods.get(i);
                    this.fMethodCombo.add(method.getLabel());
                    ++i;
                }
                if (serviceMethods.size() > 0) {
                    this.fMethodCombo.select(0);
                    selectedMethod = (ServiceMethodData)serviceMethods.get(0);
                }
            }
            this.setMethod(selectedMethod);
            this.setPageComplete(this.isPageComplete());
        }
    }

    protected void initProjects() {
        if (this.fWizardData != null && this.fWizardData.allowProjectSelection()) {
            List facesProjects = ProjectUtil.getFacesWebProjects();
            this.fFacesWebProjects = facesProjects.toArray(new IProject[facesProjects.size()]);
            this.sort(this.fFacesWebProjects);
            this.fillProjectCombo();
        }
    }

    protected void sort(IProject[] projects) {
        if (projects != null && projects.length > 1) {
            Arrays.sort(projects, new Comparator<IProject>(){

                @Override
                public int compare(IProject a, IProject b) {
                    return a.getName().compareToIgnoreCase(b.getName());
                }

                @Override
                public boolean equals(Object a) {
                    return super.equals(a);
                }
            });
        }
    }

    private void fillProjectCombo() {
        if (this.isOK((Control)this.fProjectCombo)) {
            int index;
            String name;
            IProject project;
            IVirtualComponent component;
            this.fProjectCombo.removeAll();
            if (this.fFacesWebProjects != null) {
                int i = 0;
                while (i < this.fFacesWebProjects.length) {
                    this.fProjectCombo.add(this.fFacesWebProjects[i].getName());
                    ++i;
                }
            }
            if ((component = this.fWizardData.getComponent()) != null && (project = component.getProject()) != null && (name = project.getName()) != null && (index = this.fProjectCombo.indexOf(name)) >= 0) {
                this.fProjectCombo.select(index);
            }
        }
    }

    void selectPage(String jsp) {
        this.fPageCombo.select(this.fPageCombo.indexOf(jsp));
    }

    protected final boolean isOK(Control c) {
        return c != null && !c.isDisposed();
    }

    protected void handleProjectComboSelected(SelectionEvent e) {
        if (this.isOK((Control)this.fProjectCombo)) {
            int index = this.fProjectCombo.getSelectionIndex();
            String projectName = this.fProjectCombo.getItem(index);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            this.handleProjectSelection(project);
        }
    }

    protected void handleProjectSelection(IProject project) {
        this.fWizardData.setComponent(project);
        this.fillServices();
        this.fillMethods();
        this.updateControlsForProjectSelection();
        this.initPageCombo();
        if (this.isOK((Control)this.fPageCombo)) {
            String text = this.fPageCombo.getText();
            this.updateTarget(text);
        }
    }

    protected void updateControlsForProjectSelection() {
        boolean enable = this.fWizardData.getComponent() != null;
        this.enable((Control)this.fGenerateUIButton, enable);
        this.enable((Control)this.fAddServiceButton, enable);
        this.enable((Control)this.fServiceTableLabel, enable);
        this.enable((Control)this.fTable, enable);
        this.enable((Control)this.fMethodLabel, enable);
        this.enable((Control)this.fMethodCombo, enable);
        this.updateTargetControlEnablement();
    }

    protected void enable(Control control, boolean enable) {
        if (this.isOK(control)) {
            control.setEnabled(enable);
        }
    }

    protected void handleAddServiceButton() {
        IProject project;
        String className;
        if (this.fWizardData.getProject() != null && (className = this.launchAddServiceDialog(project = this.fWizardData.getProject())) != null) {
            TableItem[] tableItems;
            Util.ensureBuildComplete((IProject)project, (boolean)true);
            this.fillServices();
            if ((className == null || "".equals(className)) && this.isOK((Control)this.fTable) && (tableItems = this.fTable.getItems()) != null && tableItems.length == 1 && tableItems[0] != null) {
                className = tableItems[0].getText(1);
            }
            this.select(className);
            this.handleTableSelected(null);
            this.fillMethods();
            this.setPageComplete(this.isPageComplete());
        }
    }

    protected abstract String launchAddServiceDialog(IProject var1);

    protected void handleBrowseForPage() {
        Object element;
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){
            Status fOkStatus = new Status(0, Activator.getDefault().getBundle().getSymbolicName(), 0, "", null);
            Status fNotOkStatus = new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 4, "", null);

            public IStatus validate(Object[] selection) {
                return selection != null && selection.length == 1 && selection[0] != null && selection[0] instanceof IFile ? this.fOkStatus : this.fNotOkStatus;
            }
        };
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                boolean ret = false;
                if (element != null) {
                    if (element instanceof IFile) {
                        String ext = ((IFile)element).getFileExtension();
                        ret = ext != null && (ext.equals("jsp") || ext.equals("jsv") || ext.equals("jtpl") || ext.equals("jspx"));
                    } else if (element instanceof IContainer) {
                        boolean bl = ret = !element.equals(AbstractServiceWizardPage.this.fWebFolder);
                        if (ret) {
                            try {
                                IResource[] members = ((IContainer)element).members();
                                ret = members != null && members.length > 0;
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                return ret;
            }
        };
        ViewerComparator comparator = new ViewerComparator(){

            public int category(Object element) {
                return element != null && element instanceof IContainer ? 0 : 1;
            }
        };
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setValidator(validator);
        dialog.setComparator(comparator);
        dialog.setTitle(ResourceHandler.PageSelection);
        dialog.setMessage(ResourceHandler.SelectPage);
        dialog.addFilter(filter);
        dialog.setInput((Object)this.fWebFolder);
        dialog.setAllowMultiple(false);
        if (dialog.open() == 0 && (element = dialog.getFirstResult()) != null && element instanceof IFile) {
            IFile page = (IFile)element;
            String pagePath = page.getProjectRelativePath().toOSString();
            pagePath = pagePath.substring(this.fRootIndex);
            this.fPageCombo.select(this.fPageCombo.indexOf(pagePath));
            this.updateTarget(page);
        }
    }

    protected void handleCreateUIButton(SelectionEvent e) {
        this.fWizardData.setGenerateUI(this.fGenerateUIButton.getSelection());
        this.canFlipToNextPage();
        this.updateTargetControlEnablement();
        this.setPageComplete(this.isPageComplete());
    }

    private void select(String beanName) {
        if (this.isOK((Control)this.fTable) && beanName != null && !"".equals(beanName)) {
            TableItem[] tableItems = this.fTable.getItems();
            int i = 0;
            while (i < tableItems.length) {
                TableItem item = tableItems[i];
                if (beanName.equals(item.getText(1))) {
                    this.fTable.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    protected void createTargetControls(Composite parent) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        Composite child = Util.cc((Composite)parent, (GridData)gd, (int)-1, (int)15, (int)4);
        this.fPageLabel = this.createLabel(child, ResourceHandler.Page, null);
        this.fPageCombo = new Combo(child, 2056);
        this.fPageCombo.setLayoutData((Object)new GridData(768));
        this.fPageCombo.addSelectionListener((SelectionListener)this);
        this.initPageCombo();
        this.fPageBrowseButton = Util.cb((Composite)child, (int)8, (String)ResourceHandler.Browse, (Listener)this);
        this.fPageNewButton = Util.cb((Composite)child, (int)8, (String)ResourceHandler.New, (Listener)this);
        this.updateTargetControlEnablement();
    }

    protected void updateTargetControlEnablement() {
        boolean enable = this.fWizardData.isGenerateUI() && this.fWizardData.getComponent() != null && this.fWizardData.getSelectedMethod() != null;
        this.enable((Control)this.fPageLabel, enable);
        this.enable((Control)this.fPageCombo, enable);
        this.enable((Control)this.fPageBrowseButton, enable);
        this.enable((Control)this.fPageNewButton, enable);
    }

    protected void handlePreferenceButton() {
    }

    protected void handleNewProjectButton() {
        ISpecializationType specializationType = (ISpecializationType)ElementTypeRegistry.getInstance().getType("webmodel.project");
        IEditHelperAdvice advice = specializationType.getEditHelperAdvice();
        EClass eClass = ModelPackage.eINSTANCE.getWebModel();
        IElementType type = ElementTypeRegistry.getInstance().getElementType(eClass);
        CreateElementRequest req = new CreateElementRequest(type);
        ICommand cmd = advice.getBeforeEditCommand((IEditCommandRequest)req);
        if (cmd != null) {
            Object project;
            try {
                cmd.execute(null, null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            CommandResult result = cmd.getCommandResult();
            if (result != null && (project = result.getReturnValue()) != null && project instanceof IProject) {
                this.initProjects();
                String name = ((IProject)project).getName();
                int index = this.fProjectCombo.indexOf(name);
                this.fProjectCombo.select(index);
                this.handleProjectSelection((IProject)project);
            }
        }
    }

    protected void handleNewPageButton() {
        CreateElementRequest req;
        ISpecializationType specializationType;
        IEditHelperAdvice advice;
        ICommand cmd;
        IElementType pageType;
        IEditHelper helper;
        WebModel webModel = null;
        try {
            webModel = ModelUtil.getModel((IVirtualComponent)this.fWizardData.getComponent());
        }
        catch (WebModelCreationException e1) {
            e1.printStackTrace();
        }
        if (webModel != null && (helper = (pageType = ElementTypeRegistry.getInstance().getElementType((EObject)webModel)).getEditHelper()) != null && (cmd = (advice = (specializationType = (ISpecializationType)ElementTypeRegistry.getInstance().getType("webmodel.jsp.webpage")).getEditHelperAdvice()).getBeforeEditCommand((IEditCommandRequest)(req = new CreateElementRequest((EObject)webModel, (IElementType)specializationType, ModelPackage.eINSTANCE.getWebModel_JSP_Pages())))) != null) {
            Object page;
            try {
                cmd.execute(null, null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            CommandResult result = cmd.getCommandResult();
            if (result != null && (page = result.getReturnValue()) != null && page instanceof IFile) {
                this.initPageCombo();
                String name = this.getJSPName((IFile)page);
                this.fPageCombo.select(this.fPageCombo.indexOf(name));
                this.updateTarget(name);
            }
        }
    }

    private void initPageCombo() {
        IVirtualComponent component = this.fWizardData.getComponent();
        if (component != null) {
            EList jsps = null;
            WebModel webModel = null;
            try {
                webModel = ModelUtil.getModel((IVirtualComponent)component);
            }
            catch (WebModelCreationException e) {
                e.printStackTrace();
            }
            jsps = webModel.getJSP_Pages();
            this.fWebFolder = component.getRootFolder().getUnderlyingFolder();
            this.fRootIndex = this.fWebFolder.getProjectRelativePath().toOSString().length();
            if (this.fPageCombo != null) {
                this.fPageCombo.removeAll();
                Iterator iter = jsps.iterator();
                while (iter.hasNext()) {
                    this.fPageCombo.add(this.getJSPName(((JSP)iter.next()).getFile()));
                }
            }
        }
    }

    private String getJSPName(IFile jsp) {
        String name = jsp.getProjectRelativePath().toOSString();
        name = name.substring(this.fRootIndex);
        return name;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Debug.endRecording((String)"wswizard", (boolean)false);
            Debug.endRecording((String)"startwizard", (boolean)true);
        }
    }

    protected ServiceData getSelectedService() {
        return this.fWizardData.getSelectedService();
    }

    protected void setSelectedService(ServiceData service) {
        this.fWizardData.setSelectedService(service);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.fPageCombo) {
            String text = this.fPageCombo.getText();
            this.updateTarget(text);
        } else if (e.widget == this.fProjectNewButton) {
            this.handleNewProjectButton();
        } else if (e.widget == this.fGenerateUIButton) {
            this.handleCreateUIButton(e);
        } else if (e.widget == this.fTable) {
            this.handleTableSelected(e);
        } else if (e.widget == this.fMethodCombo) {
            this.handleMethodSelected(e);
        } else if (e.widget == this.fProjectCombo) {
            this.handleProjectComboSelected(e);
        } else if (e.widget == this.fAddServiceButton) {
            this.handleAddServiceButton();
        } else if (e.widget == this.fPreferencesButton) {
            this.handlePreferenceButton();
        }
    }

    public void handleEvent(Event event) {
        if (event.widget == this.fPageBrowseButton) {
            this.handleBrowseForPage();
        } else if (event.widget == this.fPageNewButton) {
            this.handleNewPageButton();
        }
    }

    protected void updateTarget(String name) {
        IFile file = null;
        if (name != null && !"".equals(name)) {
            file = (IFile)this.fWebFolder.findMember(name);
        }
        this.updateTarget(file);
    }

    protected void updateTarget(IFile file) {
        JSP jsp = null;
        try {
            if (file != null) {
                jsp = ModelManager.getModel((IResource)file).getJSP(file);
            }
            this.fWizardData.setJSP(jsp);
            this.fWizardData.getController().createCodeGenModel();
            this.updatePages();
            this.setPageComplete(this.isPageComplete());
        }
        catch (WebModelCreationException e) {
            e.printStackTrace();
        }
    }

    public boolean isPageComplete() {
        boolean isComplete;
        boolean bl = isComplete = this.fWizardData.getSelectedMethod() != null;
        if (isComplete && this.fWizardData.isGenerateUI() && this.fWizardData.getEditDomain() == null) {
            isComplete = false;
        }
        return isComplete;
    }

    protected WizardData getWizardData() {
        return this.fWizardData;
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && this.fWizardData.isGenerateUI();
    }

    protected void updatePages() {
        ((AbstractServiceWizard)this.getWizard()).updatePages();
        this.setPageComplete(this.isPageComplete());
    }

    class TableResizeListener
    extends ControlAdapter {
        protected int fX = -1;
        protected int fY = -1;
        protected Runnable fResizer = new Runnable(){

            @Override
            public void run() {
                if (((TableResizeListener)TableResizeListener.this).AbstractServiceWizardPage.this.fTable != null && !((TableResizeListener)TableResizeListener.this).AbstractServiceWizardPage.this.fTable.isDisposed()) {
                    Point size = ((TableResizeListener)TableResizeListener.this).AbstractServiceWizardPage.this.fTable.getSize();
                    if (size.x != TableResizeListener.this.fX && size.x > 6 || size.y != TableResizeListener.this.fY && size.y > 6) {
                        TableResizeListener.this.fX = size.x;
                        TableResizeListener.this.fY = size.y;
                        TableColumn column = ((TableResizeListener)TableResizeListener.this).AbstractServiceWizardPage.this.fTable.getColumn(0);
                        if (column != null && !column.isDisposed()) {
                            column.setWidth(size.x * 38 / 100);
                        }
                        if ((column = ((TableResizeListener)TableResizeListener.this).AbstractServiceWizardPage.this.fTable.getColumn(1)) != null && !column.isDisposed()) {
                            ScrollBar vBar = ((TableResizeListener)TableResizeListener.this).AbstractServiceWizardPage.this.fTable.getVerticalBar();
                            int scrollWidth = vBar.getMaximum() == vBar.getThumb() ? 0 : vBar.getSize().x + 2;
                            column.setWidth(size.x * 62 / 100 - scrollWidth - 4);
                        }
                    }
                }
            }
        };

        TableResizeListener() {
        }

        public void controlResized(ControlEvent e) {
            Display.getDefault().asyncExec(this.fResizer);
        }
    }
}

