/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.ui.internal.webservice.pagedata;

import com.ibm.etools.webtools.codebehind.api.ICBLanguage;
import com.ibm.etools.webtools.codebehind.core.api.CodeBehindCoreUtil;
import com.ibm.etools.webtools.codebehind.java.JavaCodeBehindPlugin;
import com.ibm.etools.webtools.codebehind.pdm.data.ICBDataNode;
import com.ibm.etools.webtools.codebehind.pdm.data.ICBDataNodeProvider;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.javamodel.api.JavaDocInfo;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.api.JavaModelManager;
import com.ibm.etools.webtools.javamodel.commands.ReadMethodCommand;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModel;
import com.ibm.etools.webtools.pagedataview.javabean.util.WebServicesClientUtil;
import com.ibm.etools.webtools.services.internal.webservice.JavaTypeUtil;
import com.ibm.etools.webtools.services.ui.internal.webservice.data.AxisWebServiceLocator;
import com.ibm.etools.webtools.services.ui.internal.webservice.data.WSClientInfo;
import com.ibm.etools.webtools.services.ui.internal.webservice.pagedata.WSCBJavaBeanPageDataNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;

public class WSCBDataNodeProvider
implements ICBDataNodeProvider {
    public ICBDataNode createPageDataNode(IPageDataModel pdModel, IMethod method, IPageDataNode parent) {
        if (method.getElementName().startsWith("get")) {
            ReadMethodCommand readCmd;
            block13: {
                IDOMDocument xmlDoc = ((PageDataModel)pdModel).getIDOMModel().getDocument();
                ICBLanguage language = CodeBehindCoreUtil.getICBLanguage((IDOMDocument)xmlDoc);
                JavaModel model = JavaModelManager.getInstance().getModel("codebehind", pdModel.getResource().getProject(), language.getCBInfo().location);
                readCmd = new ReadMethodCommand();
                try {
                    try {
                        readCmd.setIdentifier(method.getElementName());
                        readCmd.setParameterNames(method.getParameterNames());
                        readCmd.setParameters(method.getParameterTypes());
                        readCmd.execute(model, null);
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                        model.release();
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    model.release();
                    throw throwable;
                }
                model.release();
            }
            JavaDocInfo jDocInfo = readCmd.getJavadoc();
            if (jDocInfo != null && jDocInfo.getCommentForTag("methodEntry") != null) {
                String realClassName = JavaCodeUtil.getResolvedReturnType((IMethod)method);
                IProject proj = pdModel.getResource().getProject();
                ArrayList endPointInterfaces = new ArrayList(1);
                IVirtualComponent component = ComponentCore.createComponent((IProject)proj);
                WebServicesClientUtil.buildEndPointInterfaces((IVirtualComponent)component, endPointInterfaces);
                this.buildAxisEndpointInterfaces(component.getProject(), endPointInterfaces);
                JavaHelpers beanHelper = null;
                try {
                    beanHelper = JavaTypeUtil.introspect((String)realClassName, (IProject)proj);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException classNotFoundException) {}
                JavaClass returnedVal = WebServicesClientUtil.getImplementedEndPointInterface((JavaHelpers)beanHelper, endPointInterfaces, (IProject)proj);
                if (returnedVal != null) {
                    IDOMDocument xmldoc = ((PageDataModel)pdModel).getIDOMModel().getDocument();
                    String codeBehindBeanName = JavaCodeBehindPlugin.getCodeBehindBeanName((IDOMDocument)xmldoc);
                    return new WSCBJavaBeanPageDataNode(method, pdModel, pdModel.getRoot(), codeBehindBeanName, realClassName);
                }
            }
        }
        return null;
    }

    private void buildAxisEndpointInterfaces(IProject project, List endPointInterfaces) {
        List clients = AxisWebServiceLocator.instance().getWebServiceClients(null, project);
        for (WSClientInfo wsClient : clients) {
            JavaHelpers beanHelper = null;
            String qName = null;
            try {
                if (wsClient.getCls() != null) {
                    qName = wsClient.getCls().getFullyQualifiedName();
                    beanHelper = JavaTypeUtil.introspect((String)qName, (IProject)project);
                }
            }
            catch (CoreException coreException) {
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {}
            JavaHelpers endPointInterface = null;
            if (beanHelper == null || qName == null) continue;
            try {
                endPointInterface = JavaTypeUtil.introspect((String)wsClient.getInterface().getFullyQualifiedName(), (IProject)project);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            endPointInterfaces.add(endPointInterface);
        }
    }
}

