/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.ui.internal.webservice.data;

import com.ibm.etools.webtools.services.ui.internal.webservice.data.WSClientInfo;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.ws.internal.wsfinder.AbstractWebServiceLocator;
import org.eclipse.wst.ws.internal.wsrt.WebServiceClientInfo;

public class AxisWebServiceLocator
extends AbstractWebServiceLocator {
    private String AXIS_STUB = "org.apache.axis.client.Stub";
    private static AxisWebServiceLocator fInstance;

    private AxisWebServiceLocator() {
    }

    public static AxisWebServiceLocator instance() {
        if (fInstance == null) {
            fInstance = new AxisWebServiceLocator();
        }
        return fInstance;
    }

    public List getWebServiceClients(IProgressMonitor monitor, IProject project) {
        LinkedList list = new LinkedList();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)root);
        try {
            IType axisStub;
            javaModel.open(monitor);
            IJavaProject javaProject = javaModel.getJavaProject(project.getName());
            if (javaProject != null && (axisStub = javaProject.findType(this.AXIS_STUB)) != null) {
                this.addAxisProxies(javaProject, axisStub, list, monitor);
            }
            javaModel.close();
        }
        catch (Exception exception) {}
        return list;
    }

    private void addAxisProxies(IJavaProject javaProject, IType axisStub, List list, IProgressMonitor monitor) {
        try {
            ITypeHierarchy axisStubHierarchy = axisStub.newTypeHierarchy(javaProject, monitor);
            IType[] stubs = axisStubHierarchy.getSubtypes(axisStub);
            int s = 0;
            while (s < stubs.length) {
                IType[] seis = axisStubHierarchy.getSuperInterfaces(stubs[s]);
                int i = 0;
                while (i < seis.length) {
                    try {
                        ITypeHierarchy seiHierarchy = seis[i].newTypeHierarchy(javaProject, monitor);
                        IType[] proxies = seiHierarchy.getSubtypes(seis[i]);
                        int p = 0;
                        while (p < proxies.length) {
                            WebServiceClientInfo wscInfo;
                            if (!proxies[p].getFullyQualifiedName().equals(stubs[s].getFullyQualifiedName()) && (wscInfo = this.newWebServiceClientInfo(proxies[p])) != null) {
                                list.add(new WSClientInfo(proxies[p], seis[i]));
                            }
                            ++p;
                        }
                    }
                    catch (Exception exception) {}
                    ++i;
                }
                ++s;
            }
        }
        catch (Exception exception) {}
    }

    private WebServiceClientInfo newWebServiceClientInfo(IType axisProxy) {
        WebServiceClientInfo wscInfo = null;
        try {
            IPath proxyPath;
            IResource resource = axisProxy.getUnderlyingResource();
            if (resource != null && (proxyPath = resource.getLocation()) != null) {
                String proxyURL = proxyPath.toFile().toURL().toString();
                wscInfo = new WebServiceClientInfo();
                wscInfo.setImplURL(proxyURL);
            }
        }
        catch (Exception exception) {}
        return wscInfo;
    }

    public List getWebServices(IProgressMonitor monitor) {
        return super.getWebServices(monitor);
    }
}

