/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.wizards.userDataConstraint;

import com.ibm.etools.web.ui.presentation.WebComboItemHelper;
import com.ibm.etools.webtools.security.web.internal.api.ApiClass;
import com.ibm.etools.webtools.security.web.internal.nls.Messages;
import com.ibm.etools.webtools.security.web.internal.wizards.userDataConstraint.IUserDataConstraintDataModel;
import com.ibm.etools.webtools.security.wizards.internal.SecurityWizardPage;
import com.ibm.etools.webtools.security.wizards.internal.data.models.IAbstractSecurityWizardsContext;
import com.ibm.etools.webtools.security.wizards.internal.data.models.IWizardEvent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class UserDataConstraintPage
extends SecurityWizardPage
implements Listener {
    private Combo userDataConstraintCombo;
    private Text descriptionText;

    public UserDataConstraintPage(String pageName, IUserDataConstraintDataModel model) {
        super(pageName, (IAbstractSecurityWizardsContext)model);
    }

    public UserDataConstraintPage(String pageName, String title, ImageDescriptor titleImage, IUserDataConstraintDataModel model) {
        super(pageName, title, titleImage, (IAbstractSecurityWizardsContext)model);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        composite.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.webtools.security.web.wtsec0095");
        Label labelCombo = new Label(composite, 0);
        labelCombo.setText(Messages.user_data_constraint_transport_guarantee);
        this.userDataConstraintCombo = new Combo(composite, 2056);
        String[] comboValues = new String[4];
        comboValues[0] = "";
        String[] tempValues = WebComboItemHelper.getInst().getTransportGuaranteeTypeItems();
        int i = 0;
        while (i < tempValues.length) {
            comboValues[i + 1] = tempValues[i];
            ++i;
        }
        this.userDataConstraintCombo.setItems(comboValues);
        this.userDataConstraintCombo.addListener(24, (Listener)this);
        Label labelText = new Label(composite, 0);
        labelText.setText(Messages.description);
        this.descriptionText = new Text(composite, 2048);
        this.descriptionText.addListener(24, (Listener)this);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.userDataConstraintCombo.setLayoutData((Object)gd);
        this.descriptionText.setLayoutData((Object)gd);
        this.setControl((Control)composite);
        this.initSelections();
        this.setMessage(Messages.user_data_constriant_description);
        this.setPageComplete(true);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.userDataConstraintCombo) {
            String comboText = this.userDataConstraintCombo.getText();
            this.getModel().setTransportGuarantee(comboText);
            if (comboText.length() < 1) {
                this.descriptionText.setText("");
            }
        } else if (event.widget == this.descriptionText) {
            this.getModel().setUserDataConstraintDescription(this.descriptionText.getText());
        }
    }

    private void initSelections() {
        String description;
        String constraintName = (String)this.getModel().getPropertyValue("constraint name");
        String transportGuarantee = ApiClass.getUserDataConstraintTransportGuarantee(this.getModel().getModelProvider(), constraintName);
        if (transportGuarantee != null) {
            this.userDataConstraintCombo.setText(transportGuarantee);
        }
        if ((description = ApiClass.getUserDataConstraintDescription(this.getModel().getModelProvider(), constraintName)) != null) {
            this.descriptionText.setText(description);
        }
    }

    public IUserDataConstraintDataModel getModel() {
        return (IUserDataConstraintDataModel)this.context;
    }

    public void handleWizardEvent(IWizardEvent event) {
    }

    public void positionCursor() {
        this.userDataConstraintCombo.setFocus();
    }
}

