/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.wizards.url;

import com.ibm.etools.webtools.security.web.internal.api.ApiClass;
import com.ibm.etools.webtools.security.web.internal.nls.Messages;
import com.ibm.etools.webtools.security.web.internal.wizards.url.IURLPatternsWizardDataModel;
import com.ibm.etools.webtools.security.wizards.internal.SecurityWizardPage;
import com.ibm.etools.webtools.security.wizards.internal.data.models.IAbstractSecurityWizardsContext;
import com.ibm.etools.webtools.security.wizards.internal.data.models.IWizardEvent;
import com.ibm.etools.webtools.security.wizards.internal.data.models.WizardPropertyChangedEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class URLPatternsForResourceCollectionPage
extends SecurityWizardPage
implements Listener {
    private Group headerGroup = null;
    private CCombo constraintName = null;
    CCombo collectionName = null;
    private HashMap constraints = new HashMap();
    private HashMap collections = new HashMap();
    IModelProvider modelProvider = null;
    org.eclipse.swt.widgets.List uRLList = null;
    List<String> urlPatterns = new ArrayList<String>();
    Button addButton = null;
    Button deleteButton = null;
    Text newURLPattern = null;
    Button defaultButton = null;

    public URLPatternsForResourceCollectionPage(String pageName, String title, ImageDescriptor titleImage, IURLPatternsWizardDataModel model) {
        super(pageName, title, titleImage, (IAbstractSecurityWizardsContext)model);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.webtools.security.web.wtsec0090");
        this.createHeaderArea(composite);
        this.createURLPatternEntryControl(composite);
        this.setControl((Control)composite);
        this.setMessage(Messages.url_patterns_entry_instructions);
        this.setPageComplete(false);
    }

    private void createHeaderArea(Composite parent) {
        this.headerGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        this.headerGroup.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.headerGroup.setLayoutData((Object)formData);
        this.createConstraintNameArea((Composite)this.headerGroup);
        this.createResourceCollectionNameArea((Composite)this.headerGroup);
        this.defaultButton = parent.getShell().getDefaultButton();
    }

    private void createConstraintNameArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.constraint_name);
        this.constraintName = new CCombo(parent, 2048);
        GridData gridData = new GridData(768);
        this.constraintName.setLayoutData((Object)gridData);
        this.setConstraintName();
        this.constraintName.setEnabled(false);
        this.constraintName.addListener(13, (Listener)new ConstraintSelectionListener());
    }

    private void createResourceCollectionNameArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.resource_collection_name);
        this.collectionName = new CCombo(parent, 2048);
        GridData gridData = new GridData(768);
        this.collectionName.setLayoutData((Object)gridData);
        this.setCollectionName();
        this.collectionName.setEnabled(this.getModel().isEnableCollectionName());
        if (this.getModel().isEnableCollectionName()) {
            this.collectionName.setItems(this.getCollectionNames());
        }
        this.collectionName.addListener(13, (Listener)new CollectionSelectionListener());
    }

    private void createURLPatternEntryControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.url_pattern_enter_label);
        this.newURLPattern = new Text(parent, 2048);
        this.newURLPattern.addListener(24, (Listener)this);
        this.addButton = new Button(parent, 8);
        this.addButton.setText(Messages.add_label);
        this.addButton.setEnabled(false);
        this.addButton.addListener(13, (Listener)this);
        this.uRLList = new org.eclipse.swt.widgets.List(parent, 2818);
        this.uRLList.addListener(13, (Listener)this);
        this.deleteButton = new Button(parent, 8);
        this.deleteButton.setText(Messages.delete_label);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addListener(13, (Listener)this);
        parent.layout();
        Button w = null;
        w = this.deleteButton.getSize().x > this.addButton.getSize().x ? this.deleteButton : this.addButton;
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment((Control)this.headerGroup, 7);
        label.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)label, 0, 0x1000000);
        if (!w.equals(this.addButton)) {
            formData.left = new FormAttachment((Control)this.deleteButton, 0, 16384);
            formData.right = new FormAttachment((Control)this.deleteButton, 0, 131072);
        } else {
            formData.right = new FormAttachment(100, -5);
        }
        this.addButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)label, 5);
        formData.top = new FormAttachment((Control)label, 0, 0x1000000);
        formData.right = new FormAttachment((Control)this.addButton, -5);
        formData.width = 200;
        this.newURLPattern.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)label, 10);
        if (!w.equals(this.deleteButton)) {
            formData.left = new FormAttachment((Control)this.addButton, 0, 16384);
            formData.right = new FormAttachment((Control)this.addButton, 0, 131072);
        } else {
            formData.right = new FormAttachment(100, -5);
        }
        this.deleteButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)label, 5);
        formData.top = new FormAttachment((Control)label, 10);
        formData.right = new FormAttachment((Control)this.deleteButton, -5);
        formData.width = 200;
        formData.bottom = new FormAttachment(100, -5);
        this.uRLList.setLayoutData((Object)formData);
    }

    private void setConstraintName() {
        String constraintNameValue = (String)this.getModel().getPropertyValue("constraint name");
        if (constraintNameValue != null && !constraintNameValue.equals("") && !constraintNameValue.equals(this.constraintName.getText())) {
            this.constraintName.setText(constraintNameValue);
        }
    }

    private void setCollectionName() {
        String collectionNameValue = (String)this.getModel().getPropertyValue("resource collection name");
        if (collectionNameValue != null && !collectionNameValue.equals("")) {
            this.collectionName.setText(collectionNameValue);
        }
    }

    public IURLPatternsWizardDataModel getModel() {
        return (IURLPatternsWizardDataModel)this.context;
    }

    private String[] getCollectionNames() {
        String[] result = null;
        if (this.constraints.containsKey(this.constraintName.getText())) {
            List collections = ApiClass.getResourceCollections(this.constraints.get(this.constraintName.getText()));
            result = new String[collections.size()];
            int i = 0;
            for (Object next : collections) {
                WebResourceCollection collection;
                if (next instanceof WebResourceCollection) {
                    collection = (WebResourceCollection)next;
                    result[i] = collection.getWebResourceName();
                    this.collections.put(result[i], collection);
                    ++i;
                    continue;
                }
                collection = (org.eclipse.jst.javaee.web.WebResourceCollection)next;
                result[i] = collection.getWebResourceName();
                this.collections.put(result[i], collection);
            }
        } else {
            return new String[0];
        }
        return result;
    }

    private void handleConstraintSelection() {
        this.collectionName.setText("");
        this.collectionName.setItems(this.getCollectionNames());
    }

    private void handleCollectionSelection() {
    }

    public void handleWizardEvent(IWizardEvent event) {
        if (event instanceof WizardPropertyChangedEvent) {
            WizardPropertyChangedEvent changeEvent = (WizardPropertyChangedEvent)event;
            if (changeEvent.getPropertyKey().equals("constraint name")) {
                this.setConstraintName();
            } else if (changeEvent.getPropertyKey().equals("resource collection name")) {
                this.setCollectionName();
            }
        }
    }

    public void handleEvent(Event event) {
        Widget ew = event.widget;
        switch (event.type) {
            case 13: {
                if (ew == null) break;
                if (ew == this.newURLPattern) {
                    this.handleNewURLPatternTextEntry();
                    break;
                }
                if (ew == this.addButton) {
                    this.handleAddButtonPressed();
                    break;
                }
                if (ew == this.deleteButton) {
                    this.handleDeleteButtonPressed();
                    break;
                }
                if (ew != this.uRLList) break;
                this.handleURLListSelection();
                break;
            }
            case 24: {
                if (ew == null || ew != this.newURLPattern) break;
                this.handleNewURLPatternTextEntry();
                break;
            }
            case 16: {
                if (ew == null || ew != this.newURLPattern) break;
                this.newURLPattern.getShell().setDefaultButton(this.defaultButton);
            }
        }
    }

    private void handleNewURLPatternTextEntry() {
        String urlPattern = this.newURLPattern.getText();
        if (urlPattern != null && !urlPattern.equals("")) {
            this.addButton.setEnabled(true);
            this.newURLPattern.getShell().setDefaultButton(this.addButton);
        } else {
            this.addButton.setEnabled(false);
            this.newURLPattern.getShell().setDefaultButton(this.defaultButton);
        }
    }

    private void handleURLListSelection() {
        if (this.uRLList.getSelectionCount() > 0) {
            this.deleteButton.setEnabled(true);
        } else {
            this.deleteButton.setEnabled(false);
        }
    }

    private boolean validatePage() {
        String errorMessage = this.validate();
        if (errorMessage != null) {
            this.setMessage(errorMessage, 3);
        }
        return errorMessage == null;
    }

    protected String validate() {
        if (this.urlPatterns.isEmpty()) {
            return Messages.url_patterns_message_one;
        }
        this.setMessage(Messages.url_patterns_entry_instructions);
        return null;
    }

    private void handleDeleteButtonPressed() {
        String[] selections = this.uRLList.getSelection();
        int i = 0;
        while (i < selections.length) {
            String selection = selections[i];
            this.urlPatterns.remove(selection);
            this.getModel().removeURLPattern(selection);
            ++i;
        }
        this.uRLList.setItems(this.urlPatterns.toArray(new String[this.urlPatterns.size()]));
        this.deleteButton.setEnabled(false);
        this.setPageComplete(this.validatePage());
    }

    private void handleAddButtonPressed() {
        String urlPattern = this.newURLPattern.getText();
        if (urlPattern != null && !urlPattern.equals("")) {
            this.urlPatterns.add(urlPattern);
            this.uRLList.setItems(this.urlPatterns.toArray(new String[this.urlPatterns.size()]));
            this.getModel().addURLPattern(urlPattern);
            this.setPageComplete(this.validatePage());
            this.newURLPattern.setText("");
            this.newURLPattern.setFocus();
        }
    }

    public void positionCursor() {
        this.newURLPattern.setFocus();
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(page);
        if (page != null) {
            this.constraintName.setEnabled(false);
            this.collectionName.setEnabled(false);
        }
    }

    private class CollectionSelectionListener
    implements Listener {
        private CollectionSelectionListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 13: {
                    Widget ew = event.widget;
                    if (ew == null) break;
                    URLPatternsForResourceCollectionPage.this.handleCollectionSelection();
                }
            }
        }
    }

    private class ConstraintSelectionListener
    implements Listener {
        private ConstraintSelectionListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 13: {
                    Widget ew = event.widget;
                    if (ew == null) break;
                    URLPatternsForResourceCollectionPage.this.handleConstraintSelection();
                }
            }
        }
    }
}

