/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.wizards.run.as;

import com.ibm.etools.webtools.security.base.internal.common.ops.SecurityCommonOperationsRegistry;
import com.ibm.etools.webtools.security.base.internal.events.AbstractSecurityEvent;
import com.ibm.etools.webtools.security.base.internal.events.ISecurityEventListener;
import com.ibm.etools.webtools.security.base.internal.util.SecurityUtilities;
import com.ibm.etools.webtools.security.web.internal.wizards.run.as.NewRunAsWizardContext;
import com.ibm.etools.webtools.security.wizards.internal.SecurityWizardPage;
import com.ibm.etools.webtools.security.wizards.internal.data.models.IAbstractSecurityWizardsContext;
import com.ibm.etools.webtools.security.wizards.internal.data.models.IWizardEvent;
import com.ibm.etools.webtools.security.wizards.internal.nls.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewRunAsPage
extends SecurityWizardPage
implements ISecurityEventListener {
    private Button newRole;
    private Combo runAsRole;
    private Text description;

    public NewRunAsPage(String pageName, String title, ImageDescriptor titleImage, IAbstractSecurityWizardsContext context) {
        super(pageName, title, titleImage, context);
    }

    public void positionCursor() {
    }

    public void handleWizardEvent(IWizardEvent event) {
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        composite.setLayout((Layout)fillLayout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.webtools.security.web.wtsec0100");
        this.createEntryArea(composite);
        this.initRoleData();
        this.setControl((Control)composite);
        this.setMessage(Messages.run_as_entry_instructions);
        this.setPageComplete(false);
    }

    private void initRoleData() {
        this.initRoleSelections();
    }

    private void initRoleSelections() {
        ArrayList<String> roleNames = new ArrayList<String>();
        List roles = this.context.getOp().getSecurityRoles(((NewRunAsWizardContext)this.context).getCommonOpContext());
        for (Object securityRole : roles) {
            if (securityRole instanceof SecurityRole) {
                roleNames.add(((SecurityRole)securityRole).getRoleName());
                continue;
            }
            if (!(securityRole instanceof org.eclipse.jst.javaee.core.SecurityRole)) continue;
            roleNames.add(((org.eclipse.jst.javaee.core.SecurityRole)securityRole).getRoleName());
        }
        if (!roleNames.isEmpty()) {
            Collections.sort(roleNames);
            this.runAsRole.setItems(roleNames.toArray(new String[roleNames.size()]));
        }
    }

    public void handleSecurityEvent(AbstractSecurityEvent event) {
        this.initRoleSelections();
    }

    private boolean validatePage() {
        String errorMessage = this.validate();
        if (errorMessage != null) {
            this.setMessage(errorMessage, 3);
        }
        return errorMessage == null;
    }

    protected String validate() {
        if (this.runAsRole.getText() == null || this.runAsRole.getText().equals("")) {
            return Messages.run_as_message_one;
        }
        this.setMessage(Messages.run_as_entry_instructions);
        return null;
    }

    private void createEntryArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        Label runAsLabel = new Label(composite, 0);
        runAsLabel.setText(String.valueOf(Messages.security_role_label) + ":");
        this.runAsRole = new Combo(composite, 8);
        this.runAsRole.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewRunAsPage.this.setPageComplete(NewRunAsPage.this.validatePage());
                NewRunAsPage.this.getNewRunAsWizardContext().setIdentityRole(NewRunAsPage.this.context.getOp().getSecurityRoleNamed(NewRunAsPage.this.getNewRunAsWizardContext().getCommonOpContext(), NewRunAsPage.this.runAsRole.getText()));
                NewRunAsPage.this.description.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.newRole = new Button(composite, 8);
        this.newRole.setText(Messages.new_role);
        this.newRole.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SecurityCommonOperationsRegistry.getCommonOperationsForProject((IProject)NewRunAsPage.this.context.getProject()).newSecurityRole(NewRunAsPage.this.getNewRunAsWizardContext().getCommonOpContext());
                NewRunAsPage.this.initRoleData();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText(String.valueOf(Messages.description) + ":");
        this.description = new Text(composite, 2626);
        this.description.setEnabled(false);
        this.description.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewRunAsPage.this.getNewRunAsWizardContext().setDescription(NewRunAsPage.this.description.getText());
            }
        });
        composite.layout();
        Control widest = SecurityUtilities.findWidest((Control[])new Control[]{runAsLabel, descriptionLabel});
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 5);
        if (widest == descriptionLabel) {
            formData.right = new FormAttachment((Control)descriptionLabel, 0, 131072);
        }
        runAsLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment((Control)this.runAsRole, 5);
        if (widest == runAsLabel) {
            formData.right = new FormAttachment((Control)runAsLabel, 0, 131072);
        }
        descriptionLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)runAsLabel, 5);
        formData.top = new FormAttachment(0, 5);
        formData.right = new FormAttachment((Control)this.newRole, -5);
        this.runAsRole.setLayoutData((Object)formData);
        formData = new FormData();
        formData.right = new FormAttachment(100, -5);
        formData.top = new FormAttachment(0, 5);
        this.newRole.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)descriptionLabel, 5);
        formData.top = new FormAttachment((Control)this.runAsRole, 5);
        formData.right = new FormAttachment(100, -5);
        formData.height = 60;
        this.description.setLayoutData((Object)formData);
        this.runAsRole.setFocus();
    }

    private NewRunAsWizardContext getNewRunAsWizardContext() {
        return (NewRunAsWizardContext)this.context;
    }
}

