/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.wizards.roleAssoc;

import com.ibm.etools.webtools.security.base.internal.Images;
import com.ibm.etools.webtools.security.web.internal.api.ApiClass;
import com.ibm.etools.webtools.security.web.internal.nls.Messages;
import com.ibm.etools.webtools.security.web.internal.wizards.roleAssoc.IRoleAssocDataModel;
import com.ibm.etools.webtools.security.wizards.internal.SecurityWizardPage;
import com.ibm.etools.webtools.security.wizards.internal.data.models.IAbstractSecurityWizardsContext;
import com.ibm.etools.webtools.security.wizards.internal.data.models.IWizardEvent;
import com.ibm.etools.webtools.security.wizards.internal.data.models.WizardPropertyChangedEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class RoleAssocPage
extends SecurityWizardPage {
    private CheckboxTableViewer rolesViewer = null;
    CCombo constraintName = null;

    public RoleAssocPage(String pageName, IRoleAssocDataModel model) {
        super(pageName, (IAbstractSecurityWizardsContext)model);
    }

    public RoleAssocPage(String pageName, String title, ImageDescriptor titleImage, IRoleAssocDataModel model) {
        super(pageName, title, titleImage, (IAbstractSecurityWizardsContext)model);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.webtools.security.web.wtsec0060");
        this.createConstraintNameControl(composite);
        this.createRoleViewerControl(composite);
        this.setControl((Control)composite);
        this.setPageComplete(true);
        this.setMessage(Messages.role_association_message);
    }

    private void createConstraintNameControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.constraint_name);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment(0, 5);
        label.setLayoutData((Object)formData);
        this.constraintName = new CCombo(parent, 2048);
        formData = new FormData();
        formData.left = new FormAttachment((Control)label, 5);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)label, 0, 0x1000000);
        formData.width = 250;
        this.constraintName.setLayoutData((Object)formData);
        this.setConstraintName();
        this.constraintName.setEnabled(false);
        this.constraintName.addSelectionListener(new org.eclipse.swt.events.SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RoleAssocPage.this.handleNewConstraintSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void handleNewConstraintSelected() {
        this.initSelections();
    }

    private void setConstraintName() {
        String constraintNameValue = (String)this.getModel().getPropertyValue("constraint name");
        if (constraintNameValue != null && !constraintNameValue.equals("") && !constraintNameValue.equals(this.constraintName.getText())) {
            this.constraintName.setText(constraintNameValue);
        }
    }

    private void createRoleViewerControl(Composite parent) {
        this.rolesViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2818);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)this.constraintName, 5);
        formData.bottom = new FormAttachment(100, 0);
        this.rolesViewer.getControl().setLayoutData((Object)formData);
        this.rolesViewer.setLabelProvider((IBaseLabelProvider)new RoleLabelProvider());
        this.rolesViewer.setContentProvider((IContentProvider)new RoleContentProvider());
        this.rolesViewer.setInput(this.getModel().getRoleNames());
        this.initSelections();
        this.rolesViewer.addSelectionChangedListener((ISelectionChangedListener)new SelectionListener());
    }

    private void initSelections() {
        Object constraint = ApiClass.getConstraintNamed(this.constraintName.getText(), this.getModel().getModelProvider());
        if (constraint != null) {
            List roleNames = ApiClass.getRolesFor(constraint);
            List viewerInput = (List)this.rolesViewer.getInput();
            for (String element : viewerInput) {
                if (roleNames.contains(element)) {
                    this.rolesViewer.setChecked((Object)element, true);
                    continue;
                }
                this.rolesViewer.setChecked((Object)element, false);
            }
        }
    }

    private void handleRoleSelectionChange() {
        TableItem[] children = this.rolesViewer.getTable().getItems();
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            this.getModel().setRoleSelection(item.getText(), item.getChecked());
            ++i;
        }
    }

    public IRoleAssocDataModel getModel() {
        return (IRoleAssocDataModel)this.context;
    }

    public void handleWizardEvent(IWizardEvent event) {
        WizardPropertyChangedEvent changeEvent;
        if (event instanceof WizardPropertyChangedEvent && (changeEvent = (WizardPropertyChangedEvent)event).getPropertyKey().equals("constraint name")) {
            this.setConstraintName();
        }
    }

    public void positionCursor() {
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(page);
        if (page != null) {
            this.constraintName.setEnabled(false);
        }
    }

    private class RoleContentProvider
    implements IStructuredContentProvider {
        private RoleContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((ArrayList)inputElement).toArray(new Object[((ArrayList)inputElement).size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class RoleLabelProvider
    implements ITableLabelProvider {
        private RoleLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return Images.getSecurityRole();
        }

        public String getColumnText(Object element, int columnIndex) {
            return (String)element;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class SelectionListener
    implements ISelectionChangedListener {
        private SelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            RoleAssocPage.this.handleRoleSelectionChange();
        }
    }
}

