/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.run.as;

import com.ibm.etools.webtools.security.base.internal.actions.AbstractViewerMenuAction;
import com.ibm.etools.webtools.security.base.internal.common.ops.ICommonOperationsContext;
import com.ibm.etools.webtools.security.base.internal.common.ops.SecurityCommonOperationsRegistry;
import com.ibm.etools.webtools.security.base.internal.resource.providers.ResourceNode;
import com.ibm.etools.webtools.security.base.internal.resource.providers.SecurityResourceWrapper;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebServletGroupWrapper;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebServletWrapper;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.swt.widgets.Widget;

public class NewRunAsAction
extends AbstractViewerMenuAction {
    public NewRunAsAction(StructuredViewer viewer, Widget trigger, ICommonOperationsContext context) {
        super(viewer, trigger, context);
        this.disable();
    }

    public void checkEnablement(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            ResourceNode node;
            SecurityResourceWrapper wrapper;
            StructuredSelection ss = (StructuredSelection)selection;
            this.enabled = false;
            if (ss.size() == 1 && (wrapper = (node = (ResourceNode)ss.getFirstElement()).getResourceWrapper()) instanceof WebServletWrapper && !(wrapper instanceof WebServletGroupWrapper)) {
                Object servlet = wrapper.getResource();
                if (servlet instanceof Servlet) {
                    if (((Servlet)servlet).getRunAs() == null) {
                        this.enabled = true;
                    }
                } else if (((org.eclipse.jst.javaee.web.Servlet)servlet).getRunAs() == null) {
                    this.enabled = true;
                }
            }
            if (this.enabled) {
                this.enable();
            } else {
                this.disable();
            }
        }
    }

    public void run() {
        if (this.enabled) {
            if (!this.context.validateState()) {
                return;
            }
            ResourceNode selectedNode = (ResourceNode)((StructuredSelection)this.viewer.getSelection()).getFirstElement();
            Servlet servlet = this.getServlet(selectedNode);
            if (servlet != null) {
                SecurityCommonOperationsRegistry.getCommonOperationsForProject((IProject)this.context.getProject()).newRunAs(this.context, (Object)servlet);
            }
        }
        this.viewer.setSelection(this.viewer.getSelection());
    }

    private Servlet getServlet(ResourceNode selectedNode) {
        Servlet result = null;
        result = selectedNode.getResourceWrapper() instanceof WebServletWrapper ? (Servlet)selectedNode.getResourceWrapper().getResource() : this.getServlet((ResourceNode)selectedNode.getParent());
        return result;
    }
}

