/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.resource.provider;

import com.ibm.etools.webtools.security.base.internal.events.AbstractSecurityEvent;
import com.ibm.etools.webtools.security.base.internal.events.ISecurityEventListener;
import com.ibm.etools.webtools.security.base.internal.events.SecurityResourceAddedEvent;
import com.ibm.etools.webtools.security.base.internal.events.SecurityResourceRemovedEvent;
import com.ibm.etools.webtools.security.base.internal.resource.providers.ResourceContainerNode;
import com.ibm.etools.webtools.security.base.internal.resource.providers.ResourceNode;
import com.ibm.etools.webtools.security.base.internal.resource.providers.ResourceRootNode;
import com.ibm.etools.webtools.security.base.internal.util.SecurityUtilities;
import com.ibm.etools.webtools.security.web.internal.util.SecurityWebUtilities;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class WorkbenchResourceChangeManager
implements IResourceChangeListener {
    private boolean handlingResourceChanged;
    private IProject project;
    private IVirtualComponent component;
    private List listeners = new ArrayList();
    private ResourceRootNode rootTreeNode;
    private List eventsToFire = new ArrayList();
    protected IResourceDeltaVisitor deltaVisitor = new IResourceDeltaVisitor(){

        public boolean visit(IResourceDelta delta) {
            switch (delta.getKind()) {
                case 1: {
                    this.handleAdd(delta);
                    break;
                }
                case 2: {
                    this.handleRemove(delta);
                    break;
                }
            }
            return delta.getResource().getType() != 1;
        }

        private void handleAdd(IResourceDelta delta) {
            IVirtualResource[] resources;
            IResource resource = delta.getResource();
            if ((resource instanceof IFile || resource instanceof IFolder) && (resources = ComponentCore.createResources((IResource)delta.getResource())).length > 0) {
                ResourceContainerNode containerNode;
                String runtimeRootPath;
                String vResourcePath;
                IVirtualResource vResource = resources[0];
                if (WorkbenchResourceChangeManager.this.component.equals(vResource.getComponent()) && (vResourcePath = vResource.getUnderlyingResource().getFullPath().toString()).startsWith(runtimeRootPath = WorkbenchResourceChangeManager.this.component.getRootFolder().getUnderlyingFolder().getFullPath().toString()) && (containerNode = WorkbenchResourceChangeManager.this.getContainerNode(resource, runtimeRootPath)) != null) {
                    containerNode.updateChildren();
                    WorkbenchResourceChangeManager.this.eventsToFire.add(new SecurityResourceAddedEvent((Object)vResource.getUnderlyingResource(), (ResourceNode)containerNode));
                }
            }
        }

        private void handleRemove(IResourceDelta delta) {
            IVirtualResource[] resources;
            IResource resource = delta.getResource();
            if ((resource instanceof IFile || resource instanceof IFolder) && (resources = ComponentCore.createResources((IResource)delta.getResource())).length > 0) {
                ResourceContainerNode containerNode;
                String runtimeRootPath;
                String vResourcePath;
                IVirtualResource vResource = resources[0];
                if (WorkbenchResourceChangeManager.this.component.equals(vResource.getComponent()) && (vResourcePath = vResource.getUnderlyingResource().getFullPath().toString()).startsWith(runtimeRootPath = WorkbenchResourceChangeManager.this.component.getRootFolder().getUnderlyingFolder().getFullPath().toString()) && (containerNode = WorkbenchResourceChangeManager.this.getContainerNode(resource, runtimeRootPath)) != null) {
                    containerNode.updateChildren();
                    WorkbenchResourceChangeManager.this.eventsToFire.add(new SecurityResourceRemovedEvent((Object)vResource.getUnderlyingResource(), (ResourceNode)containerNode));
                }
            }
        }
    };

    public WorkbenchResourceChangeManager(IProject project, ResourceRootNode rootTreeNode) {
        this.project = project;
        this.component = ComponentCore.createComponent((IProject)project);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 8);
        this.rootTreeNode = rootTreeNode;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.project = null;
        this.component = null;
        this.rootTreeNode = null;
    }

    public void registerListener(ISecurityEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(ISecurityEventListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    protected void fire(AbstractSecurityEvent event) {
        for (ISecurityEventListener listener : this.listeners) {
            listener.handleSecurityEvent(event);
        }
    }

    /*
     * Exception decompiling
     */
    public void resourceChanged(IResourceChangeEvent event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void asyncIt(AbstractSecurityEvent event) {
        final AbstractSecurityEvent securityEvent = event;
        SecurityUtilities.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                WorkbenchResourceChangeManager.this.fire(securityEvent);
            }
        });
    }

    protected ResourceContainerNode getContainerNode(IResource resource, String rootPath) {
        ResourceContainerNode result = null;
        String resourcePath = resource.getFullPath().toString();
        resourcePath = resourcePath.substring(rootPath.length());
        String parentPath = resourcePath.substring(0, resourcePath.lastIndexOf("/"));
        List resources = SecurityWebUtilities.getResourcesFor(this.project, (ResourceNode)this.rootTreeNode.getChildren().get(0), parentPath);
        if (resources.size() == 1 && resources.get(0) instanceof ResourceContainerNode) {
            result = (ResourceContainerNode)resources.get(0);
        }
        return result;
    }
}

