/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.resource.provider;

import com.ibm.etools.webtools.security.base.internal.events.AbstractSecurityEvent;
import com.ibm.etools.webtools.security.base.internal.events.SecurityResourceAddedEvent;
import com.ibm.etools.webtools.security.base.internal.events.SecurityRoleRefAddedEvent;
import com.ibm.etools.webtools.security.base.internal.events.SecurityRoleRefRemovedEvent;
import com.ibm.etools.webtools.security.base.internal.events.SecurityRunAsAddedEvent;
import com.ibm.etools.webtools.security.base.internal.events.SecurityRunAsRemovedEvent;
import com.ibm.etools.webtools.security.base.internal.resource.providers.GenericNode;
import com.ibm.etools.webtools.security.base.internal.resource.providers.ResourceNode;
import com.ibm.etools.webtools.security.base.internal.resource.providers.SecurityResourceWrapper;
import com.ibm.etools.webtools.security.web.internal.events.ServletMappingAddedEvent;
import com.ibm.etools.webtools.security.web.internal.events.ServletMappingRemovedEvent;
import com.ibm.etools.webtools.security.web.internal.resource.provider.ServletMappingGroupNode;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebModuleResourceNode;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebRoleRefGroupNode;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.swt.graphics.Image;

public class WebServletNode
extends WebModuleResourceNode {
    public WebServletNode(Image image, String label, SecurityResourceWrapper resourceWrapper, IProject project) {
        super(image, label, resourceWrapper, project);
    }

    public void handleSecurityEvent(AbstractSecurityEvent event) {
        if (event instanceof SecurityRunAsAddedEvent) {
            this.updateChildren();
            super.handleSecurityEvent((AbstractSecurityEvent)new SecurityResourceAddedEvent(event.getSource(), (ResourceNode)this));
            return;
        }
        if (event instanceof SecurityRunAsRemovedEvent) {
            this.updateChildren();
            super.handleSecurityEvent((AbstractSecurityEvent)new SecurityResourceAddedEvent(event.getSource(), (ResourceNode)this));
            return;
        }
        if (event instanceof SecurityRoleRefAddedEvent) {
            boolean found = false;
            for (GenericNode childNode : this.getChildren()) {
                if (!(childNode instanceof WebRoleRefGroupNode)) continue;
                found = true;
            }
            if (!found) {
                this.updateChildren();
                super.handleSecurityEvent((AbstractSecurityEvent)new SecurityResourceAddedEvent(event.getSource(), (ResourceNode)this));
            }
            return;
        }
        if (event instanceof SecurityRoleRefRemovedEvent) {
            Object servlet = this.getResourceWrapper().getResource();
            Object securityRoleRefs = null;
            securityRoleRefs = servlet instanceof Servlet ? ((Servlet)servlet).getSecurityRoleRefs() : ((org.eclipse.jst.javaee.web.Servlet)servlet).getSecurityRoleRefs();
            if (securityRoleRefs.isEmpty()) {
                this.updateChildren();
                super.handleSecurityEvent((AbstractSecurityEvent)new SecurityResourceAddedEvent((Object)this, (ResourceNode)this.getParent()));
            }
            return;
        }
        if (event instanceof ServletMappingAddedEvent || event instanceof ServletMappingRemovedEvent) {
            boolean bale = false;
            if (event instanceof ServletMappingAddedEvent) {
                List children = this.getChildren();
                Iterator iter = children.iterator();
                while (iter.hasNext() && !bale) {
                    Object child = iter.next();
                    if (!(child instanceof ServletMappingGroupNode)) continue;
                    bale = true;
                }
            }
            if (!bale) {
                this.updateChildren();
                super.handleSecurityEvent((AbstractSecurityEvent)new SecurityResourceAddedEvent(event.getSource(), (ResourceNode)this));
            }
            return;
        }
        super.handleSecurityEvent(event);
    }
}

