/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.resource.provider;

import com.ibm.etools.webtools.security.base.internal.SecurityConstants;
import com.ibm.etools.webtools.security.base.internal.resource.providers.ISecurityResourceWrapper;
import com.ibm.etools.webtools.security.base.internal.resource.providers.ResourceContainerNode;
import com.ibm.etools.webtools.security.base.internal.resource.providers.ResourceNode;
import com.ibm.etools.webtools.security.base.internal.resource.providers.SecurityResourceProvider;
import com.ibm.etools.webtools.security.base.internal.resource.providers.SecurityResourceWrapper;
import com.ibm.etools.webtools.security.web.internal.Images;
import com.ibm.etools.webtools.security.web.internal.nls.Messages;
import com.ibm.etools.webtools.security.web.internal.resource.provider.ServletMappingGroupNode;
import com.ibm.etools.webtools.security.web.internal.resource.provider.ServletMappingGroupWrapper;
import com.ibm.etools.webtools.security.web.internal.resource.provider.ServletMappingNode;
import com.ibm.etools.webtools.security.web.internal.resource.provider.ServletMappingWrapper;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebModuleFolderWrapper;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebModuleResourceNode;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebModuleResourceWrapper;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebModuleRoleRefNode;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebRoleRefGroupNode;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebRoleRefGroupWrapper;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebRoleRefWrapper;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebRunAsWrapper;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebServletGroupNode;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebServletGroupWrapper;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebServletNode;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebServletWrapper;
import com.ibm.etools.webtools.security.web.internal.util.SecurityWebUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.j2ee.common.RunAsSpecifiedIdentity;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.javaee.core.RunAs;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class WebResourceProvider
extends SecurityResourceProvider {
    private static final String web_inf = "WEB-INF";
    private static final String meta_inf = "META-INF";
    private List folderExcludeList = null;

    private List getFolderExcludeList() {
        if (this.folderExcludeList == null) {
            this.folderExcludeList = new ArrayList();
            this.folderExcludeList.add(meta_inf);
            this.folderExcludeList.add(web_inf);
        }
        return this.folderExcludeList;
    }

    public List getAllChildResourcesFor(SecurityResourceWrapper resourceWrapper) {
        if (!(resourceWrapper instanceof WebModuleResourceWrapper)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        WebModuleResourceWrapper parent = (WebModuleResourceWrapper)resourceWrapper;
        ISecurityResourceWrapper seed = this.findSeed((ISecurityResourceWrapper)parent);
        IModelProvider webEdit = ((WebModuleResourceWrapper)seed).getWebEdit();
        IVirtualComponent virtualComponent = ComponentCore.createComponent((IProject)JavaEEProjectUtilities.getProject((Object)webEdit.getModelObject()));
        IVirtualFolder virtualFolder = virtualComponent.getRootFolder();
        String rootPath = virtualFolder.getUnderlyingFolder().getFullPath().toString();
        if (resourceWrapper instanceof WebServletGroupWrapper) {
            this.getServlets(resourceWrapper, result, webEdit);
        } else if (resourceWrapper instanceof WebServletWrapper) {
            this.getServletChildren(resourceWrapper, result, webEdit);
        } else if (resourceWrapper instanceof WebRoleRefGroupWrapper) {
            this.getRoleRefGroupChildren(resourceWrapper, result, webEdit);
        } else {
            if (resourceWrapper instanceof ServletMappingGroupWrapper) {
                this.getServletMappings(resourceWrapper, result, webEdit);
            }
            this.getIResourceChildren(resourceWrapper, result, webEdit, seed, rootPath);
        }
        return result;
    }

    private void getServletMappings(SecurityResourceWrapper resourceWrapper, List result, IModelProvider webEdit) {
        block5: {
            Object servlet;
            block4: {
                servlet = resourceWrapper.getParent().getResource();
                if (!(servlet instanceof Servlet)) break block4;
                if (((Servlet)servlet).getMappings().isEmpty()) break block5;
                for (org.eclipse.jst.j2ee.webapplication.ServletMapping mapping : ((Servlet)servlet).getMappings()) {
                    ServletMappingWrapper wrapper = new ServletMappingWrapper(mapping, mapping.getUrlPattern(), webEdit);
                    wrapper.setLabel(mapping.getUrlPattern());
                    wrapper.setImage(Images.getServletMappingImage());
                    wrapper.setParent((ISecurityResourceWrapper)resourceWrapper);
                    result.add(wrapper);
                }
                break block5;
            }
            WebApp webApp = (WebApp)webEdit.getModelObject();
            if (!webApp.getServletMappings().isEmpty()) {
                for (ServletMapping mapping : webApp.getServletMappings()) {
                    List urlPatterns;
                    if (!mapping.getServletName().equals(((org.eclipse.jst.javaee.web.Servlet)servlet).getServletName()) || (urlPatterns = mapping.getUrlPatterns()) == null) continue;
                    for (UrlPatternType urlPattern : urlPatterns) {
                        ServletMappingWrapper wrapper = new ServletMappingWrapper(mapping, urlPattern.getValue(), webEdit);
                        wrapper.setLabel(urlPattern.getValue());
                        wrapper.setImage(Images.getServletMappingImage());
                        wrapper.setParent((ISecurityResourceWrapper)resourceWrapper);
                        result.add(wrapper);
                    }
                }
            }
        }
    }

    private void getRoleRefGroupChildren(SecurityResourceWrapper resourceWrapper, List result, IModelProvider webEdit) {
        for (Object roleRef : (List)resourceWrapper.getResource()) {
            WebRoleRefWrapper roleRefWrapper = new WebRoleRefWrapper(roleRef, null, webEdit);
            String roleName = null;
            String roleLink = null;
            if (roleRef instanceof SecurityRoleRef) {
                roleName = ((SecurityRoleRef)roleRef).getName();
                roleLink = ((SecurityRoleRef)roleRef).getLink();
            } else {
                roleName = ((org.eclipse.jst.javaee.core.SecurityRoleRef)roleRef).getRoleName();
                roleLink = ((org.eclipse.jst.javaee.core.SecurityRoleRef)roleRef).getRoleLink();
            }
            roleRefWrapper.setLabel(String.valueOf(roleName) + "  ===>  " + roleLink);
            roleRefWrapper.setImage(com.ibm.etools.webtools.security.base.internal.Images.getSecurityRoleReferenceImage());
            roleRefWrapper.setParent((ISecurityResourceWrapper)resourceWrapper);
            result.add(roleRefWrapper);
        }
    }

    private void getServletChildren(SecurityResourceWrapper resourceWrapper, List result, IModelProvider webEdit) {
        WebModuleResourceWrapper newWrapper;
        Object servlet = resourceWrapper.getResource();
        RunAsSpecifiedIdentity runas = null;
        String runasRoleName = null;
        Object roleRefs = null;
        List<ServletMapping> mappings = new ArrayList();
        if (servlet instanceof Servlet) {
            runas = ((Servlet)servlet).getRunAs();
            if (runas != null) {
                runasRoleName = runas.getIdentity().getRoleName();
            }
            roleRefs = ((Servlet)servlet).getSecurityRoleRefs();
            mappings = ((Servlet)servlet).getMappings();
        } else {
            runas = ((org.eclipse.jst.javaee.web.Servlet)servlet).getRunAs();
            if (runas != null) {
                runasRoleName = ((RunAs)runas).getRoleName();
            }
            roleRefs = ((org.eclipse.jst.javaee.web.Servlet)servlet).getSecurityRoleRefs();
            WebApp webApp = (WebApp)webEdit.getModelObject();
            List allMappings = webApp.getServletMappings();
            for (ServletMapping mapping : allMappings) {
                if (!mapping.getServletName().equals(((org.eclipse.jst.javaee.web.Servlet)servlet).getServletName())) continue;
                mappings.add(mapping);
            }
        }
        if (runas != null) {
            newWrapper = new WebRunAsWrapper(runas, null, webEdit);
            newWrapper.setLabel(String.valueOf(SecurityConstants.Run_As_Label) + " " + runasRoleName);
            newWrapper.setImage(com.ibm.etools.webtools.security.base.internal.Images.getSecurityIdentityImage());
            newWrapper.setParent((ISecurityResourceWrapper)resourceWrapper);
            result.add(newWrapper);
        }
        if (!roleRefs.isEmpty()) {
            newWrapper = new WebRoleRefGroupWrapper(roleRefs, null, webEdit);
            newWrapper.setLabel(SecurityConstants.Role_Reference);
            newWrapper.setImage(com.ibm.etools.webtools.security.base.internal.Images.getSecurityRoleReferenceImage());
            newWrapper.setParent((ISecurityResourceWrapper)resourceWrapper);
            result.add(newWrapper);
        }
        if (!mappings.isEmpty()) {
            newWrapper = new ServletMappingGroupWrapper(mappings, null, webEdit);
            newWrapper.setLabel(Messages.servlet_mappings);
            newWrapper.setImage(Images.getServletMappingImage());
            newWrapper.setParent((ISecurityResourceWrapper)resourceWrapper);
            result.add(newWrapper);
        }
    }

    private void getIResourceChildren(final SecurityResourceWrapper resourceWrapper, final List result, final IModelProvider webEdit, ISecurityResourceWrapper seed, final String rootPath) {
        if (seed.equals(resourceWrapper)) {
            this.addServletContainer(resourceWrapper, result, webEdit);
        }
        if (!(resourceWrapper instanceof WebModuleFolderWrapper) || resourceWrapper != seed && !(resourceWrapper instanceof WebModuleFolderWrapper)) {
            return;
        }
        final IResource currentResource = (IResource)resourceWrapper.getResource();
        try {
            currentResource.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource != currentResource) {
                        if (resource.getType() == 1) {
                            String url = resource.getFullPath().toString().substring(rootPath.length());
                            WebModuleResourceWrapper securityResource = new WebModuleResourceWrapper(resource, url, webEdit);
                            securityResource.setLabel(resource.getName());
                            securityResource.setImage(com.ibm.etools.webtools.security.base.internal.Images.getWebModuleResourceImage());
                            securityResource.setParent((ISecurityResourceWrapper)resourceWrapper);
                            result.add(securityResource);
                        } else if (resource.getType() == 2 && !WebResourceProvider.this.getFolderExcludeList().contains(resource.getName())) {
                            String url = resource.getFullPath().toString().substring(rootPath.length());
                            WebModuleFolderWrapper securityResource = new WebModuleFolderWrapper(resource, url, webEdit);
                            securityResource.setLabel(resource.getName());
                            securityResource.setImage(com.ibm.etools.webtools.security.base.internal.Images.getFolderImage());
                            securityResource.setParent((ISecurityResourceWrapper)resourceWrapper);
                            result.add(securityResource);
                        }
                    }
                    return true;
                }
            }, 1, false);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void addServletContainer(SecurityResourceWrapper resourceWrapper, List<SecurityResourceWrapper> result, IModelProvider webEdit) {
        Object modelObject = webEdit.getModelObject();
        WebServletGroupWrapper wrapper = null;
        if (modelObject instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject;
            wrapper = new WebServletGroupWrapper(webApp.getServlets(), null, webEdit);
        } else {
            WebApp webApp = (WebApp)modelObject;
            wrapper = new WebServletGroupWrapper(webApp.getServlets(), null, webEdit);
        }
        wrapper.setLabel(Messages.registered_servlets);
        wrapper.setImage(Images.getServletImage());
        wrapper.setParent((ISecurityResourceWrapper)resourceWrapper);
        result.add(wrapper);
    }

    private void getServlets(SecurityResourceWrapper resourceWrapper, List result, IModelProvider webEdit) {
        org.eclipse.jst.j2ee.webapplication.WebApp webApp;
        Object modelObject = webEdit.getModelObject();
        Object servlets = null;
        if (modelObject instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject;
            servlets = webApp.getServlets();
        } else {
            webApp = (WebApp)modelObject;
            servlets = webApp.getServlets();
        }
        Iterator iter = servlets.iterator();
        while (iter.hasNext()) {
            WebServletWrapper wrapper;
            Object servlet = iter.next();
            if (servlet instanceof Servlet) {
                wrapper = new WebServletWrapper(servlet, null, webEdit);
                wrapper.setLabel(((Servlet)servlet).getServletName());
                wrapper.setImage(Images.getServletImage());
                wrapper.setParent((ISecurityResourceWrapper)resourceWrapper);
                result.add(wrapper);
                continue;
            }
            wrapper = new WebServletWrapper(servlet, null, webEdit);
            wrapper.setLabel(((org.eclipse.jst.javaee.web.Servlet)servlet).getServletName());
            wrapper.setImage(Images.getServletImage());
            wrapper.setParent((ISecurityResourceWrapper)resourceWrapper);
            result.add(wrapper);
        }
    }

    public boolean patternMatch(Object pattern, SecurityResourceWrapper target) {
        return SecurityWebUtilities.patternMatch(pattern, target);
    }

    public ResourceNode generateNodeForWrapper(SecurityResourceWrapper wrapper, IProject project) {
        Object result = null;
        result = wrapper instanceof WebModuleFolderWrapper ? new ResourceContainerNode(wrapper.getImage(), wrapper.getLabel(), wrapper, project) : (wrapper instanceof WebRoleRefGroupWrapper ? new WebRoleRefGroupNode(wrapper.getImage(), wrapper.getLabel(), wrapper, project) : (wrapper instanceof WebServletGroupWrapper ? new WebServletGroupNode(wrapper.getImage(), wrapper.getLabel(), wrapper, project) : (wrapper instanceof WebServletWrapper ? new WebServletNode(wrapper.getImage(), wrapper.getLabel(), wrapper, project) : (wrapper instanceof WebRoleRefWrapper ? new WebModuleRoleRefNode(wrapper.getImage(), wrapper.getLabel(), wrapper, project) : (wrapper instanceof ServletMappingGroupWrapper ? new ServletMappingGroupNode(wrapper.getImage(), wrapper.getLabel(), wrapper, project) : (wrapper instanceof ServletMappingWrapper ? new ServletMappingNode(wrapper.getImage(), wrapper.getLabel(), wrapper, project) : new WebModuleResourceNode(wrapper.getImage(), wrapper.getLabel(), wrapper, project)))))));
        return result;
    }
}

