/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.resource.provider;

import com.ibm.etools.webtools.security.base.SecurityBasePlugin;
import com.ibm.etools.webtools.security.base.internal.events.AbstractSecurityEvent;
import com.ibm.etools.webtools.security.base.internal.events.ISecurityEventListener;
import com.ibm.etools.webtools.security.base.internal.events.SecurityRoleAssociationAddedEvent;
import com.ibm.etools.webtools.security.base.internal.events.SecurityRoleAssociationRemovedEvent;
import com.ibm.etools.webtools.security.base.internal.resource.providers.SecurityResourceWrapper;
import com.ibm.etools.webtools.security.base.internal.util.SecurityUtilities;
import com.ibm.etools.webtools.security.web.internal.api.ApiClass;
import com.ibm.etools.webtools.security.web.internal.events.ResourceCollectionAddedEvent;
import com.ibm.etools.webtools.security.web.internal.events.SecurityConstraintAddedEvent;
import com.ibm.etools.webtools.security.web.internal.events.URLPatternAddedEvent;
import com.ibm.etools.webtools.security.web.internal.resource.provider.IFacesURLPatternGenerator;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebModelListener;
import com.ibm.etools.webtools.security.web.internal.util.SecurityWebUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.webapplication.AuthConstraint;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;
import org.eclipse.jst.j2ee.webapplication.internal.impl.AuthConstraintImpl;
import org.eclipse.jst.j2ee.webapplication.internal.impl.SecurityConstraintImpl;
import org.eclipse.jst.j2ee.webapplication.internal.impl.WebResourceCollectionImpl;

public class WebModuleResourceWrapper
extends SecurityResourceWrapper {
    private IModelProvider webEdit;
    private HashMap roleToConstraintsMap = new HashMap();
    private HashMap constraintsToCollectionsMap = new HashMap();
    private HashMap collectionsToPatternsMap = new HashMap();
    private HashMap adapterMap = new HashMap();
    private List editedURLPatterns = null;

    public WebModuleResourceWrapper(Object resource, String addressableURL, IModelProvider webEdit) {
        super(resource, addressableURL);
        this.webEdit = webEdit;
        WebModelListener.getModelListenerForModel(this.webEdit).registerListener((ISecurityEventListener)this);
    }

    public void dispose() {
        WebModelListener.getModelListenerForModel(this.webEdit).removeListener((ISecurityEventListener)this);
        for (Map.Entry mapEntry : this.adapterMap.entrySet()) {
            EObject eObject = (EObject)mapEntry.getKey();
            Adapter adapter = (Adapter)mapEntry.getValue();
            eObject.eAdapters().remove((Object)adapter);
        }
        this.adapterMap = null;
        this.constraintsToCollectionsMap = null;
        this.collectionsToPatternsMap = null;
        this.roleToConstraintsMap = null;
        super.dispose();
    }

    public int category() {
        return 2;
    }

    private void unregisterAdapter(EObject eObject) {
        Adapter adapter = (Adapter)this.adapterMap.get(eObject);
        eObject.eAdapters().remove((Object)adapter);
        this.adapterMap.remove(eObject);
    }

    protected void regsiterAdapter(EObject eObject, Adapter adapter) {
        this.adapterMap.put(eObject, adapter);
    }

    public void generateURLPatterns() {
        this.generateURLsForFaces();
        this.urlPatterns.add(this.addressableURL);
    }

    protected void generateURLsForFaces() {
        IFacesURLPatternGenerator facesURLPatternGenerator;
        boolean faces = SecurityBasePlugin.getDefault().getPreferenceStore().getBoolean("faces to wildcards");
        IProject project = this.getProject();
        if (faces && SecurityWebUtilities.isFacesProject(project) && (facesURLPatternGenerator = SecurityWebUtilities.getFacesURLPatternGenerator()) != null) {
            this.urlPatterns = facesURLPatternGenerator.generateFacesURLPatterns(this);
        }
    }

    public IModelProvider getWebEdit() {
        return this.webEdit;
    }

    protected void roleAssociations() {
        super.roleAssociations();
        List constraints = ApiClass.getConstraints(this.webEdit);
        Iterator iter = constraints.iterator();
        while (iter.hasNext()) {
            this.checkAndRegisterConstraint(iter.next(), false);
        }
    }

    private void checkAndRegisterConstraint(Object constraint, boolean notify) {
        HashMap collectionsMap = SecurityWebUtilities.getPatternsFor(this.webEdit, constraint, this);
        ArrayList collections = new ArrayList();
        if (!collectionsMap.isEmpty()) {
            AuthConstraint authConstraint;
            this.regsiterAdapter((EObject)constraint, (Adapter)new SecurityConstraintAdapter((EObject)constraint));
            if (constraint instanceof SecurityConstraint) {
                authConstraint = ((SecurityConstraint)constraint).getAuthConstraint();
                if (authConstraint != null) {
                    this.regsiterAdapter((EObject)authConstraint, (Adapter)new AuthConstraintAdapter((EObject)authConstraint));
                }
            } else {
                authConstraint = ((org.eclipse.jst.javaee.web.SecurityConstraint)constraint).getAuthConstraint();
                if (authConstraint != null) {
                    this.regsiterAdapter((EObject)authConstraint, (Adapter)new AuthConstraintAdapter((EObject)authConstraint));
                }
            }
            this.registerConstraintRoles(constraint, ApiClass.getRolesFor(constraint), notify);
            for (Map.Entry mapEntry : collectionsMap.entrySet()) {
                Object webResourceCollection = mapEntry.getKey();
                collections.add(webResourceCollection);
                this.regsiterAdapter((EObject)webResourceCollection, (Adapter)new WebResourceCollectionAdapter((EObject)webResourceCollection));
                this.collectionsToPatternsMap.put(webResourceCollection, mapEntry.getValue());
            }
            this.constraintsToCollectionsMap.put(constraint, collections);
        }
    }

    private void registerConstraintRoles(Object constraint, List rolesFor, boolean notify) {
        boolean newRoleFound = false;
        for (String role : rolesFor) {
            List<Object> constraints;
            if (this.roleToConstraintsMap.containsKey(role)) {
                constraints = (List)this.roleToConstraintsMap.get(role);
                constraints.add(constraint);
                continue;
            }
            constraints = new ArrayList<Object>();
            constraints.add(constraint);
            this.roleToConstraintsMap.put(role, constraints);
            this.roles.add(role);
            newRoleFound = true;
        }
        if (newRoleFound && notify) {
            this.fire((AbstractSecurityEvent)new SecurityRoleAssociationAddedEvent((Object)this));
        }
    }

    private void unregisterRolesFromConstraint(Object constraint, List roles) {
        boolean fireEvent = false;
        for (String role : roles) {
            if (!this.roleToConstraintsMap.containsKey(role)) continue;
            List constraints = (List)this.roleToConstraintsMap.get(role);
            constraints.remove(constraint);
            if (!constraints.isEmpty()) continue;
            this.roleToConstraintsMap.remove(role);
            this.roles.remove(role);
            fireEvent = true;
        }
        if (fireEvent) {
            this.fire((AbstractSecurityEvent)new SecurityRoleAssociationRemovedEvent((Object)this));
        }
    }

    private void unregisterConstraint(Object constraint) {
        ArrayList collections = new ArrayList((List)this.constraintsToCollectionsMap.get(constraint));
        Iterator iter = collections.iterator();
        while (iter.hasNext()) {
            this.unregisterCollection((EObject)iter.next(), constraint);
        }
    }

    private void unregisterCollection(EObject webResourceCollection, Object constraint) {
        this.unregisterAdapter(webResourceCollection);
        if (constraint == null && webResourceCollection instanceof WebResourceCollection) {
            constraint = ((WebResourceCollection)webResourceCollection).getSecConstraint();
        }
        this.collectionsToPatternsMap.remove(webResourceCollection);
        List collections = (List)this.constraintsToCollectionsMap.get(constraint);
        collections.remove(webResourceCollection);
        if (collections.isEmpty()) {
            Object ac = null;
            ac = constraint instanceof SecurityConstraint ? ((SecurityConstraint)constraint).getAuthConstraint() : ((org.eclipse.jst.javaee.web.SecurityConstraint)constraint).getAuthConstraint();
            if (ac != null) {
                this.unregisterAdapter((EObject)ac);
            }
            this.unregisterAdapter((EObject)constraint);
            this.constraintsToCollectionsMap.remove(constraint);
            this.unregisterRolesFromConstraint(constraint, ApiClass.getRolesFor(constraint));
        }
    }

    private void checkConstraintForPatternMatches(Object collection) {
        List patterns = SecurityWebUtilities.getMatchingPatternsFromCollection(this.getProject(), collection, this);
        if (patterns.isEmpty()) {
            this.unregisterCollection((EObject)collection, null);
        } else {
            this.collectionsToPatternsMap.put(collection, patterns);
        }
    }

    public HashMap getCollectionsToPatternsMap() {
        if (!this.initializedRoles) {
            this.roleAssociations();
        }
        return this.collectionsToPatternsMap;
    }

    public void handleSecurityEvent(AbstractSecurityEvent event) {
        if (!this.initializedRoles) {
            this.roleAssociations();
        }
        if (event instanceof URLPatternAddedEvent) {
            WebResourceCollection webResourceCollection = (WebResourceCollection)event.getSource();
            SecurityConstraint constraint = webResourceCollection.getSecConstraint();
            List urlPatterns = ((URLPatternAddedEvent)event).getChanges();
            this.checkNewCollection(constraint, webResourceCollection, urlPatterns);
        } else if (event instanceof SecurityConstraintAddedEvent) {
            List constraints = ((SecurityConstraintAddedEvent)event).getChanges();
            for (SecurityConstraint constraint : constraints) {
                this.checkAndRegisterConstraint(constraint, true);
            }
        } else if (event instanceof ResourceCollectionAddedEvent) {
            ResourceCollectionAddedEvent collectionEvent = (ResourceCollectionAddedEvent)event;
            SecurityConstraint constraint = (SecurityConstraint)event.getSource();
            List collections = collectionEvent.getChanges();
            for (WebResourceCollection collection : collections) {
                List urlPatterns = ApiClass.getURLPatterns(collection);
                this.checkNewCollection(constraint, collection, urlPatterns);
            }
        } else {
            super.handleSecurityEvent(event);
        }
    }

    private void checkNewCollection(Object constraint, Object collection, List urlPatterns) {
        for (String urlPattern : urlPatterns) {
            if (!SecurityUtilities.patternMatch((IProject)this.getProject(), (Object)urlPattern, (SecurityResourceWrapper)this)) continue;
            if (this.constraintsToCollectionsMap.containsKey(constraint)) {
                ArrayList<String> patterns;
                List collections = (List)this.constraintsToCollectionsMap.get(constraint);
                if (!collections.contains(collection)) {
                    this.regsiterAdapter((EObject)collection, (Adapter)new WebResourceCollectionAdapter((EObject)collection));
                    collections.add(collection);
                    patterns = new ArrayList<String>();
                    patterns.add(urlPattern);
                    this.collectionsToPatternsMap.put(collection, patterns);
                    continue;
                }
                patterns = (ArrayList<String>)this.collectionsToPatternsMap.get(collection);
                patterns.add(urlPattern);
                continue;
            }
            this.regsiterAdapter((EObject)constraint, (Adapter)new SecurityConstraintAdapter((EObject)constraint));
            Object authConstraint = null;
            authConstraint = constraint instanceof SecurityConstraint ? ((SecurityConstraint)constraint).getAuthConstraint() : ((org.eclipse.jst.javaee.web.SecurityConstraint)constraint).getAuthConstraint();
            if (authConstraint != null) {
                this.regsiterAdapter((EObject)authConstraint, (Adapter)new AuthConstraintAdapter((EObject)authConstraint));
            }
            this.registerConstraintRoles(constraint, ApiClass.getRolesFor(constraint), true);
            this.regsiterAdapter((EObject)collection, (Adapter)new WebResourceCollectionAdapter((EObject)collection));
            ArrayList<Object> collections = new ArrayList<Object>();
            collections.add(collection);
            this.constraintsToCollectionsMap.put(constraint, collections);
            ArrayList<String> patterns = new ArrayList<String>();
            patterns.add(urlPattern);
            this.collectionsToPatternsMap.put(collection, patterns);
        }
    }

    public IProject getProject() {
        if (this.project == null) {
            this.project = JavaEEProjectUtilities.getProject((Object)this.webEdit.getModelObject());
        }
        return this.project;
    }

    public boolean isContainer() {
        return false;
    }

    public List getEditedURLPatterns() {
        return this.editedURLPatterns;
    }

    public void setEditedURLPatterns(List editedURLPatterns) {
        this.editedURLPatterns = editedURLPatterns;
    }

    private class AuthConstraintAdapter
    extends AdapterImpl {
        public AuthConstraintAdapter(EObject model) {
            this.setTarget((Notifier)model);
            model.eAdapters().add((Object)this);
        }

        public boolean isAdapterForType(Object object) {
            return object instanceof AuthConstraint || object instanceof org.eclipse.jst.javaee.web.AuthConstraint;
        }

        public void notifyChanged(Notification notification) {
            EStructuralFeature feature;
            Notifier source = (Notifier)notification.getNotifier();
            if (source == this.getTarget() && (feature = (EStructuralFeature)notification.getFeature()) != null) {
                int featureId = -999;
                int type = notification.getEventType();
                if (feature instanceof EStructuralFeature) {
                    featureId = ((AuthConstraintImpl)source).eDerivedStructuralFeatureID(feature);
                    block0 : switch (featureId) {
                        case 1: {
                            switch (type) {
                                case 3: {
                                    String roleName = (String)notification.getNewValue();
                                    ArrayList<String> roles = new ArrayList<String>();
                                    roles.add(roleName);
                                    SecurityConstraint constraint = ((AuthConstraint)source).getSecConstraint();
                                    WebModuleResourceWrapper.this.registerConstraintRoles(constraint, roles, true);
                                    break block0;
                                }
                                case 5: {
                                    Iterator iter = ((List)notification.getNewValue()).iterator();
                                    ArrayList<String> roles = new ArrayList<String>();
                                    while (iter.hasNext()) {
                                        String roleName = (String)iter.next();
                                        roles.add(roleName);
                                    }
                                    SecurityConstraint constraint = ((AuthConstraint)source).getSecConstraint();
                                    WebModuleResourceWrapper.this.registerConstraintRoles(constraint, roles, true);
                                    break block0;
                                }
                                case 4: {
                                    SecurityConstraint constraint = ((AuthConstraint)source).getSecConstraint();
                                    String roleName = (String)notification.getOldValue();
                                    ArrayList<String> roles = new ArrayList<String>();
                                    roles.add(roleName);
                                    WebModuleResourceWrapper.this.unregisterRolesFromConstraint(constraint, roles);
                                    break block0;
                                }
                                case 6: {
                                    SecurityConstraint constraint = ((AuthConstraint)source).getSecConstraint();
                                    ArrayList<String> roles = new ArrayList<String>();
                                    for (String roleName : (List)notification.getOldValue()) {
                                        roles.add(roleName);
                                    }
                                    WebModuleResourceWrapper.this.unregisterRolesFromConstraint(constraint, roles);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private class SecurityConstraintAdapter
    extends AdapterImpl {
        public SecurityConstraintAdapter(EObject model) {
            this.setTarget((Notifier)model);
            model.eAdapters().add((Object)this);
        }

        public boolean isAdapterForType(Object object) {
            return object instanceof SecurityConstraint || object instanceof org.eclipse.jst.javaee.web.SecurityConstraint;
        }

        public void notifyChanged(Notification notification) {
            EStructuralFeature feature;
            Notifier source = (Notifier)notification.getNotifier();
            if (source == this.getTarget() && (feature = (EStructuralFeature)notification.getFeature()) != null) {
                int type = notification.getEventType();
                int featureId = -999;
                if (feature instanceof EStructuralFeature) {
                    featureId = ((SecurityConstraintImpl)source).eDerivedStructuralFeatureID(feature);
                    block0 : switch (featureId) {
                        case 1: {
                            switch (type) {
                                case 1: {
                                    if (notification.getNewValue() != null) break;
                                    WebModuleResourceWrapper.this.unregisterConstraint((SecurityConstraint)source);
                                }
                            }
                        }
                        case 3: {
                            switch (type) {
                                case 3: {
                                    AuthConstraint authConstraint = (AuthConstraint)notification.getNewValue();
                                    WebModuleResourceWrapper.this.regsiterAdapter((EObject)authConstraint, (Adapter)new AuthConstraintAdapter((EObject)authConstraint));
                                    break;
                                }
                                case 4: {
                                    AuthConstraint authConstraint = (AuthConstraint)notification.getOldValue();
                                    WebModuleResourceWrapper.this.unregisterAdapter((EObject)authConstraint);
                                }
                            }
                        }
                        case 2: {
                            switch (type) {
                                case 4: {
                                    WebResourceCollection collection = (WebResourceCollection)notification.getOldValue();
                                    WebModuleResourceWrapper.this.unregisterCollection((EObject)collection, (SecurityConstraint)source);
                                    break block0;
                                }
                                case 6: {
                                    for (WebResourceCollection collection : (List)notification.getOldValue()) {
                                        WebModuleResourceWrapper.this.unregisterCollection((EObject)collection, (SecurityConstraint)source);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private class WebResourceCollectionAdapter
    extends AdapterImpl {
        public WebResourceCollectionAdapter(EObject model) {
            this.setTarget((Notifier)model);
            model.eAdapters().add((Object)this);
        }

        public boolean isAdapterForType(Object object) {
            return object instanceof WebResourceCollection || object instanceof org.eclipse.jst.javaee.web.WebResourceCollection;
        }

        public void notifyChanged(Notification notification) {
            EStructuralFeature feature;
            Notifier source = (Notifier)notification.getNotifier();
            if (source == this.getTarget() && (feature = (EStructuralFeature)notification.getFeature()) != null) {
                int type = notification.getEventType();
                int featureId = -999;
                if (feature instanceof EStructuralFeature) {
                    featureId = ((WebResourceCollectionImpl)source).eDerivedStructuralFeatureID(feature);
                    block0 : switch (featureId) {
                        case 2: {
                            switch (type) {
                                case 4: {
                                    WebModuleResourceWrapper.this.checkConstraintForPatternMatches((WebResourceCollection)source);
                                    break block0;
                                }
                                case 6: {
                                    WebModuleResourceWrapper.this.checkConstraintForPatternMatches((WebResourceCollection)source);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

