/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.constraint.viewer.wrappers;

import com.ibm.etools.webtools.security.base.internal.events.ObjectListChangeEvent;
import com.ibm.etools.webtools.security.editor.internal.SecurityObjectWrapper;
import com.ibm.etools.webtools.security.web.internal.events.HTTPMethodChangedEvent;
import com.ibm.etools.webtools.security.web.internal.events.ResourceCollectionNameChangedEvent;
import com.ibm.etools.webtools.security.web.internal.events.URLPatternAddedEvent;
import com.ibm.etools.webtools.security.web.internal.events.URLPatternRemovedEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.j2ee.webapplication.internal.impl.WebResourceCollectionImpl;

public class ResourceCollectionWrapper
extends SecurityObjectWrapper {
    public ResourceCollectionWrapper(EObject webResourceCollection) {
        super(webResourceCollection);
    }

    public AdapterImpl getAdapter(EObject object) {
        return new WebResourceCollectionAdapter(object);
    }

    private class WebResourceCollectionAdapter
    extends AdapterImpl {
        public WebResourceCollectionAdapter(EObject model) {
            this.setTarget((Notifier)model);
            model.eAdapters().add((Object)this);
        }

        public boolean isAdapterForType(Object object) {
            return object instanceof WebResourceCollectionAdapter;
        }

        public void notifyChanged(Notification notification) {
            EStructuralFeature feature;
            Notifier source = (Notifier)notification.getNotifier();
            if (source == this.getTarget() && (feature = (EStructuralFeature)notification.getFeature()) != null) {
                int type = notification.getEventType();
                int featureId = -999;
                if (feature instanceof EStructuralFeature) {
                    featureId = ((WebResourceCollectionImpl)source).eDerivedStructuralFeatureID(feature);
                    switch (featureId) {
                        case 0: {
                            ResourceCollectionWrapper.this.fire(new ResourceCollectionNameChangedEvent(feature));
                            break;
                        }
                        case 3: {
                            ResourceCollectionWrapper.this.fire(new HTTPMethodChangedEvent(feature));
                            break;
                        }
                        case 2: {
                            ObjectListChangeEvent event = null;
                            ArrayList<String> urlPatterns = new ArrayList<String>();
                            switch (type) {
                                case 3: {
                                    String pattern = (String)notification.getNewValue();
                                    urlPatterns.add(pattern);
                                    event = new URLPatternAddedEvent(source, urlPatterns);
                                    break;
                                }
                                case 5: {
                                    for (String pattern : (List)notification.getNewValue()) {
                                        urlPatterns.add(pattern);
                                    }
                                    event = new URLPatternAddedEvent(source, urlPatterns);
                                    break;
                                }
                                case 4: {
                                    String pattern = (String)notification.getOldValue();
                                    urlPatterns.add(pattern);
                                    event = new URLPatternRemovedEvent(source, urlPatterns);
                                    break;
                                }
                                case 6: {
                                    for (String pattern : (List)notification.getOldValue()) {
                                        urlPatterns.add(pattern);
                                    }
                                    event = new URLPatternRemovedEvent(source, urlPatterns);
                                }
                            }
                            if (event == null) break;
                            ResourceCollectionWrapper.this.fire(event);
                        }
                    }
                }
            }
        }
    }
}

