/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.constraint.viewer.menu;

import com.ibm.etools.webtools.security.base.internal.common.ops.ICommonOperationsContext;
import com.ibm.etools.webtools.security.base.internal.resource.providers.GenericNode;
import com.ibm.etools.webtools.security.base.internal.util.SecurityUtilities;
import com.ibm.etools.webtools.security.editor.internal.SecurityObjectTreeNode;
import com.ibm.etools.webtools.security.editor.internal.actions.TreeViewerRenameAction;
import com.ibm.etools.webtools.security.web.internal.api.ApiClass;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.ConstraintTreeNode;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.EditResourceCollection;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.ResourceCollectionTreeNode;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.URLPatternTreeNode;
import com.ibm.etools.webtools.security.web.internal.nls.Messages;
import com.ibm.etools.webtools.security.web.internal.util.SecurityWebUtilities;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;
import org.eclipse.swt.widgets.MenuItem;

public class RenameAction
extends TreeViewerRenameAction {
    public RenameAction(TreeViewer constraintsViewer, MenuItem menuItem, ICommonOperationsContext context) {
        super(constraintsViewer, menuItem, context);
        this.disable();
    }

    public void checkEnablement(ISelection selection) {
        this.enabled = false;
        StructuredSelection ss = (StructuredSelection)selection;
        Object selectedNode = ss.getFirstElement();
        if (ss.size() == 1 && (selectedNode instanceof ConstraintTreeNode || selectedNode instanceof ResourceCollectionTreeNode || selectedNode instanceof URLPatternTreeNode)) {
            this.enabled = true;
            if (selectedNode instanceof ConstraintTreeNode) {
                this.label = Messages.edit_constraint_definition;
            } else if (selectedNode instanceof ResourceCollectionTreeNode) {
                this.label = Messages.edit_collection_definition;
            } else if (selectedNode instanceof URLPatternTreeNode) {
                this.label = Messages.changeURLPattern_menu_label;
            }
        }
        if (this.enabled) {
            if (!this.isDisposed && this.trigger instanceof MenuItem) {
                ((MenuItem)this.trigger).setText(this.label);
            }
            this.enable();
        } else {
            this.disable();
        }
    }

    public void run() {
        if (this.enabled) {
            if (!this.context.validateState()) {
                return;
            }
            GenericNode selectedNode = (GenericNode)((StructuredSelection)this.viewer.getSelection()).getFirstElement();
            if (selectedNode instanceof ConstraintTreeNode) {
                this.createAndOpenInLineEditor(selectedNode);
            } else if (selectedNode instanceof ResourceCollectionTreeNode) {
                ResourceCollectionTreeNode node = (ResourceCollectionTreeNode)selectedNode;
                EObject resourceCollection = node.getObjectWrapper().getEmfObject();
                EditResourceCollection dialog = new EditResourceCollection(SecurityUtilities.getShell(), this.context, resourceCollection);
                dialog.open();
                this.viewer.refresh((Object)selectedNode);
            } else {
                this.createAndOpenInLineEditor(selectedNode);
            }
        }
    }

    public String getTextFromObject(GenericNode selectedNode) {
        String result = "";
        Object modelObject = this.context.getModelProvider().getModelObject();
        if (modelObject instanceof WebApp) {
            WebApp webApp = (WebApp)modelObject;
            if (selectedNode instanceof ConstraintTreeNode) {
                int j2EEVersion = webApp.getJ2EEVersionID();
                SecurityConstraint constraint = (SecurityConstraint)((ConstraintTreeNode)selectedNode).getObjectWrapper().getEmfObject();
                result = SecurityWebUtilities.getDisplayName(constraint, j2EEVersion);
            } else if (selectedNode instanceof ResourceCollectionTreeNode) {
                WebResourceCollection collection = (WebResourceCollection)((ResourceCollectionTreeNode)selectedNode).getObjectWrapper().getEmfObject();
                result = collection.getWebResourceName();
            } else if (selectedNode instanceof URLPatternTreeNode) {
                result = ((URLPatternTreeNode)selectedNode).getLabel();
            }
        }
        return result;
    }

    protected void saveChange(GenericNode selectedNode, String newName) {
        if (selectedNode instanceof ConstraintTreeNode) {
            SecurityConstraint constraint = (SecurityConstraint)((ConstraintTreeNode)selectedNode).getObjectWrapper().getEmfObject();
            ApiClass.renameConstraint(this.context.getModelProvider(), this.context.getEditingDomain(), constraint, newName);
        } else if (selectedNode instanceof ResourceCollectionTreeNode) {
            WebResourceCollection collection = (WebResourceCollection)((ResourceCollectionTreeNode)selectedNode).getObjectWrapper().getEmfObject();
            ApiClass.renameCollection(this.context.getEditingDomain(), collection, newName);
        } else if (selectedNode instanceof URLPatternTreeNode) {
            String urlPattern = ((URLPatternTreeNode)selectedNode).getLabel();
            WebResourceCollection collection = (WebResourceCollection)((SecurityObjectTreeNode)selectedNode.getParent()).getObjectWrapper().getEmfObject();
            ApiClass.renameURLPattern(collection, this.context.getEditingDomain(), urlPattern, newName);
        }
    }
}

