/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.constraint.viewer.menu;

import com.ibm.etools.webtools.security.base.internal.actions.AbstractViewerMenuAction;
import com.ibm.etools.webtools.security.base.internal.common.ops.ICommonOperationsContext;
import com.ibm.etools.webtools.security.base.internal.util.SecurityUtilities;
import com.ibm.etools.webtools.security.editor.internal.SecurityObjectTreeNode;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.ConstraintTreeNode;
import com.ibm.etools.webtools.security.web.internal.util.SecurityWebUtilities;
import com.ibm.etools.webtools.security.web.internal.wizards.roleAssoc.RoleAssocDataModel;
import com.ibm.etools.webtools.security.web.internal.wizards.roleAssoc.RoleAssocWizard;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class ChangeConstraintRoleAssociationAction
extends AbstractViewerMenuAction {
    public ChangeConstraintRoleAssociationAction(TreeViewer constraintsViewer, MenuItem menuItem, ICommonOperationsContext context) {
        super((StructuredViewer)constraintsViewer, (Widget)menuItem, context);
        this.disable();
    }

    public void checkEnablement(ISelection selection) {
        this.enabled = false;
        StructuredSelection ss = (StructuredSelection)selection;
        if (ss.size() == 1 && ss.getFirstElement() instanceof ConstraintTreeNode) {
            this.enabled = true;
        }
        if (this.enabled) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void run() {
        if (this.enabled) {
            SecurityObjectTreeNode node = (SecurityObjectTreeNode)((StructuredSelection)this.viewer.getSelection()).getFirstElement();
            EObject constraint = node.getObjectWrapper().getEmfObject();
            RoleAssocDataModel model = new RoleAssocDataModel(this.context.getProject());
            int j2EEVersion = -1;
            Object modelObject = this.context.getModelProvider().getModelObject();
            if (modelObject instanceof WebApp) {
                WebApp webApp = (WebApp)modelObject;
                j2EEVersion = webApp.getJ2EEVersionID();
            }
            String name = SecurityWebUtilities.getDisplayName(constraint, j2EEVersion);
            model.setPropertyValue("constraint name", name);
            model.setEditingDomain(this.context.getEditingDomain());
            model.setModelProvider(this.context.getModelProvider());
            RoleAssocWizard wizard = new RoleAssocWizard(model);
            WizardDialog dialog = new WizardDialog(SecurityUtilities.getShell(), (IWizard)wizard);
            dialog.open();
        }
    }
}

