/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.constraint.viewer;

import com.ibm.etools.webtools.security.base.internal.Images;
import com.ibm.etools.webtools.security.base.internal.events.AbstractSecurityEvent;
import com.ibm.etools.webtools.security.base.internal.resource.providers.GenericNode;
import com.ibm.etools.webtools.security.editor.internal.SecurityObjectTreeNode;
import com.ibm.etools.webtools.security.editor.internal.SecurityObjectWrapper;
import com.ibm.etools.webtools.security.web.internal.api.ApiClass;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.HTTPMethodsTreeNode;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.URLPatternTreeNode;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.wrappers.HTTPMethodsWrapper;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.wrappers.URLPatternWrapper;
import com.ibm.etools.webtools.security.web.internal.events.HTTPMethodChangedEvent;
import com.ibm.etools.webtools.security.web.internal.events.ResourceCollectionNameChangedEvent;
import com.ibm.etools.webtools.security.web.internal.events.URLPatternAddedEvent;
import com.ibm.etools.webtools.security.web.internal.events.URLPatternRemovedEvent;
import com.ibm.etools.webtools.security.web.internal.nls.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.webapplication.HTTPMethodTypeEnum;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.swt.graphics.Image;

public class ResourceCollectionTreeNode
extends SecurityObjectTreeNode {
    public ResourceCollectionTreeNode(Image image, String label, SecurityObjectWrapper objectWrapper) {
        super(image, label, objectWrapper);
    }

    public void generateChildren() {
        this.refreshChildren();
    }

    private void refreshChildren() {
        this.refreshHTTPChildren();
        this.refreshURLChildren();
    }

    public void handleSecurityEvent(AbstractSecurityEvent event) {
        if (event instanceof ResourceCollectionNameChangedEvent) {
            this.label = ((WebResourceCollection)this.objectWrapper.getEmfObject()).getWebResourceName();
            this.fire(new ResourceCollectionNameChangedEvent((Object)this));
        } else if (event instanceof HTTPMethodChangedEvent) {
            this.refreshHTTPChildren();
            this.fire(new HTTPMethodChangedEvent((Object)this));
        } else if (event instanceof URLPatternAddedEvent) {
            this.refreshURLChildren();
            URLPatternAddedEvent urlEvent = (URLPatternAddedEvent)event;
            URLPatternAddedEvent newEvent = new URLPatternAddedEvent((Object)this, urlEvent.getChanges());
            this.fire((AbstractSecurityEvent)newEvent);
        } else if (event instanceof URLPatternRemovedEvent) {
            this.refreshURLChildren();
            URLPatternRemovedEvent urlEvent = (URLPatternRemovedEvent)event;
            URLPatternRemovedEvent newEvent = new URLPatternRemovedEvent((Object)this, urlEvent.getChanges());
            this.fire((AbstractSecurityEvent)newEvent);
        }
    }

    private void refreshHTTPChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        EObject webResourceCollection = this.getObjectWrapper().getEmfObject();
        String httpMethodNames = String.valueOf(Messages.http_method_access_label) + ": ";
        List httpMethods = ApiClass.getHTTPMethods(webResourceCollection);
        for (Object httpMethod : httpMethods) {
            String httpMethodName = null;
            if (httpMethod instanceof HTTPMethodTypeEnum) {
                httpMethodName = ((HTTPMethodTypeEnum)httpMethod).getName();
            } else if (httpMethod instanceof String) {
                httpMethodName = (String)httpMethod;
            }
            httpMethodNames = httpMethodNames.equals(String.valueOf(Messages.http_method_access_label) + ": ") ? String.valueOf(httpMethodNames) + httpMethodName : String.valueOf(httpMethodNames) + ", " + httpMethodName;
        }
        HTTPMethodsWrapper wrapper = new HTTPMethodsWrapper();
        HTTPMethodsTreeNode newNode = new HTTPMethodsTreeNode(Images.getHTTPMethodImage(), httpMethodNames, wrapper);
        newNode.setParent((GenericNode)this);
        if (this.children.size() > 0) {
            this.children.remove(0);
        }
        this.children.add(0, newNode);
    }

    private void refreshURLChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        EObject webResourceCollection = this.getObjectWrapper().getEmfObject();
        if (this.children.size() > 1) {
            int i = this.children.size() - 1;
            while (i > 0) {
                GenericNode child = (GenericNode)this.children.get(i);
                child.dispose();
                this.children.remove(i);
                --i;
            }
        }
        List children = ApiClass.getURLPatterns(webResourceCollection);
        ArrayList copy = new ArrayList(children);
        for (Object urlMethodType : copy) {
            URLPatternWrapper wrapper = new URLPatternWrapper();
            String label = null;
            if (urlMethodType instanceof String) {
                label = (String)urlMethodType;
            } else {
                UrlPatternType patternType = (UrlPatternType)urlMethodType;
                label = patternType.getValue();
            }
            URLPatternTreeNode newNode = new URLPatternTreeNode(Images.getURLPatternImage(), label, wrapper);
            newNode.setParent((GenericNode)this);
            this.addChild((GenericNode)newNode);
        }
    }

    public int category() {
        return 2;
    }
}

