/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.constraint.viewer;

import com.ibm.etools.webtools.security.base.internal.common.ops.ICommonOperationsContext;
import com.ibm.etools.webtools.security.web.internal.api.ApiClass;
import com.ibm.etools.webtools.security.web.internal.nls.Messages;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.DescriptionGroup;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;
import org.eclipse.jst.javaee.core.Description;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditResourceCollection
extends TrayDialog {
    private Text resourceCollectionName = null;
    private Text resourceCollectionDescription = null;
    private Object webResourceCollection;
    private ICommonOperationsContext model;

    public EditResourceCollection(Shell parentShell, ICommonOperationsContext model, Object webResourceCollection) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.model = model;
        this.webResourceCollection = webResourceCollection;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.edit_collection_name_label);
        Composite formComp = new Composite(parent, 0);
        formComp.setLayout((Layout)new FormLayout());
        formComp.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(formComp, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)gridLayout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        composite.setLayoutData((Object)formData);
        Label label = new Label(composite, 0);
        label.setText(Messages.resource_collection_name);
        this.resourceCollectionName = new Text(composite, 2048);
        String name = null;
        String description = null;
        if (this.webResourceCollection instanceof WebResourceCollection) {
            name = ((WebResourceCollection)this.webResourceCollection).getWebResourceName();
            description = this.getDescription();
        } else {
            name = ((org.eclipse.jst.javaee.web.WebResourceCollection)this.webResourceCollection).getWebResourceName();
            description = ((Description)((org.eclipse.jst.javaee.web.WebResourceCollection)this.webResourceCollection).getDescriptions().get(0)).getValue();
        }
        if (name == null) {
            name = "";
        }
        this.resourceCollectionName.setText(name);
        this.resourceCollectionName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (EditResourceCollection.this.resourceCollectionName.getText().equals("")) {
                    EditResourceCollection.this.getButton(0).setEnabled(false);
                } else {
                    EditResourceCollection.this.getButton(0).setEnabled(true);
                }
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.resourceCollectionName.setLayoutData((Object)gd);
        label = new Label(composite, 0);
        label.setText(Messages.description);
        gd = new GridData(2);
        label.setLayoutData((Object)gd);
        this.resourceCollectionDescription = new Text(composite, 2626);
        if (description == null) {
            description = "";
        }
        this.resourceCollectionDescription.setText(description);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.heightHint = 60;
        gd.widthHint = 150;
        gd.grabExcessHorizontalSpace = true;
        this.resourceCollectionDescription.setLayoutData((Object)gd);
        return formComp;
    }

    private String getDescription() {
        String result = "";
        WebApp webApp = ((WebArtifactEdit)this.model.getModelProvider()).getWebApp();
        if (webApp.getJ2EEVersionID() >= 14) {
            EList eList = ((WebResourceCollection)this.webResourceCollection).getDescriptions();
            if (eList != null && !eList.isEmpty()) {
                result = ((org.eclipse.jst.j2ee.common.Description)eList.get(0)).getValue();
            }
        } else if (((WebResourceCollection)this.webResourceCollection).getDescription() != null) {
            result = ((WebResourceCollection)this.webResourceCollection).getDescription();
        }
        return result;
    }

    protected void okPressed() {
        CompoundCommand command = new CompoundCommand();
        String name = null;
        name = this.webResourceCollection instanceof WebResourceCollection ? ((WebResourceCollection)this.webResourceCollection).getWebResourceName() : ((org.eclipse.jst.javaee.web.WebResourceCollection)this.webResourceCollection).getWebResourceName();
        if (!this.resourceCollectionName.getText().equals(name)) {
            command.append(ApiClass.renameCollectionCommand(this.model.getEditingDomain(), this.webResourceCollection, this.resourceCollectionName.getText()));
        }
        if (!this.getDescription().equals(this.resourceCollectionDescription.getText())) {
            String description = this.resourceCollectionDescription.getText();
            WebApp webApp = ((WebArtifactEdit)this.model.getModelProvider()).getWebApp();
            if (webApp.getJ2EEVersionID() >= 14) {
                DescriptionGroup descriptionGroup = CommonFactory.eINSTANCE.createDescriptionGroup();
                org.eclipse.jst.j2ee.common.Description descript = CommonFactory.eINSTANCE.createDescription();
                descript.setValue(description);
                descriptionGroup.getDescriptions().add((Object)descript);
                command.append(SetCommand.create((EditingDomain)this.model.getEditingDomain(), (Object)this.webResourceCollection, (Object)WebapplicationPackage.eINSTANCE.getWebResourceCollection_Descriptions(), (Object)descriptionGroup.getDescriptions()));
            } else {
                command.append(SetCommand.create((EditingDomain)this.model.getEditingDomain(), (Object)this.webResourceCollection, (Object)WebapplicationPackage.eINSTANCE.getWebResourceCollection_Description(), (Object)description));
            }
        }
        if (!command.isEmpty() && command.canExecute()) {
            this.model.getEditingDomain().getCommandStack().execute((Command)command);
        }
        super.okPressed();
    }
}

