/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.constraint.viewer;

import com.ibm.etools.webtools.security.editor.internal.GenericTreeNodeLabelProvider;
import com.ibm.etools.webtools.security.editor.internal.roles.viewer.RoleSelectionManager;
import com.ibm.etools.webtools.security.web.internal.api.ApiClass;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.ConstraintTreeNode;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ConstraintsViewerLabelProvider
extends GenericTreeNodeLabelProvider {
    private RoleSelectionManager roleSelectionManager = null;
    private TreeViewer treeViewer;
    private FontRegistry reg = JFaceResources.getFontRegistry();

    public ConstraintsViewerLabelProvider(RoleSelectionManager roleSelectionManager, TreeViewer treeViewer) {
        this.roleSelectionManager = roleSelectionManager;
        this.treeViewer = treeViewer;
    }

    public String getText(Object element) {
        String result = super.getText(element);
        if (this.roleSelectionManager != null && element instanceof ConstraintTreeNode) {
            Widget widget = this.treeViewer.testFindItem(element);
            ConstraintTreeNode constraintNode = (ConstraintTreeNode)((Object)element);
            List roles = ApiClass.getRolesFor(constraintNode.getObjectWrapper().getEmfObject());
            boolean selected = false;
            if (!roles.isEmpty()) {
                Iterator iterator = roles.iterator();
                while (iterator.hasNext() && !selected) {
                    String role = (String)iterator.next();
                    selected = this.roleSelectionManager.isRoleSelected(role);
                }
            }
            if (widget instanceof TreeItem) {
                if (selected) {
                    ((TreeItem)widget).setFont(this.reg.getBold("org.eclipse.jface.defaultfont"));
                } else {
                    ((TreeItem)widget).setFont(JFaceResources.getDefaultFont());
                }
            }
        }
        return result;
    }

    public boolean isLabelProperty(Object element, String property) {
        if (property.equals("constraint_roles")) {
            return true;
        }
        return super.isLabelProperty(element, property);
    }
}

