/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.constraint.viewer;

import com.ibm.etools.webtools.security.base.internal.Images;
import com.ibm.etools.webtools.security.base.internal.events.AbstractSecurityEvent;
import com.ibm.etools.webtools.security.base.internal.events.SecurityRolesChangedEvent;
import com.ibm.etools.webtools.security.base.internal.resource.providers.GenericNode;
import com.ibm.etools.webtools.security.editor.internal.SecurityObjectTreeNode;
import com.ibm.etools.webtools.security.editor.internal.SecurityObjectWrapper;
import com.ibm.etools.webtools.security.web.internal.api.ApiClass;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.ResourceCollectionTreeNode;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.wrappers.ResourceCollectionWrapper;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.wrappers.SecurityConstraintWrapper;
import com.ibm.etools.webtools.security.web.internal.events.ResourceCollectionAddedEvent;
import com.ibm.etools.webtools.security.web.internal.events.ResourceCollectionRemovedEvent;
import com.ibm.etools.webtools.security.web.internal.events.SecurityConstraintDisplayNameChangedEvent;
import com.ibm.etools.webtools.security.web.internal.util.SecurityWebUtilities;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;
import org.eclipse.swt.graphics.Image;

public class ConstraintTreeNode
extends SecurityObjectTreeNode {
    private int j2EEVersion;
    private String constraintName = "";

    public ConstraintTreeNode(Image image, String label, SecurityObjectWrapper objectWrapper, int j2EEVersion) {
        super(image, label, objectWrapper);
        this.j2EEVersion = j2EEVersion;
        if (label.equals("")) {
            this.updateLabel();
        }
    }

    public void handleSecurityEvent(AbstractSecurityEvent event) {
        if (event instanceof ResourceCollectionAddedEvent) {
            this.refreshChildren();
            this.fire((AbstractSecurityEvent)new ResourceCollectionAddedEvent((Object)this, ((ResourceCollectionAddedEvent)event).getChanges()));
        } else if (event instanceof ResourceCollectionRemovedEvent) {
            this.refreshChildren();
            this.fire((AbstractSecurityEvent)new ResourceCollectionRemovedEvent((Object)this, ((ResourceCollectionRemovedEvent)event).getChanges()));
        } else if (event instanceof SecurityConstraintDisplayNameChangedEvent) {
            this.updateLabel();
            this.fire(new SecurityConstraintDisplayNameChangedEvent((Object)this));
        } else if (event instanceof SecurityRolesChangedEvent) {
            this.updateLabel();
            this.fire((AbstractSecurityEvent)new SecurityRolesChangedEvent((Object)this));
        } else {
            this.fire(event);
        }
    }

    private void updateLabel() {
        EObject constraint = this.getObjectWrapper().getEmfObject();
        this.constraintName = SecurityWebUtilities.getDisplayName(constraint, this.j2EEVersion);
        String roles = null;
        List roleNames = ApiClass.getRolesFor(constraint);
        for (String roleName : roleNames) {
            roles = roles == null ? roleName : String.valueOf(roles) + ", " + roleName;
        }
        String label = this.constraintName;
        if (roles != null) {
            label = String.valueOf(label) + "  (" + roles + ")";
        }
        this.label = label;
    }

    public List getRoles() {
        return ((SecurityConstraintWrapper)this.getObjectWrapper()).getRoles();
    }

    private void refreshChildren() {
        SecurityObjectWrapper wrapper;
        List modelChildren = ApiClass.getResourceCollections(this.getObjectWrapper().getEmfObject());
        ArrayList modelChildrenCopy = new ArrayList(modelChildren);
        ArrayList viewerChildren = this.children;
        if (viewerChildren == null) {
            viewerChildren = new ArrayList();
        }
        ArrayList viewerChildrenCopy = new ArrayList(viewerChildren);
        for (SecurityObjectTreeNode treeNode : viewerChildrenCopy) {
            wrapper = treeNode.getObjectWrapper();
            if (modelChildrenCopy.contains(wrapper.getEmfObject())) {
                modelChildrenCopy.remove(wrapper.getEmfObject());
                continue;
            }
            this.removeChild((GenericNode)treeNode);
        }
        for (Object webResourceCollection : modelChildrenCopy) {
            wrapper = new ResourceCollectionWrapper((EObject)webResourceCollection);
            String name = null;
            name = webResourceCollection instanceof WebResourceCollection ? ((WebResourceCollection)webResourceCollection).getWebResourceName() : ((org.eclipse.jst.javaee.web.WebResourceCollection)webResourceCollection).getWebResourceName();
            ResourceCollectionTreeNode newNode = new ResourceCollectionTreeNode(Images.getResourceCollectionImage(), name, wrapper);
            newNode.setParent((GenericNode)this);
            this.addChild((GenericNode)newNode);
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
    }

    public void generateChildren() {
        this.refreshChildren();
    }

    public int category() {
        return 1;
    }

    public String getConstraintName() {
        return this.constraintName;
    }
}

