/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal;

import com.ibm.etools.webtools.security.web.SecurityWebPlugin;
import com.ibm.etools.webtools.security.web.internal.Logger;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class Images {
    private static ImageRegistry imageRegistry = SecurityWebPlugin.getDefault().getImageRegistry();
    private static URL installURL = SecurityWebPlugin.getDefault().getBundle().getEntry("/");

    private Images() {
    }

    public static final Image getServletImage() {
        return Images.getImage("servlet");
    }

    public static final Image getServletMappingImage() {
        return Images.getImage("servlet_mapping");
    }

    private static Image getImage(String key) {
        Image image = imageRegistry.get(key);
        if (image == null) {
            imageRegistry.put(key, Images.getImageDescriptor(key));
            image = imageRegistry.get(key);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = Images.primGetImageDescriptor(key);
        if (imageDescriptor == null) {
            imageDescriptor = Images.primGetImageDescriptor(Images.getNotFoundKeyFor(key));
        }
        return imageDescriptor;
    }

    private static ImageDescriptor primGetImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = null;
        try {
            imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(installURL, "icons/" + key + ".gif"));
        }
        catch (MalformedURLException exception) {
            Logger.log(4, "Failed to load image for \"" + key + "\"", exception);
        }
        if (imageDescriptor == null) {
            Logger.log(4, "No image found for " + key);
        }
        return imageDescriptor;
    }

    private static String getNotFoundKeyFor(String key) {
        return "notfound_obj";
    }
}

