/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.base.internal.util;

import com.ibm.etools.webtools.security.base.internal.Logger;
import com.ibm.etools.webtools.security.base.internal.common.ops.ICommonOperationsContext;
import com.ibm.etools.webtools.security.base.internal.common.ops.SecurityCommonOperationsRegistry;
import com.ibm.etools.webtools.security.base.internal.nls.Messages;
import com.ibm.etools.webtools.security.base.internal.resource.providers.ResourceNode;
import com.ibm.etools.webtools.security.base.internal.resource.providers.SecurityResourceProvider;
import com.ibm.etools.webtools.security.base.internal.resource.providers.SecurityResourceProviderRegistry;
import com.ibm.etools.webtools.security.base.internal.resource.providers.SecurityResourceWrapper;
import com.ibm.etools.webtools.security.base.internal.util.IWASHelper;
import com.ibm.etools.webtools.security.base.internal.util.PromptForNewRoleDialog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class SecurityUtilities {
    private static IWASHelper WASHelper = null;

    public static final Shell getShell() {
        IWorkbenchWindow workbenchWindow;
        Shell shell = null;
        Display display = SecurityUtilities.getDisplay();
        if (display != null) {
            shell = display.getActiveShell();
        }
        if (shell == null && (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            shell = workbenchWindow.getShell();
        }
        return shell;
    }

    public static final Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static final boolean isProviderContributionActive(IProject project, String contributionId) {
        boolean result = false;
        SecurityResourceProviderRegistry registry = SecurityResourceProviderRegistry.singleton;
        List facetIds = registry.getProjectFacetsFor(contributionId);
        Iterator iter = facetIds.iterator();
        while (iter.hasNext() && !result) {
            String projectFacetId = (String)iter.next();
            result = SecurityUtilities.isProjectOfType(project, projectFacetId);
        }
        return result;
    }

    public static final boolean isWebProject(IProject project) {
        return SecurityUtilities.isProjectOfType(project, "jst.web");
    }

    public static final boolean isProjectOfType(IProject project, String typeID) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return false;
        }
        if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)typeID)) {
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)typeID);
            return projectFacet != null && facetedProject.hasProjectFacet(projectFacet);
        }
        return false;
    }

    public static final List getResourcesForParent(IProject project, SecurityResourceWrapper resource) {
        ArrayList result = new ArrayList();
        SecurityResourceProviderRegistry registry = SecurityResourceProviderRegistry.singleton;
        List providerIds = registry.getIds();
        for (String id : providerIds) {
            if (!SecurityUtilities.isProviderContributionActive(project, id)) continue;
            SecurityResourceProvider provider = registry.getSecurityResourceProviderFor(id);
            result.addAll(provider.getAllChildResourcesFor(resource));
        }
        return result;
    }

    public static final ResourceNode generateNodeFor(SecurityResourceWrapper resourceWrapper, IProject project) {
        ResourceNode result = null;
        SecurityResourceProviderRegistry registry = SecurityResourceProviderRegistry.singleton;
        List providerIds = registry.getIds();
        Iterator iter = providerIds.iterator();
        while (iter.hasNext() && result == null) {
            String id = (String)iter.next();
            if (!SecurityUtilities.isProviderContributionActive(project, id)) continue;
            SecurityResourceProvider provider = registry.getSecurityResourceProviderFor(id);
            result = provider.generateNodeForWrapper(resourceWrapper, project);
        }
        return result;
    }

    public static final boolean isValidWildCard(String url) {
        boolean result = false;
        if (url.indexOf("*") > -1 && url.indexOf("*") == url.lastIndexOf("*")) {
            if (url.endsWith("*")) {
                result = true;
            } else {
                String[] split = url.split("/");
                String lastSeg = split[split.length - 1];
                if (lastSeg.startsWith("*.")) {
                    result = true;
                }
            }
        }
        return result;
    }

    public static final boolean patternMatch(IProject project, Object pattern, SecurityResourceWrapper target) {
        boolean result = false;
        SecurityResourceProviderRegistry registry = SecurityResourceProviderRegistry.singleton;
        List providerIds = registry.getIds();
        Iterator iter = providerIds.iterator();
        while (iter.hasNext() && !result) {
            String id = (String)iter.next();
            if (!SecurityUtilities.isProviderContributionActive(project, id)) continue;
            SecurityResourceProvider provider = registry.getSecurityResourceProviderFor(id);
            result = provider.patternMatch(pattern, target);
        }
        return result;
    }

    public static final void promptForNewSecurityRole(ICommonOperationsContext context) {
        final ICommonOperationsContext commonContext = context;
        SecurityUtilities.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                PromptForNewRoleDialog rolePrompt = new PromptForNewRoleDialog(SecurityUtilities.getShell());
                int rc = rolePrompt.open();
                if (rc == 0) {
                    SecurityCommonOperationsRegistry.getCommonOperationsForProject(commonContext.getProject()).newSecurityRole(commonContext);
                }
            }
        });
    }

    protected static final void processCommand(Object action, CompoundCommand undoableCommand, EditingDomain editingDomain, IModelProvider model) {
        if (action != null) {
            if (action instanceof Command) {
                if (((Command)action).canExecute()) {
                    if (undoableCommand.isEmpty()) {
                        undoableCommand.append((Command)action);
                        editingDomain.getCommandStack().execute((Command)undoableCommand);
                    } else {
                        ((Command)action).execute();
                        undoableCommand.appendIfCanExecute((Command)action);
                    }
                }
            } else if (action instanceof List) {
                List runnableList = (List)action;
                for (Runnable runnable : runnableList) {
                    model.modify(runnable, null);
                }
            } else if (action instanceof Runnable) {
                model.modify((Runnable)action, null);
            }
        }
    }

    public static final boolean isWASRuntime(IProject project) {
        boolean result = false;
        if (SecurityUtilities.getWASHelper() != null) {
            result = SecurityUtilities.getWASHelper().isWASProject(project);
        }
        return result;
    }

    public static boolean confirmDelete() {
        return MessageDialog.openConfirm((Shell)SecurityUtilities.getShell(), (String)Messages.confirm_delete_dialog_title, (String)Messages.confirm_delete_dialog_message);
    }

    public static IWASHelper getWASHelper() {
        if (WASHelper == null) {
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IConfigurationElement[] conf = reg.getConfigurationElementsFor("com.ibm.etools.webtools.security.base.WASHelper");
            int i = 0;
            while (i < conf.length) {
                IConfigurationElement currentConf = conf[i];
                String configName = currentConf.getName();
                if (configName.equalsIgnoreCase("wasHelper")) {
                    try {
                        WASHelper = (IWASHelper)currentConf.createExecutableExtension("wasHelperClass");
                    }
                    catch (Exception exc) {
                        Logger.logException("Failed to create an instance of the WAS Helper contribution", exc);
                    }
                }
                ++i;
            }
        }
        return WASHelper;
    }

    public static Control findWidest(Control[] controls) {
        Control widest = null;
        if (controls != null && controls.length > 0) {
            widest = controls[0];
            int width = widest.getBounds().width;
            int i = 1;
            while (i < controls.length) {
                if (controls[i].getBounds().width > width) {
                    widest = controls[i];
                    width = widest.getBounds().width;
                }
                ++i;
            }
        }
        return widest;
    }
}

