/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.base.internal.resource.providers;

import com.ibm.etools.webtools.security.base.SecurityBasePlugin;
import com.ibm.etools.webtools.security.base.internal.common.ops.ICommonOperationsContext;
import com.ibm.etools.webtools.security.base.internal.events.AbstractSecurityEvent;
import com.ibm.etools.webtools.security.base.internal.events.ISecurityEventListener;
import com.ibm.etools.webtools.security.base.internal.resource.providers.ISecurityResourceWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;

public abstract class SecurityResourceWrapper
implements ISecurityResourceWrapper,
ISecurityEventListener,
IPropertyChangeListener {
    private Image image = null;
    private String label = "<default label>";
    protected String addressableURL = "";
    protected List urlPatterns = new ArrayList();
    protected Object resource = null;
    protected List roles = new ArrayList();
    protected boolean canBeConstrained = true;
    private ISecurityResourceWrapper parent;
    private List<ISecurityEventListener> listeners = new ArrayList<ISecurityEventListener>();
    protected boolean initializedRoles = false;
    protected boolean generateURLPatterns = true;
    protected IProject project = null;

    public SecurityResourceWrapper(Object resource, String addressableURL) {
        this.resource = resource;
        this.addressableURL = addressableURL;
        SecurityBasePlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public void registerListener(ISecurityEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyid = event.getProperty();
        if (propertyid.equals("faces to wildcards") || propertyid.equals("wildcard pattern")) {
            this.generateURLPatterns = true;
            this.urlPatterns = new ArrayList();
        }
    }

    @Override
    public void removeListener(ISecurityEventListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void fire(AbstractSecurityEvent event) {
        for (ISecurityEventListener listener : this.listeners) {
            listener.handleSecurityEvent(event);
        }
    }

    @Override
    public void dispose() {
        SecurityBasePlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Object getResource() {
        return this.resource;
    }

    public List getRoles() {
        if (!this.initializedRoles) {
            this.roleAssociations();
        }
        return this.roles;
    }

    protected void roleAssociations() {
        this.initializedRoles = true;
    }

    @Override
    public boolean canBeConstrained() {
        return this.canBeConstrained;
    }

    public void setCanBeConstrained(boolean canBeConstrained) {
        this.canBeConstrained = canBeConstrained;
    }

    public int category() {
        return 0;
    }

    @Override
    public void setImage(Image image) {
        this.image = image;
    }

    public HashMap getOverlays() {
        return null;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getAddressableURL() {
        return this.addressableURL;
    }

    @Override
    public ISecurityResourceWrapper getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ISecurityResourceWrapper parent) {
        this.parent = parent;
    }

    @Override
    public final List getURLPatterns() {
        if (this.generateURLPatterns) {
            this.generateURLPatterns = false;
            this.urlPatterns = new ArrayList();
            this.generateURLPatterns();
        }
        return this.urlPatterns;
    }

    @Override
    public void handleSecurityEvent(AbstractSecurityEvent event) {
    }

    @Override
    public abstract IProject getProject();

    @Override
    public abstract void generateURLPatterns();

    public abstract boolean isContainer();

    public boolean canBeDeleted() {
        return false;
    }

    public Object getDeleteCommand(ICommonOperationsContext context) {
        return null;
    }
}

