/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.base.internal.resource.providers;

import com.ibm.etools.webtools.security.base.internal.Logger;
import com.ibm.etools.webtools.security.base.internal.resource.providers.SecurityResourceProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class SecurityResourceProviderRegistry {
    private HashMap projectFacetsByContributionId = new HashMap();
    private HashMap contributionByID = new HashMap();
    private List ids = new ArrayList();
    private HashMap classInstancesToID = new HashMap();
    public static final SecurityResourceProviderRegistry singleton = new SecurityResourceProviderRegistry();
    private boolean initialized = false;

    SecurityResourceProviderRegistry() {
    }

    private void initialize() {
        this.initialized = true;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] conf = reg.getConfigurationElementsFor("com.ibm.etools.webtools.security.base.SecurityResourceProvider");
        int i = 0;
        while (i < conf.length) {
            IConfigurationElement currentConf = conf[i];
            String configName = currentConf.getName();
            if (configName.equalsIgnoreCase("SecurityResourceProvider")) {
                String contributionID = currentConf.getAttribute("id");
                IConfigurationElement[] elements = currentConf.getChildren("projectFacets");
                ArrayList<String> projectFacetIds = new ArrayList<String>();
                if (elements != null && elements.length > 0) {
                    int j = 0;
                    while (j < elements.length) {
                        IConfigurationElement element = elements[j];
                        String facetId = element.getAttribute("facetId");
                        if (facetId != null) {
                            projectFacetIds.add(facetId);
                        }
                        ++j;
                    }
                }
                this.registerProjectFacets(contributionID, projectFacetIds);
                this.registerContribution(contributionID, currentConf);
                this.registerId(contributionID);
            }
            ++i;
        }
    }

    private void registerId(String id) {
        if (!this.ids.contains(id)) {
            this.ids.add(id);
        }
    }

    private void registerContribution(String id, IConfigurationElement currentConf) {
        if (this.contributionByID.containsKey(id)) {
            Logger.log(4, "registerContribution(): Security Resource Provider contribution has an id that has already been registered. id = " + id);
        } else {
            this.contributionByID.put(id, currentConf);
        }
    }

    private void registerProjectFacets(String id, ArrayList projectFacets) {
        if (this.projectFacetsByContributionId.containsKey(id)) {
            Logger.log(4, "registerProjectFacets(): Security Resource Provider contribution has an id that has already been registered. id = " + id);
        } else if (!projectFacets.isEmpty()) {
            this.projectFacetsByContributionId.put(id, projectFacets);
        }
    }

    public List getProjectFacetsFor(String id) {
        if (!this.initialized) {
            this.initialize();
        }
        List result = Collections.EMPTY_LIST;
        if (this.projectFacetsByContributionId.containsKey(id)) {
            result = (List)this.projectFacetsByContributionId.get(id);
        }
        return result;
    }

    public SecurityResourceProvider getSecurityResourceProviderFor(String id) {
        if (!this.initialized) {
            this.initialize();
        }
        SecurityResourceProvider result = null;
        if (this.classInstancesToID.containsKey(id)) {
            result = (SecurityResourceProvider)this.classInstancesToID.get(id);
        } else if (this.contributionByID.containsKey(id)) {
            IConfigurationElement contrib = (IConfigurationElement)this.contributionByID.get(id);
            try {
                result = (SecurityResourceProvider)contrib.createExecutableExtension("className");
                this.classInstancesToID.put(id, result);
            }
            catch (Exception exc) {
                Logger.logException("Failed to create an instance of the Security Resource Provider contribution whose id =" + id, exc);
            }
        }
        return result;
    }

    public List getIds() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.ids;
    }
}

