/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.base.internal.resource.providers;

import com.ibm.etools.webtools.security.base.internal.common.ops.ICommonOperationsContext;
import com.ibm.etools.webtools.security.base.internal.common.ops.SecurityCommonOperationsRegistry;
import com.ibm.etools.webtools.security.base.internal.events.AbstractSecurityEvent;
import com.ibm.etools.webtools.security.base.internal.events.SecurityResourceAddedEvent;
import com.ibm.etools.webtools.security.base.internal.events.SecurityResourceLabelChangedEvent;
import com.ibm.etools.webtools.security.base.internal.events.SecurityRoleAssociationChangedEvent;
import com.ibm.etools.webtools.security.base.internal.resource.providers.GenericNode;
import com.ibm.etools.webtools.security.base.internal.resource.providers.IRoleSelectionManager;
import com.ibm.etools.webtools.security.base.internal.resource.providers.SecurityResourceWrapper;
import com.ibm.etools.webtools.security.base.internal.util.SecurityUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.swt.graphics.Image;

public abstract class ResourceNode
extends GenericNode {
    protected SecurityResourceWrapper resourceWrapper = null;
    protected IProject project = null;

    public ResourceNode(Image image, String label, SecurityResourceWrapper resourceWrapper, IProject project) {
        super(image, label);
        this.resourceWrapper = resourceWrapper;
        this.project = project;
        resourceWrapper.registerListener(this);
    }

    public SecurityResourceWrapper getResourceWrapper() {
        return this.resourceWrapper;
    }

    @Override
    public void generateChildren() {
        List resources = SecurityUtilities.getResourcesForParent(this.project, this.resourceWrapper);
        if (resources.isEmpty()) {
            this.children = resources;
        } else {
            for (SecurityResourceWrapper resourceWrapper : resources) {
                ResourceNode child = SecurityUtilities.generateNodeFor(resourceWrapper, this.project);
                child.setParent(this);
                this.addChild(child);
            }
        }
    }

    public void updateChildren() {
        List resources = SecurityUtilities.getResourcesForParent(this.project, this.resourceWrapper);
        HashMap<Object, SecurityResourceWrapper> iResources = new HashMap<Object, SecurityResourceWrapper>();
        for (SecurityResourceWrapper wrapper : resources) {
            iResources.put(wrapper.getResource(), wrapper);
        }
        ArrayList currentChildren = this.children;
        if (currentChildren == null) {
            currentChildren = new ArrayList();
        }
        ArrayList currentChildrenCopy = new ArrayList(currentChildren);
        for (ResourceNode resourceNode : currentChildrenCopy) {
            if (iResources.containsKey(resourceNode.getResourceWrapper().getResource())) {
                SecurityResourceWrapper wrapper = (SecurityResourceWrapper)iResources.get(resourceNode.getResourceWrapper().getResource());
                iResources.remove(resourceNode.getResourceWrapper().getResource());
                wrapper.dispose();
                continue;
            }
            this.removeChild(resourceNode);
        }
        for (Map.Entry entry : iResources.entrySet()) {
            SecurityResourceWrapper resourceWrapper = (SecurityResourceWrapper)entry.getValue();
            ResourceNode child = SecurityUtilities.generateNodeFor(resourceWrapper, this.project);
            child.setParent(this);
            this.addChild(child);
        }
    }

    @Override
    public void handleSecurityEvent(AbstractSecurityEvent event) {
        if (event instanceof SecurityRoleAssociationChangedEvent) {
            if (event.getSource().equals(this.getResourceWrapper())) {
                this.fire(new SecurityRoleAssociationChangedEvent(this));
            } else {
                this.fire(event);
            }
        } else if (event instanceof SecurityResourceAddedEvent) {
            this.fire(event);
        } else if (event instanceof SecurityResourceLabelChangedEvent) {
            this.updateLabel();
            if (event.getSource().equals(this.getResourceWrapper())) {
                this.fire(new SecurityResourceLabelChangedEvent(this));
            } else {
                this.fire(event);
            }
        }
    }

    public void updateLabel() {
        this.label = this.resourceWrapper.getLabel();
    }

    @Override
    public int category() {
        return this.resourceWrapper.category();
    }

    public String getAddressableURL() {
        return this.getResourceWrapper().getAddressableURL();
    }

    public List getURLPatterns() {
        return this.getResourceWrapper().getURLPatterns();
    }

    @Override
    public void dispose() {
        this.resourceWrapper.removeListener(this);
        this.resourceWrapper.dispose();
        super.dispose();
    }

    public boolean isSelected(IRoleSelectionManager roleSelectionManager) {
        boolean selected = false;
        List roles = this.getResourceWrapper().getRoles();
        if (!roles.isEmpty()) {
            Iterator iterator = roles.iterator();
            while (iterator.hasNext() && !selected) {
                selected = roleSelectionManager.isRoleSelected((String)iterator.next());
            }
        }
        return selected;
    }

    public boolean canBeDeleted() {
        return this.resourceWrapper.canBeDeleted();
    }

    public Object getDeleteCommand(ICommonOperationsContext context) {
        return this.resourceWrapper.getDeleteCommand(context);
    }

    public void handleDrop(ICommonOperationsContext context, Object role, CompoundCommand undoableCommand) {
        SecurityCommonOperationsRegistry.getCommonOperationsForProject(context.getProject()).assignRole(context, this.resourceWrapper, role, undoableCommand);
    }
}

