/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.base.internal.preference.page;

import com.ibm.etools.webtools.security.base.SecurityBasePlugin;
import com.ibm.etools.webtools.security.base.internal.SecurityConstants;
import com.ibm.etools.webtools.security.base.internal.nls.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class J2EESecurityPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    IPreferenceStore preferenceStore = SecurityBasePlugin.getDefault().getPreferenceStore();
    List buttons = new ArrayList();
    Button firstRolePrompt;
    Button showWarningPrompt;
    Text wildcard;
    Button facesToWildcard;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        composite.setLayout((Layout)formLayout);
        Group buttonComposite = new Group(composite, 0);
        buttonComposite.setText(Messages.preference_HTTP_method_group_title);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        buttonComposite.setLayoutData((Object)formData);
        int i = 0;
        while (i < SecurityConstants.HTTP_METHODS.length) {
            String methodName = SecurityConstants.HTTP_METHODS[i];
            Button button = new Button((Composite)buttonComposite, 32);
            button.setText(methodName);
            button.setSelection(this.preferenceStore.getBoolean(methodName));
            this.buttons.add(button);
            ++i;
        }
        Group wildcardPatternComposite = new Group(composite, 0);
        wildcardPatternComposite.setText(Messages.preferences_default_wildcard_pattern);
        formLayout = new FormLayout();
        wildcardPatternComposite.setLayout((Layout)formLayout);
        formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment((Control)buttonComposite, 5);
        formData.right = new FormAttachment(100, -5);
        wildcardPatternComposite.setLayoutData((Object)formData);
        Label wildcardLabel = new Label((Composite)wildcardPatternComposite, 0);
        wildcardLabel.setText(String.valueOf(Messages.wildcard_pattern_label) + ":");
        this.wildcard = new Text((Composite)wildcardPatternComposite, 2048);
        formData = new FormData();
        formData.left = new FormAttachment((Control)wildcardLabel, 5);
        formData.top = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        this.wildcard.setLayoutData((Object)formData);
        this.wildcard.setText(this.preferenceStore.getString("wildcard pattern"));
        formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment((Control)this.wildcard, 0, 0x1000000);
        wildcardLabel.setLayoutData((Object)formData);
        this.facesToWildcard = new Button((Composite)wildcardPatternComposite, 32);
        this.facesToWildcard.setText(Messages.apply_faces_servlet_mapping_to_wildcards);
        formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment((Control)this.wildcard, 5);
        formData.right = new FormAttachment(100, -5);
        this.facesToWildcard.setLayoutData((Object)formData);
        this.facesToWildcard.setSelection(this.preferenceStore.getBoolean("faces to wildcards"));
        Group promptsComposite = new Group(composite, 0);
        promptsComposite.setText(Messages.prompts_preferences_title);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        promptsComposite.setLayout((Layout)layout);
        formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment((Control)wildcardPatternComposite, 5);
        formData.right = new FormAttachment(100, -5);
        promptsComposite.setLayoutData((Object)formData);
        this.firstRolePrompt = new Button((Composite)promptsComposite, 32);
        this.firstRolePrompt.setText(Messages.first_role_prompt);
        this.firstRolePrompt.setSelection(this.preferenceStore.getBoolean("first security role prompt"));
        this.showWarningPrompt = new Button((Composite)promptsComposite, 32);
        this.showWarningPrompt.setText(Messages.show_warning_dialog);
        this.showWarningPrompt.setSelection(!this.preferenceStore.getBoolean("do not show security warning"));
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        for (Button button : this.buttons) {
            this.preferenceStore.setValue(button.getText(), button.getSelection());
        }
        String wildcardText = this.wildcard.getText();
        if (!wildcardText.startsWith("/")) {
            wildcardText = "/" + wildcardText;
        }
        this.preferenceStore.setValue("wildcard pattern", wildcardText);
        this.preferenceStore.setValue("first security role prompt", this.firstRolePrompt.getSelection());
        this.preferenceStore.setValue("do not show security warning", !this.showWarningPrompt.getSelection());
        this.preferenceStore.setValue("faces to wildcards", this.facesToWildcard.getSelection());
        return super.performOk();
    }

    protected void performDefaults() {
        for (Button button : this.buttons) {
            button.setSelection(this.preferenceStore.getDefaultBoolean(button.getText()));
        }
        this.wildcard.setText(this.preferenceStore.getDefaultString("wildcard pattern"));
        this.firstRolePrompt.setSelection(this.preferenceStore.getDefaultBoolean("first security role prompt"));
        this.showWarningPrompt.setSelection(this.preferenceStore.getDefaultBoolean("do not show security warning"));
        this.facesToWildcard.setSelection(this.preferenceStore.getDefaultBoolean("faces to wildcards"));
        super.performDefaults();
    }
}

