/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.base.internal.common.ops;

import com.ibm.etools.webtools.security.base.internal.Logger;
import com.ibm.etools.webtools.security.base.internal.common.ops.ICommonOperations;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;

public class SecurityCommonOperationsRegistry {
    private HashMap contribByProjectFacet = new HashMap();
    private HashMap operationByProjectFacet = new HashMap();
    public static final SecurityCommonOperationsRegistry singleton = new SecurityCommonOperationsRegistry();
    private boolean initialized = false;

    SecurityCommonOperationsRegistry() {
        this.initialize();
    }

    private void initialize() {
        this.initialized = true;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] conf = reg.getConfigurationElementsFor("com.ibm.etools.webtools.security.base.commonOperations");
        int i = 0;
        while (i < conf.length) {
            IConfigurationElement[] elements;
            IConfigurationElement currentConf = conf[i];
            String configName = currentConf.getName();
            if (configName.equalsIgnoreCase("commonOperations") && (elements = currentConf.getChildren("projectFacets")) != null && elements.length > 0) {
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    String facetId = element.getAttribute("facetId");
                    if (this.contribByProjectFacet.containsKey(facetId)) {
                        Logger.log(4, "initialization(): Duplicate context contribution found for Facet Id. Duplicate ignored id = " + facetId);
                    } else {
                        this.contribByProjectFacet.put(facetId, currentConf);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static final ICommonOperations getCommonOperationsForProject(IProject project) {
        String j2eeProjectFacet = JavaEEProjectUtilities.getJ2EEProjectType((IProject)project);
        return singleton.getCommonOperationsForFacet(j2eeProjectFacet);
    }

    private ICommonOperations getCommonOperationsForFacet(String projectFacet) {
        if (!this.initialized) {
            this.initialize();
        }
        ICommonOperations result = null;
        if (this.operationByProjectFacet.containsKey(projectFacet)) {
            result = (ICommonOperations)this.operationByProjectFacet.get(projectFacet);
        } else {
            IConfigurationElement contrib = (IConfigurationElement)this.contribByProjectFacet.get(projectFacet);
            if (contrib != null) {
                try {
                    result = (ICommonOperations)contrib.createExecutableExtension("className");
                }
                catch (Exception exc) {
                    Logger.logException("Failed to create an instance of the Security Editor Context contribution whose id =" + projectFacet, exc);
                }
                if (result != null) {
                    this.operationByProjectFacet.put(projectFacet, result);
                }
            }
        }
        return result;
    }
}

