/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.base.internal.actions;

import com.ibm.etools.webtools.security.base.internal.common.ops.ICommonOperationsContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractViewerMenuAction
extends Action
implements Listener {
    protected Widget trigger = null;
    protected ICommonOperationsContext context;
    protected StructuredViewer viewer;
    private Menu menu;
    private boolean isMenuItem = false;
    protected boolean isDisposed = false;
    protected String label;
    private int index;
    protected boolean enabled = true;

    public AbstractViewerMenuAction(StructuredViewer viewer, Widget trigger, ICommonOperationsContext context) {
        this.context = context;
        this.viewer = viewer;
        this.trigger = trigger;
        trigger.addListener(13, (Listener)this);
        if (this.viewer != null) {
            viewer.addSelectionChangedListener((ISelectionChangedListener)new ViewerSelectionListener());
        }
        if (trigger instanceof MenuItem) {
            this.isMenuItem = true;
            this.menu = ((MenuItem)trigger).getParent();
            this.label = ((MenuItem)trigger).getText();
            this.index = this.menu.indexOf((MenuItem)trigger);
        }
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 13: {
                Widget ew = event.widget;
                if (ew == null) break;
                this.run();
            }
        }
    }

    public abstract void checkEnablement(ISelection var1);

    protected void enable() {
        if (this.isMenuItem) {
            this.enableMenuItem();
        } else if (this.trigger instanceof ToolItem) {
            ((ToolItem)this.trigger).setEnabled(true);
        } else {
            this.enableControl((Control)this.trigger);
        }
    }

    protected void disable() {
        if (this.isMenuItem) {
            this.disableMenuItem((MenuItem)this.trigger);
        } else if (this.trigger instanceof ToolItem) {
            ((ToolItem)this.trigger).setEnabled(false);
        } else {
            this.disableControl((Control)this.trigger);
        }
    }

    private void disableControl(Control control) {
        control.setEnabled(false);
    }

    private void enableControl(Control control) {
        control.setEnabled(true);
    }

    private void disableMenuItem(MenuItem menuItem) {
        if (!this.isDisposed) {
            this.trigger.removeListener(13, (Listener)this);
            this.trigger.dispose();
            this.isDisposed = true;
        }
    }

    private void enableMenuItem() {
        if (this.isDisposed) {
            int menuItemCount = this.menu.getItemCount();
            int menuPosition = this.index;
            if (this.index >= menuItemCount) {
                menuPosition = menuItemCount;
            }
            this.trigger = new MenuItem(this.menu, 8, menuPosition);
            ((MenuItem)this.trigger).setText(this.label);
            this.trigger.addListener(13, (Listener)this);
            this.isDisposed = false;
        }
    }

    protected IProject getProject() {
        return this.context.getProject();
    }

    private class ViewerSelectionListener
    implements ISelectionChangedListener {
        private ViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            AbstractViewerMenuAction.this.checkEnablement(event.getSelection());
        }
    }
}

