/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jsf.ui.internal.servicesdo;

import com.ibm.etools.common.ui.presentation.FilteredFileSelectionDialog;
import com.ibm.etools.sdo.jdbc.ui.internal.util.DialogUtil;
import com.ibm.etools.sdo.ui.internal.Status;
import com.ibm.etools.webedit.common.actions.CommandAction;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webtools.pagedatamodel.util.JavaTypeUtil;
import com.ibm.etools.webtools.sdo.jsf.ui.internal.data.ISDODataFromService;
import com.ibm.etools.webtools.sdo.jsf.ui.internal.data.SDOFromServiceRegionData;
import com.ibm.etools.webtools.sdo.jsf.ui.internal.datahandlers.CBECoreDataFactory;
import com.ibm.etools.webtools.sdo.jsf.ui.internal.datahandlers.CBXSDDataFactory;
import com.ibm.etools.webtools.sdo.jsf.ui.internal.datahandlers.CommonSDOServiceFactory;
import com.ibm.etools.webtools.sdo.jsf.ui.internal.servicesdo.SDOFromServiceWizard;
import com.ibm.etools.webtools.sdo.ui.internal.actions.JSFDropUtil;
import com.ibm.etools.webtools.sdo.ui.internal.plugin.SDOWebPlugin;
import com.ibm.etools.webtools.sdo.ui.internal.util.SourceEditorUtil;
import com.ibm.etools.webtools.wdo.jsf.ui.nls.ResourceHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;

public class LoadSDODescriptorWizardPage
extends WizardPage {
    private Text fFileLocationText;
    private Text fVariableNameText;
    private IFile fSelectedFile;
    private List fTypeList;
    private Button fIsListButton;
    public static String CHOOSE_SDO_METADATA_TITLE = ResourceHandler.CHOOSE_SDO_METADATA_TITLE;
    public static String CHOOSE_SDO_METADATA_MESSAGE = ResourceHandler.CHOOSE_SDO_METADATA_MESSAGE;
    public static String IS_LIST_OF_DATA = ResourceHandler.IS_LIST_OF_DATA;

    public LoadSDODescriptorWizardPage(String pageName) {
        this(pageName, null, null);
    }

    public LoadSDODescriptorWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setTitle(SDOFromServiceWizard.PAGE_TITLE);
        this.setDescription(SDOFromServiceWizard.PAGE_DESCRIPTION);
    }

    private ISDODataFromService getSDOData() {
        return ((SDOFromServiceWizard)this.getWizard()).getSDOData();
    }

    private HTMLEditDomain getHTMLEditDomain() {
        return ((SDOFromServiceWizard)this.getWizard()).getHTMLEditDomain();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(ResourceHandler.Property_Name);
        this.fVariableNameText = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fVariableNameText.setLayoutData((Object)gd);
        this.fVariableNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoadSDODescriptorWizardPage.this.propertyNameChanged();
            }
        });
        label = new Label(container, 0);
        label.setText(ResourceHandler.Descriptor_File);
        this.fFileLocationText = new Text(container, 2052);
        gd = new GridData(768);
        this.fFileLocationText.setLayoutData((Object)gd);
        this.fFileLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        this.fFileLocationText.setEditable(false);
        Button button = new Button(container, 8);
        button.setText(com.ibm.etools.sdo.jdbc.ui.internal.nls.ResourceHandler.SDOJDBCMediatorWizardPage_4);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoadSDODescriptorWizardPage.this.handleBrowse();
            }
        });
        this.fIsListButton = DialogUtil.createCheckBox((Composite)container, (String)IS_LIST_OF_DATA);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.fIsListButton.setLayoutData((Object)gd);
        this.fIsListButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoadSDODescriptorWizardPage.this.handleIsList();
            }
        });
        label = DialogUtil.createLabel((Composite)container, (String)ResourceHandler.SELECT_SDO_TYPE);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.fTypeList = DialogUtil.createListBox((Composite)container);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        this.fTypeList.setLayoutData((Object)gd);
        this.fTypeList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoadSDODescriptorWizardPage.this.handleTypeChoice();
            }
        });
        this.setControl((Control)container);
    }

    private void handleBrowse() {
        Object[] o;
        FilteredFileSelectionDialog dialog = new FilteredFileSelectionDialog(this.getShell(), CHOOSE_SDO_METADATA_TITLE, CHOOSE_SDO_METADATA_MESSAGE, new String[]{"xsd", "ecore"}, false);
        dialog.setInput((Object)this.getSDOData().getProject());
        dialog.setInitialSelection((Object)this.fSelectedFile);
        if (dialog.open() == 0 && (o = dialog.getResult()) != null) {
            this.fSelectedFile = (IFile)o[0];
            this.fFileLocationText.setText(this.fSelectedFile.getProjectRelativePath().toString());
            this.updateTypeList(this.fSelectedFile);
        }
    }

    private void handleIsList() {
        this.getSDOData().setReturnTypeName(this.fIsListButton.getSelection() ? "List" : "DataObject");
    }

    private void handleTypeChoice() {
        this.getSDOData().setTypeName(this.fTypeList.getSelection()[0]);
    }

    private void propertyNameChanged() {
        this.getSDOData().setId(this.fVariableNameText.getText());
        this.setPageComplete(this.validatePage());
    }

    private void updateTypeList(IFile file) {
        try {
            String filePath = file.getProjectRelativePath().toString();
            CommonSDOServiceFactory factory = null;
            if (filePath.endsWith("xsd")) {
                factory = new CBXSDDataFactory();
                this.getSDOData().setFactoryName("com.ibm.etools.sdo.datahandlers.XSDDataFactory");
            } else {
                factory = new CBECoreDataFactory();
                this.getSDOData().setFactoryName("com.ibm.etools.sdo.datahandlers.ECoreDataFactory");
            }
            factory.setProject(this.getSDOData().getProject());
            factory.setMetadataFileName(filePath);
            SDOFromServiceRegionData regionData = (SDOFromServiceRegionData)this.getSDOData().getTagData();
            regionData.setSDOToolsFactory(factory);
            EPackage pack = factory.getRootPackage();
            EList list = pack.getEClassifiers();
            this.fTypeList.removeAll();
            int i = 0;
            while (i < list.size()) {
                if (list.get(i) instanceof EClass) {
                    this.fTypeList.add(ExtendedMetaData.INSTANCE.getName((EClassifier)list.get(i)));
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    protected IStatus validateName() {
        IStatus newStatus;
        Status status = new Status(0, "");
        status = this.validateIdentifier();
        if (!(!status.isOK() && status.getSeverity() != 2 || (newStatus = this.validateUniqueName()).isOK() && status.getSeverity() == 2)) {
            status = newStatus;
        }
        return status;
    }

    protected boolean validatePage() {
        Status status = new Status(0, "");
        status = this.validateName();
        if (Status.getMessageProviderSeverity((int)status.getSeverity()) != 0 && status.getMessage() != null && !status.getMessage().equals("")) {
            this.setMessage(status.getMessage(), Status.getMessageProviderSeverity((int)status.getSeverity()));
        } else {
            this.setMessage(null);
        }
        return status.getSeverity() == 0 || status.getSeverity() == 2;
    }

    private IStatus validateIdentifier() {
        Status status = new Status(0, "");
        if (this.getSDOData().getId() == null) {
            status = new Status(1, "");
        } else if (this.getSDOData().getId().trim().equals("")) {
            status = new Status(4, com.ibm.etools.sdo.ui.internal.nls.ResourceHandler.NewRelationalObjectPage_identifier_empty);
        } else {
            IStatus newStatus;
            status = JavaConventions.validateIdentifier((String)this.getSDOData().getId());
            if (status.isOK() && this.fVariableNameText.isEnabled() && (!(newStatus = JavaTypeUtil.validatePropertyName((String)this.fVariableNameText.getText())).isOK() || status.getSeverity() != 2)) {
                status = newStatus;
            }
        }
        return status;
    }

    protected IStatus validateUniqueName() {
        Status status = new Status(0, "");
        if (this.fVariableNameText.isEnabled()) {
            if (!SourceEditorUtil.isUniqueName((String)this.getSDOData().getId(), (HTMLEditDomain)this.getHTMLEditDomain())) {
                status = new Status(4, com.ibm.etools.sdo.ui.internal.nls.ResourceHandler.NewRelationalObjectPage_identifier_inuse);
            } else {
                String conflictingName = this.isUniquePageCodeName();
                if (conflictingName != null) {
                    status = new Status(4, NLS.bind((String)com.ibm.etools.sdo.ui.internal.nls.ResourceHandler.CBSDOUtil_PageCodeConflict, (Object[])new String[]{conflictingName}));
                }
            }
        }
        return status;
    }

    private String isUniquePageCodeName() {
        String conflictingName = null;
        IDOMDocument xmldoc = this.getHTMLEditDomain().getActiveModel().getDocument();
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(SDOWebPlugin.getPluginID(), "JSFDropUtil");
        IConfigurationElement[] configElements = extPoint.getConfigurationElements();
        int i = 0;
        while (i < configElements.length) {
            IConfigurationElement configEl = configElements[i];
            String attVal = configEl.getAttribute("type");
            if (attVal.equals("CBData")) {
                JSFDropUtil jsfDropUtil;
                Object obj = null;
                try {
                    obj = configEl.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                HTMLEditDomain target = this.getHTMLEditDomain();
                if (target != null && obj instanceof CommandAction) {
                    ((CommandAction)obj).setTarget(target);
                }
                if (obj instanceof JSFDropUtil && (jsfDropUtil = (JSFDropUtil)obj).isJSFPage()) {
                    conflictingName = jsfDropUtil.getConflictingIdentifier(this.getSDOData().getId(), xmldoc);
                    break;
                }
            }
            ++i;
        }
        return conflictingName;
    }
}

