/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jsf.qev;

import com.ibm.etools.qev.actions.SimpleTextInsertAction;
import com.ibm.etools.sdo.ui.provisional.datahandlers.MediatorException;
import com.ibm.etools.webtools.codebehind.java.JavaCodeBehindPlugin;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.ISDOPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.SDOPageDataNode;
import com.ibm.etools.webtools.sdo.jsf.qev.FindSubRecordActionDialog;
import com.ibm.etools.webtools.wdo.jsf.ui.nls.ResourceHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.TreeItem;

public class CreateSubRecordActionDialog
extends FindSubRecordActionDialog {
    @Override
    protected void initializeTitleAndMessage() {
        this.setTitleImage(JavaCodeBehindPlugin.getDefault().getImage("wizban/createdataobject_wiz"));
        this.setTitle(ResourceHandler.WDORecordActionDialog_Create_sub_record_title);
        this.setMessage(ResourceHandler.WDORecordActionDialog_Create_sub_record_message);
    }

    @Override
    protected String getDialogTitle() {
        return ResourceHandler.WDORecordActionDialog_Create_sub_record_title;
    }

    @Override
    protected boolean appendPathIndex(IPageDataNode leaf, IPageDataNode currentNode) {
        return this.isDataList(currentNode);
    }

    @Override
    protected void okPressed() {
        String path;
        IPageDataNode node = (IPageDataNode)this.selectedNode;
        this.action.setVariableValue("dataVarName", this.variableNameText.getText());
        this.action.setVariableValue("featureName", this.computeFeature());
        this.action.setVariableValue("eclassName", this.computeEClass());
        String name = this.selectRecordComboBox.getText();
        StringBuffer namebuffer = new StringBuffer(name);
        namebuffer.replace(0, 1, name.substring(0, 1).toUpperCase());
        this.action.setVariableValue("recordName", namebuffer.toString());
        StringBuffer template = new StringBuffer();
        if (this.isRelationalNode(node)) {
            path = this.getJDBCPath(this.rootRecordNode, node.getParent());
            if (path.equals("")) {
                template.append("DataObject ${dataVarName}Parent = getRootDataObject(get${recordName}());");
            } else {
                template.append("DataObject ${dataVarName}Parent = getRootDataObject(get${recordName}()).getDataObject(\"${path}\"); ");
                this.action.setVariableValue("path", path);
            }
            template.append("\nDataObject ${dataVarName} = getRootDataObject(get${recordName}()).createDataObject(\"${eclassName}\");");
        } else {
            path = this.getPath(this.rootRecordNode, node.getParent());
            if (path.equals("")) {
                template.append("DataObject ${dataVarName}Parent = get${recordName}();");
            } else {
                template.append("DataObject ${dataVarName}Parent = get${recordName}().getDataObject(\"${path}\"); ");
                this.action.setVariableValue("path", path);
            }
            template.append("\nDataObject ${dataVarName} = ${dataVarName}Parent.createDataObject(\"${featureName}\");");
        }
        if (this.addingToList()) {
            template.append("\n${dataVarName}Parent.getList(\"${featureName}\").add(${dataVarName});");
        } else {
            template.append("\n${dataVarName}Parent.setDataObject(\"${featureName}\", ${dataVarName});");
        }
        String scopeValue = this.scopeComboBox.getText();
        if (scopeValue.equals(TREE)) {
            template.append("\nputTreeAttribute(\"${dataVarName}\", ${dataVarName});");
        } else if (!scopeValue.equals(LOCAL_VAR)) {
            if (scopeValue.equals(SESSION)) {
                this.action.setVariableValue("scopeMap", "SessionScope");
            } else if (scopeValue.equals(APPLICATION)) {
                this.action.setVariableValue("scopeMap", "ApplicationScope");
            } else if (scopeValue.equals(REQUEST)) {
                this.action.setVariableValue("scopeMap", "RequestScope");
            }
            template.append("\nget${scopeMap}().put(\"${dataVarName}\", ${dataVarName});");
        }
        template.append("\n");
        ((SimpleTextInsertAction)this.action).setContentString(template.toString());
        this.getFindSubRecordAction().addGetRootDataObjectsToPageCodeBase((IProgressMonitor)new NullProgressMonitor());
        this.setReturnCode(0);
        this.close();
    }

    private String computeFeature() {
        Object currentItem;
        String feature = null;
        TreeItem[] items = this.recSelection.getTree().getSelection();
        if (items.length > 0 && (currentItem = items[0].getData()) instanceof SDOPageDataNode) {
            SDOPageDataNode pageDataNode = (SDOPageDataNode)currentItem;
            feature = pageDataNode.getParentFeatureName();
        }
        return feature;
    }

    private String computeEClass() {
        Object currentItem;
        String feature = null;
        TreeItem[] items = this.recSelection.getTree().getSelection();
        if (items.length > 0 && (currentItem = items[0].getData()) instanceof ISDOPageDataNode) {
            ISDOPageDataNode pageDataNode = (ISDOPageDataNode)currentItem;
            try {
                feature = pageDataNode.getModel().getName();
            }
            catch (MediatorException e) {
                e.printStackTrace();
            }
        }
        return feature;
    }

    private boolean addingToList() {
        boolean isList = false;
        TreeItem[] items = this.recSelection.getTree().getSelection();
        if (items.length > 0 && items[0].getData() instanceof ISDOPageDataNode) {
            Object currentItem;
            ISDOPageDataNode node = (ISDOPageDataNode)items[0].getData();
            isList = this.isRelationalNode((IPageDataNode)node) && node.equals(this.rootRecordNode) ? true : ((ISDOPageDataNode)(currentItem = items[0].getData())).getDataType() == 2;
        }
        return isList;
    }
}

